/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import recoder.CrossReferenceServiceConfiguration;
import recoder.java.Declaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.Modifier;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.kit.ModifierKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTList;

public class Modify
extends TwoPassTransformation {
    private boolean isVisible;
    private int modifier;
    private Declaration decl;
    private int insertPosition = -1;
    private Modifier remove;
    private Modifier insert;

    public Modify(CrossReferenceServiceConfiguration sc, boolean isVisible, Declaration decl, int code) {
        super(sc);
        if (decl == null) {
            throw new IllegalArgumentException("Missing declaration");
        }
        this.isVisible = isVisible;
        this.decl = decl;
        this.modifier = code;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    private int getLastModifierPosition() {
        ASTList<DeclarationSpecifier> mods = this.decl.getDeclarationSpecifiers();
        if (mods == null) {
            return 0;
        }
        return mods.size();
    }

    private static boolean containsModifier(Declaration decl, Class<? extends Modifier> mod) {
        ASTList<DeclarationSpecifier> mods = decl.getDeclarationSpecifiers();
        if (mods == null) {
            return false;
        }
        int i = 0;
        while (i < mods.size()) {
            DeclarationSpecifier res = (DeclarationSpecifier)mods.get(i);
            if (mod.isInstance(res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public ProblemReport analyze() {
        this.insertPosition = 0;
        Modifier mod = ModifierKit.createModifier(this.getProgramFactory(), this.modifier);
        if (this.modifier != 512 && Modify.containsModifier(this.decl, mod.getClass())) {
            return this.setProblemReport(IDENTITY);
        }
        switch (this.modifier) {
            case 512: {
                this.remove = ModifierKit.getVisibilityModifier(this.decl);
                break;
            }
            case 1: {
                this.remove = ModifierKit.getVisibilityModifier(this.decl);
                if (this.remove instanceof Public) break;
                this.insert = this.getProgramFactory().createPublic();
                break;
            }
            case 4: {
                this.remove = ModifierKit.getVisibilityModifier(this.decl);
                if (this.remove instanceof Protected) break;
                this.insert = this.getProgramFactory().createProtected();
                break;
            }
            case 2: {
                this.remove = ModifierKit.getVisibilityModifier(this.decl);
                if (this.remove instanceof Private) break;
                this.insert = this.getProgramFactory().createPrivate();
                break;
            }
            case 8: {
                if (ModifierKit.getVisibilityModifier(this.decl) != null) {
                    ++this.insertPosition;
                }
                this.insert = this.getProgramFactory().createStatic();
                break;
            }
            case 16: {
                if (ModifierKit.getVisibilityModifier(this.decl) != null) {
                    ++this.insertPosition;
                }
                if (Modify.containsModifier(this.decl, Static.class)) {
                    ++this.insertPosition;
                }
                this.insert = this.getProgramFactory().createFinal();
                break;
            }
            case 1024: {
                if (ModifierKit.getVisibilityModifier(this.decl) != null) {
                    ++this.insertPosition;
                }
                this.insert = this.getProgramFactory().createAbstract();
                break;
            }
            case 32: {
                this.insertPosition = this.getLastModifierPosition();
                this.insert = this.getProgramFactory().createSynchronized();
                break;
            }
            case 128: {
                this.insertPosition = this.getLastModifierPosition();
                this.insert = this.getProgramFactory().createTransient();
                break;
            }
            case 2048: {
                this.insertPosition = this.getLastModifierPosition();
                this.insert = this.getProgramFactory().createStrictFp();
                break;
            }
            case 64: {
                this.insertPosition = this.getLastModifierPosition();
                this.insert = this.getProgramFactory().createVolatile();
                break;
            }
            case 256: {
                this.insertPosition = this.getLastModifierPosition();
                this.insert = this.getProgramFactory().createNative();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modifier code " + this.modifier);
            }
        }
        return this.setProblemReport(NO_PROBLEM);
    }

    @Override
    public void transform() {
        super.transform();
        if (this.remove != null) {
            this.detach(this.remove);
        }
        if (this.insert != null) {
            this.attach(this.insert, this.decl, this.insertPosition);
        }
    }

    public Modifier getDetached() {
        return this.remove;
    }

    public Modifier getAttached() {
        return this.insert;
    }
}

