/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.pattern;

import recoder.ModelElement;
import recoder.ModelException;
import recoder.ParserException;
import recoder.java.Identifier;
import recoder.java.JavaProgramFactory;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.kit.MethodKit;
import recoder.kit.pattern.DesignPattern;
import recoder.kit.pattern.InconsistentPatternException;
import recoder.list.generic.ASTArrayList;

public class FactoryMethod
implements DesignPattern {
    private MethodDeclaration producer;
    private ConstructorDeclaration product;

    public FactoryMethod(ConstructorDeclaration product) {
        if (product == null) {
            throw new IllegalArgumentException("A factory method requires a product method");
        }
        this.product = product;
        this.createProducer();
    }

    public FactoryMethod(ClassDeclaration product) {
        if (product == null) {
            throw new IllegalArgumentException("A factory method requires a product");
        }
        try {
            this.product = product.getFactory().parseConstructorDeclaration("public " + product.getName() + "(){}");
        }
        catch (ParserException pe) {
            System.err.println(pe);
        }
        this.createProducer();
    }

    public MethodDeclaration getProducer() {
        return this.producer;
    }

    public ConstructorDeclaration getProduct() {
        return this.product;
    }

    protected void createProducer() {
        JavaProgramFactory factory = this.product.getFactory();
        ConstructorDeclaration clone = null;
        try {
            clone = factory.parseConstructorDeclaration(this.product.toSource());
        }
        catch (ParserException pe) {
            System.err.println(pe);
        }
        Identifier name = clone.getIdentifier();
        this.producer = factory.createMethodDeclaration(clone.getDeclarationSpecifiers(), factory.createTypeReference(name), factory.createIdentifier("create" + name.getText()), clone.getParameters(), clone.getThrown());
        ASTArrayList<boolean> statements = new ASTArrayList<boolean>(true);
        statements.add((boolean)factory.createReturn(MethodKit.createNew(clone)));
        this.producer.setBody(factory.createStatementBlock(statements));
    }

    @Override
    public void validate() throws ModelException {
        if (this.producer == null) {
            throw new InconsistentPatternException("Factory Method pattern requires a producer");
        }
        if (this.product == null) {
            throw new InconsistentPatternException("Factory Method pattern requires a product");
        }
        if (!this.producer.getReturnType().getName().equals(this.product.getMemberParent().getName())) {
            throw new InconsistentPatternException("Factory Method producer must create correct product type");
        }
    }

    @Override
    public int getParticipantCount() {
        int res = 0;
        if (this.producer != null) {
            ++res;
        }
        if (this.product != null) {
            ++res;
        }
        return res;
    }

    @Override
    public ModelElement getParticipantAt(int index) {
        if (this.producer != null) {
            if (index == 0) {
                return this.producer;
            }
            --index;
        }
        if (this.product != null && index == 0) {
            return this.product;
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

