/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.pattern;

import java.util.ArrayList;
import java.util.List;
import recoder.ModelElement;
import recoder.ModelException;
import recoder.abstraction.Constructor;
import recoder.abstraction.DefaultConstructor;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.kit.pattern.DesignPattern;
import recoder.kit.pattern.FactoryMethod;
import recoder.kit.pattern.InconsistentPatternException;
import recoder.list.generic.ASTList;

public class Factory
implements DesignPattern {
    private List<FactoryMethod> factoryMethods;

    public Factory(List<FactoryMethod> factoryMethods) {
        this.factoryMethods = factoryMethods;
    }

    public Factory(ClassDeclaration factoryClass, List<TypeDeclaration> products) {
        if (factoryClass == null || products == null) {
            throw new NullPointerException();
        }
        int n = products.size();
        this.factoryMethods = new ArrayList<FactoryMethod>(n);
        int i = 0;
        while (i < n) {
            TypeDeclaration td = products.get(i);
            if (td instanceof ClassDeclaration) {
                this.addFactoryMethods((ClassDeclaration)td);
            }
            ++i;
        }
        ASTList<MemberDeclaration> members = factoryClass.getMembers();
        int i2 = 0;
        while (i2 < this.factoryMethods.size()) {
            members.add(this.factoryMethods.get(i2).getProducer());
            ++i2;
        }
        factoryClass.makeParentRoleValid();
    }

    public void addFactoryMethods(ClassDeclaration decl) {
        List<? extends Constructor> cl = decl.getConstructors();
        int i = 0;
        while (i < cl.size()) {
            if (cl.get(i) instanceof DefaultConstructor) {
                FactoryMethod m = new FactoryMethod(decl);
                this.addFactoryMethod(m);
                return;
            }
            ConstructorDeclaration cons = (ConstructorDeclaration)cl.get(i);
            if (cons.isPublic()) {
                FactoryMethod m = new FactoryMethod(cons);
                this.addFactoryMethod(m);
            }
            ++i;
        }
    }

    public void addFactoryMethod(FactoryMethod m) {
        this.factoryMethods.add(m);
    }

    public List<FactoryMethod> getFactoryMethods() {
        return this.factoryMethods;
    }

    @Override
    public int getParticipantCount() {
        return this.factoryMethods != null ? this.factoryMethods.size() : 0;
    }

    @Override
    public ModelElement getParticipantAt(int index) {
        if (this.factoryMethods != null) {
            return this.factoryMethods.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void validate() throws ModelException {
        if (this.factoryMethods == null || this.factoryMethods.size() == 0) {
            throw new InconsistentPatternException("Factories must contain at least one factory method");
        }
        TypeDeclaration parent = null;
        int i = 0;
        int s = this.factoryMethods.size();
        while (i < s) {
            FactoryMethod m = this.factoryMethods.get(i);
            m.validate();
            if (parent == null) {
                parent = m.getProducer().getMemberParent();
            } else if (parent != m.getProducer().getMemberParent()) {
                throw new InconsistentPatternException("Factory methods must be members of the same type");
            }
            ++i;
        }
    }
}

