/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import recoder.ModelElement;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Package;
import recoder.abstraction.Type;
import recoder.convenience.ForestWalker;
import recoder.convenience.Format;
import recoder.convenience.ModelElementFilter;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Import;
import recoder.java.JavaProgramFactory;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceInfix;
import recoder.kit.MiscKit;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;
import recoder.util.Order;

public class UnitKit {
    private UnitKit() {
    }

    public static CompilationUnit getCompilationUnit(ProgramElement p) {
        while (p != null) {
            if (p instanceof CompilationUnit) {
                return (CompilationUnit)p;
            }
            p = p.getASTParent();
        }
        return null;
    }

    public static void assertPartOf(final ProgramElement pe, List<CompilationUnit> cu) {
        ForestWalker tw = new ForestWalker(cu);
        ModelElementFilter mef = new ModelElementFilter(){

            @Override
            public boolean accept(ModelElement e) {
                return e == pe;
            }
        };
        boolean res = tw.next(mef);
        if (tw.next(mef)) {
            throw new RuntimeException("ProgramElement found twice!?");
        }
        if (!res) {
            throw new RuntimeException("ProgramElement not part of CompilationUnit");
        }
    }

    private static ClassType getNecessaryImportedType(CrossReferenceSourceInfo xi, Import imp) {
        if (imp.isMultiImport()) {
            return null;
        }
        TypeReference tr = imp.getTypeReference();
        ClassType ct = (ClassType)xi.getType(tr);
        if (ct == null) {
            throw new RuntimeException("No type found for " + Format.toString("%c \"%s\" @%p in %f", tr));
        }
        if (TypeKit.getReferences(xi, ct, imp.getASTParent(), false).size() > 1) {
            return ct;
        }
        return null;
    }

    private static boolean isNecessaryMultiTypeImport(CrossReferenceSourceInfo xrsi, Import imp, Set<ClassType> coveredTypes) {
        if (!imp.isMultiImport()) {
            return false;
        }
        if (imp.isStaticImport()) {
            return true;
        }
        TypeReferenceInfix ref = imp.getReference();
        CompilationUnit cu = imp.getParent();
        List<? extends ClassType> types = ref instanceof PackageReference ? xrsi.getPackage((PackageReference)ref).getTypes() : ((ClassType)xrsi.getType((TypeReference)ref)).getTypes();
        boolean result = false;
        int j = types.size() - 1;
        while (j >= 0 && !result) {
            ClassType ct = types.get(j);
            if (!coveredTypes.contains(ct)) {
                List<TypeReference> refs = TypeKit.getReferences(xrsi, ct, cu, false);
                int k = refs.size() - 1;
                while (k >= 0) {
                    if (refs.get(k).getASTParent().getASTParent() == cu) {
                        refs.remove(k);
                    }
                    --k;
                }
                result = !refs.isEmpty();
            }
            --j;
        }
        return result;
    }

    public static List<Import> getUnnecessaryImports(CrossReferenceSourceInfo xrsi, CompilationUnit cu) {
        Import imp;
        Debug.assertNonnull((Object)xrsi, cu);
        ASTList<Import> il = cu.getImports();
        if (il == null || il.isEmpty()) {
            return new ArrayList<Import>(0);
        }
        ArrayList<Import> removalList = new ArrayList<Import>();
        HashSet<ClassType> coveredTypes = new HashSet<ClassType>();
        int i = 0;
        int s = il.size();
        while (i < s) {
            imp = (Import)il.get(i);
            if (!imp.isStaticImport() && !imp.isMultiImport()) {
                ClassType ct = UnitKit.getNecessaryImportedType(xrsi, imp);
                if (ct != null) {
                    coveredTypes.add(ct);
                } else {
                    removalList.add(imp);
                }
            }
            ++i;
        }
        i = 0;
        s = il.size();
        while (i < s) {
            imp = (Import)il.get(i);
            if (!imp.isStaticImport() && imp.isMultiImport() && !UnitKit.isNecessaryMultiTypeImport(xrsi, imp, coveredTypes)) {
                removalList.add(imp);
            }
            ++i;
        }
        return removalList;
    }

    public static void removeUnusedImports(ChangeHistory ch, CrossReferenceSourceInfo xrsi, CompilationUnit cu) {
        Debug.assertNonnull(ch);
        List<Import> removalList = UnitKit.getUnnecessaryImports(xrsi, cu);
        int i = removalList.size() - 1;
        while (i >= 0) {
            MiscKit.remove(ch, removalList.get(i));
            --i;
        }
    }

    public static void normalizeImports(ChangeHistory ch, CrossReferenceSourceInfo xrsi, CompilationUnit cu, boolean removeMultiTypeImports, boolean removeSingleTypeImports, boolean addJavaLangImports, boolean addDefaultPackageImports) {
        Debug.assertNonnull((Object)xrsi, cu);
        HashSet<ClassType> importTypes = new HashSet<ClassType>();
        Package unitPackage = cu.getPrimaryTypeDeclaration().getPackage();
        TreeWalker tw = new TreeWalker(cu);
        int i = cu.getTypeDeclarationCount() - 1;
        while (i >= 0) {
            tw.reset(cu.getTypeDeclarationAt(i));
            while (tw.next(TypeReference.class)) {
                TypeReference tr = (TypeReference)tw.getProgramElement();
                Type type = xrsi.getType(tr);
                while (type instanceof ArrayType) {
                    type = ((ArrayType)type).getBaseType();
                }
                if (!(type instanceof ClassType) || type instanceof TypeDeclaration && MiscKit.contains(cu, (TypeDeclaration)type) || !addDefaultPackageImports && ((ClassType)type).getPackage() == unitPackage || !addJavaLangImports && type.getFullName().startsWith("java.lang.")) continue;
                importTypes.add((ClassType)type);
            }
            --i;
        }
        ASTList<Import> il = cu.getImports();
        int ilsize = il == null ? 0 : il.size();
        ClassType[] classTypes = new ClassType[ilsize];
        HashSet<ClassType> importedTypes = new HashSet<ClassType>();
        int i2 = ilsize - 1;
        while (i2 >= 0) {
            Import imp = (Import)il.get(i2);
            if (!imp.isMultiImport()) {
                ClassType ct;
                TypeReference tr = imp.getTypeReference();
                classTypes[i2] = ct = (ClassType)xrsi.getType(tr);
                importedTypes.add(ct);
            }
            --i2;
        }
        HashSet<ClassType> commonTypes = new HashSet<ClassType>(importTypes.size());
        commonTypes.addAll(importTypes);
        commonTypes.retainAll(importedTypes);
        importTypes.removeAll(commonTypes);
        importedTypes.removeAll(commonTypes);
        int i3 = ilsize - 1;
        while (i3 >= 0) {
            Import imp = (Import)il.get(i3);
            if (!imp.isStaticImport() && (imp.isMultiImport() && removeMultiTypeImports || !imp.isMultiImport() && removeSingleTypeImports && importedTypes.contains(classTypes[i3]))) {
                MiscKit.remove(ch, imp);
            }
            --i3;
        }
        for (ClassType ct : importedTypes) {
            UnitKit.appendImport(ch, cu, ct);
        }
    }

    public static Import appendImport(ChangeHistory ch, CompilationUnit cu, ClassType ct) {
        return UnitKit.appendImport(ch, cu, ct.getFullName());
    }

    public static Import appendImport(ChangeHistory ch, CompilationUnit cu, String typeName) {
        Debug.assertNonnull((Object)cu, typeName);
        JavaProgramFactory factory = cu.getFactory();
        TypeReference ref = TypeKit.createTypeReference((ProgramFactory)factory, typeName);
        Import newImport = factory.createImport(ref, false);
        newImport.makeAllParentRolesValid();
        MiscKit.append(ch, cu, newImport);
        return newImport;
    }

    public static Import ensureImport(ChangeHistory ch, SourceInfo si, String typeName, ProgramElement context) {
        Debug.assertNonnull(si, typeName, context);
        Debug.assertBoolean(typeName.length() > 0);
        if (si.getType(typeName, context) != null) {
            return null;
        }
        return UnitKit.appendImport(ch, UnitKit.getCompilationUnit(context), typeName);
    }

    public static void ensureImports(ChangeHistory ch, SourceInfo si, ProgramElement root) {
        Debug.assertNonnull((Object)si, root);
        CompilationUnit cu = UnitKit.getCompilationUnit(root);
        TreeWalker tw = new TreeWalker(root);
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof TypeReference)) continue;
            String name = Naming.toPathName((TypeReference)pe);
            while (name.endsWith("]")) {
                name = name.substring(0, name.length() - 2);
            }
            Type type = si.getType(name, pe);
            if (type != null) continue;
            UnitKit.ensureImport(ch, si, name, cu);
        }
    }

    public static void sortImports(ChangeHistory ch, CompilationUnit cu) {
        Debug.assertNonnull(cu);
        ASTList<Import> il = cu.getImports();
        if (il == null) {
            return;
        }
        String[] names = new String[il.size()];
        int i = 0;
        while (i < il.size()) {
            Import imp = (Import)il.get(i);
            if (imp.isStaticImport() && !imp.isMultiImport()) {
                MethodReference ref = (MethodReference)((Object)imp.getReference());
                names[i] = Naming.toPathName(ref.getReferencePrefix(), "." + ref.getName());
            } else {
                names[i] = Naming.toPathName(imp.getReference());
            }
            ++i;
        }
        i = 1;
        while (i < names.length) {
            String x = names[i];
            int j = i - 1;
            while (j >= 0 && Order.LEXICAL.greater(names[j], x)) {
                names[j + 1] = names[j];
                --j;
            }
            names[j + 1] = x;
            if (j + 1 != i) {
                Import oldImp = (Import)il.get(i);
                il.remove(i);
                il.add(j + 1, oldImp);
                if (ch != null) {
                    ch.detached(oldImp, cu, i);
                    ch.attached(oldImp);
                }
            }
            ++i;
        }
        String prefix = null;
        int i2 = 0;
        while (i2 < names.length) {
            Import imp;
            SourceElement.Position pos;
            String newPrefix;
            String name = names[i2];
            int dot = name.indexOf(46);
            String string = newPrefix = dot >= 0 ? name.substring(0, dot) : name;
            if (i2 > 0 && !prefix.equals(newPrefix) && (pos = (imp = (Import)il.get(i2)).getFirstElement().getRelativePosition()).getLine() == 0) {
                pos.setLine(1);
                imp.getFirstElement().setRelativePosition(pos);
            }
            prefix = newPrefix;
            ++i2;
        }
    }
}

