/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Member;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.convenience.TreeWalker;
import recoder.java.Identifier;
import recoder.java.JavaProgramFactory;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.reference.FieldReference;
import recoder.java.reference.TypeReference;
import recoder.kit.MethodKit;
import recoder.kit.MiscKit;
import recoder.kit.NameClashException;
import recoder.kit.PackageKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.DefaultErrorHandler;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class TypeKit {
    private TypeKit() {
    }

    public static TypeReference createTypeReference(ConstructorDeclaration decl) {
        JavaProgramFactory f = decl.getFactory();
        TypeReference result = f.createTypeReference(f.createIdentifier(decl.getName()));
        result.makeAllParentRolesValid();
        return result;
    }

    public static TypeReference createTypeReference(ProgramFactory f, String qualifiedName) {
        return TypeKit.createTypeReference(f, qualifiedName, 0);
    }

    public static TypeReference createTypeReference(ProgramFactory f, String qualifiedName, int dim) {
        int idx = qualifiedName.indexOf(91);
        int dimm = 0;
        if (idx > -1) {
            dimm = (qualifiedName.length() - idx) / 2;
            qualifiedName = qualifiedName.substring(0, idx);
        }
        TypeReference tr = MiscKit.createUncollatedReferenceQualifier(f, qualifiedName).toTypeReference();
        tr.setDimensions(dimm + dim);
        return tr;
    }

    public static ASTList<TypeArgumentDeclaration> makeTypeArgRef(ProgramFactory f, List<? extends TypeArgument> tas) {
        ASTArrayList<int> res = new ASTArrayList<int>(tas.size());
        for (TypeArgument typeArgument : tas) {
            TypeReference tr = null;
            if (typeArgument.getWildcardMode() != TypeArgument.WildcardMode.Any) {
                tr = TypeKit.createTypeReference(f, typeArgument.getTypeName());
            }
            if (typeArgument.getTypeArguments() != null) {
                tr.setTypeArguments(TypeKit.makeTypeArgRef(f, typeArgument.getTypeArguments()));
            }
            res.add((int)f.createTypeArgumentDeclaration(tr, typeArgument.getWildcardMode()));
        }
        return res;
    }

    public static ASTList<TypeArgumentDeclaration> makeTypeArgRef(SourceInfo si, List<? extends TypeArgument> tas, ProgramElement context) {
        ASTArrayList<int> res = new ASTArrayList<int>(tas.size());
        for (TypeArgument typeArgument : tas) {
            TypeReference tr = null;
            if (typeArgument.getWildcardMode() != TypeArgument.WildcardMode.Any) {
                tr = TypeKit.createTypeReference(si, si.getType(typeArgument.getTypeName(), context), context);
            }
            if (typeArgument.getTypeArguments() != null) {
                tr.setTypeArguments(TypeKit.makeTypeArgRef(si, typeArgument.getTypeArguments(), context));
            }
            res.add((int)context.getFactory().createTypeArgumentDeclaration(tr, typeArgument.getWildcardMode()));
        }
        return res;
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t, int dim, boolean addTypeArgs) {
        while (dim-- > 0) {
            t = t.createArrayType();
        }
        return TypeKit.createTypeReference(f, t, addTypeArgs);
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t, boolean addTypeArgs) {
        TypeReference result = null;
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            result = TypeKit.createTypeReference(f, pt.getGenericType());
            if (addTypeArgs) {
                result.setTypeArguments(TypeKit.makeTypeArgRef(f, pt.getAllTypeArgs()));
            }
        } else if (t instanceof PrimitiveType || t instanceof TypeParameter) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
        } else if (t instanceof ArrayType) {
            result = TypeKit.createTypeReference(f, ((ArrayType)t).getBaseType());
            result.setDimensions(result.getDimensions() + 1);
        } else if (t instanceof ClassType) {
            if (t instanceof ErasedType) {
                t = ((ErasedType)t).getGenericType();
            }
            result = f.createTypeReference(f.createIdentifier(t.getName()));
            ClassTypeContainer ctc = ((ClassType)t).getContainer();
            if (ctc instanceof Package) {
                result.setReferencePrefix(PackageKit.createPackageReference(f, (Package)ctc));
            } else if (ctc instanceof ClassType) {
                result.setReferencePrefix(TypeKit.createTypeReference(f, (ClassType)ctc));
            }
        }
        if (result == null) {
            throw new RuntimeException("Unknown type: " + t.getClass().getName());
        }
        result.makeParentRoleValid();
        return result;
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t) {
        return TypeKit.createTypeReference(f, t, true);
    }

    public static TypeReference createTypeReference(ProgramFactory f, Type t, int dim) {
        while (dim-- > 0) {
            t = t.createArrayType();
        }
        return TypeKit.createTypeReference(f, t);
    }

    public static TypeReference createTypeReference(SourceInfo si, Type t, ProgramElement context) {
        return TypeKit.createTypeReference(si, t, context, true);
    }

    public static TypeReference createTypeReference(SourceInfo si, Type t, ProgramElement context, boolean addTypeArgs) {
        TypeReference result = null;
        ProgramFactory f = context.getFactory();
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            result = TypeKit.createTypeReference(si, (Type)pt.getGenericType(), context);
            if (addTypeArgs) {
                result.setTypeArguments(TypeKit.makeTypeArgRef(si, pt.getAllTypeArgs(), context));
            }
        } else if (t instanceof PrimitiveType || t instanceof TypeParameter) {
            result = f.createTypeReference(f.createIdentifier(t.getName()));
        } else if (t instanceof ArrayType) {
            result = TypeKit.createTypeReference(si, ((ArrayType)t).getBaseType(), context);
            result.setDimensions(result.getDimensions() + 1);
        } else if (t instanceof ClassType) {
            if (t instanceof ErasedType) {
                t = ((ErasedType)t).getGenericType();
            }
            result = f.createTypeReference(f.createIdentifier(t.getName()));
            ClassTypeContainer ctc = ((ClassType)t).getContainer();
            ErrorHandler handler = si.getServiceConfiguration().getProjectSettings().getErrorHandler();
            class TempErrorHandler
            extends DefaultErrorHandler {
                boolean errorOccured = false;

                TempErrorHandler() {
                }

                @Override
                public void modelUpdated(EventObject event) {
                }

                @Override
                public void reportError(Exception e) {
                    this.errorOccured = true;
                }
            }
            TempErrorHandler eh = new TempErrorHandler();
            si.getServiceConfiguration().getProjectSettings().setErrorHandler(eh);
            if (ctc != null && si.getType(t.getName(), context) != t || eh.errorOccured) {
                if (ctc instanceof Package) {
                    result.setReferencePrefix(PackageKit.createPackageReference(f, (Package)ctc));
                } else if (ctc instanceof ClassType) {
                    result.setReferencePrefix(TypeKit.createTypeReference(f, (ClassType)ctc));
                }
            }
            si.getServiceConfiguration().getProjectSettings().setErrorHandler(handler);
        }
        if (result == null) {
            throw new RuntimeException("Cannot handle " + t.getClass());
        }
        result.makeAllParentRolesValid();
        return result;
    }

    public static InterfaceDeclaration createAbstractSuperClass(NameInfo ni, ClassDeclaration cdecl, String abstractsupername) throws NameClashException {
        String message = "Sorry, only public classes which are neither interfaces nor enums can be transformed.";
        Debug.assertBoolean(cdecl.isPublic() && !cdecl.isInterface() && !cdecl.isEnumType(), message);
        if (ni.getType(abstractsupername) != null) {
            throw new NameClashException("Error: Name " + abstractsupername + "is already declared.");
        }
        JavaProgramFactory pf = cdecl.getFactory();
        ASTArrayList<boolean> imembers = new ASTArrayList<boolean>(true);
        ASTList<MemberDeclaration> cmems = cdecl.getMembers();
        if (cmems != null) {
            int i = 0;
            int s = cmems.size();
            while (i < s) {
                MemberDeclaration cmemd = (MemberDeclaration)cmems.get(i);
                if (cmemd.isPublic()) {
                    if (cmemd instanceof FieldDeclaration) {
                        if (((FieldDeclaration)cmemd).isFinal() && cmemd.isStatic()) {
                            FieldDeclaration d = (FieldDeclaration)cmemd.deepClone();
                            ASTList<FieldSpecification> vars = d.getFieldSpecifications();
                            int j = 0;
                            int z = vars.size();
                            while (j < z) {
                                if (((FieldSpecification)vars.get(j)).getInitializer() == null) {
                                    vars.remove(j);
                                    --j;
                                    --z;
                                }
                                ++j;
                            }
                            if (vars.size() > 0) {
                                imembers.add((boolean)d);
                            }
                        }
                    } else if (cmemd instanceof MethodDeclaration) {
                        MethodDeclaration md = (MethodDeclaration)cmemd;
                        if (!md.isStatic() && md.isPublic() && !(md instanceof ConstructorDeclaration)) {
                            imembers.add((boolean)MethodKit.createAbstractMethodDeclaration(md, true));
                        }
                    } else if (cmemd instanceof TypeDeclaration) {
                        imembers.add((boolean)((TypeDeclaration)cmemd.deepClone()));
                    }
                }
                ++i;
            }
            if (!imembers.isEmpty()) {
                Identifier iid = pf.createIdentifier(abstractsupername);
                VisibilityModifier vis = cdecl.getVisibilityModifier();
                ASTArrayList<boolean> imods = null;
                if (vis != null) {
                    imods = new ASTArrayList<boolean>(true);
                    imods.add((boolean)((DeclarationSpecifier)vis.deepClone()));
                }
                InterfaceDeclaration idecl = pf.createInterfaceDeclaration(imods, iid, null, imembers);
                ASTList<Object> itypes = new ASTArrayList<boolean>(true);
                TypeReference iref = pf.createTypeReference(iid);
                Implements impl = cdecl.getImplementedTypes();
                if (impl == null) {
                    impl = new Implements(iref);
                } else {
                    itypes = impl.getSupertypes();
                    itypes.add((boolean)iref);
                    impl.setSupertypes(itypes);
                }
                cdecl.setImplementedTypes(impl);
                return idecl;
            }
            return null;
        }
        return null;
    }

    public static InterfaceDeclaration createInterfaceDeclaration(ClassDeclaration decl) {
        JavaProgramFactory factory = decl.getFactory();
        InterfaceDeclaration res = factory.createInterfaceDeclaration();
        res.setIdentifier(factory.createIdentifier("Abstract" + decl.getName()));
        VisibilityModifier vis = decl.getVisibilityModifier();
        if (vis != null) {
            ASTArrayList<boolean> imods = new ASTArrayList<boolean>(true);
            imods.add((boolean)((DeclarationSpecifier)vis.deepClone()));
            res.setDeclarationSpecifiers(imods);
        }
        ASTArrayList<MemberDeclaration> imembers = new ASTArrayList<MemberDeclaration>();
        res.setMembers(imembers);
        ASTList<MemberDeclaration> cmems = decl.getMembers();
        if (cmems == null) {
            return res;
        }
        int i = 0;
        int s = cmems.size();
        while (i < s) {
            MemberDeclaration cmemd = (MemberDeclaration)cmems.get(i);
            if (cmemd.isPublic()) {
                if (cmemd instanceof FieldDeclaration) {
                    if (((FieldDeclaration)cmemd).isFinal() && cmemd.isStatic()) {
                        FieldDeclaration d = (FieldDeclaration)cmemd.deepClone();
                        ASTList<FieldSpecification> vars = d.getFieldSpecifications();
                        int j = 0;
                        int z = vars.size();
                        while (j < z) {
                            if (((FieldSpecification)vars.get(j)).getInitializer() == null) {
                                vars.remove(j);
                                --j;
                                --z;
                            }
                            ++j;
                        }
                        if (vars.size() > 0) {
                            imembers.add(d);
                        }
                    }
                } else if (cmemd instanceof MethodDeclaration) {
                    if (!(cmemd instanceof ConstructorDeclaration) && !cmemd.isStatic()) {
                        imembers.add(MethodKit.createAbstractMethodDeclaration((MethodDeclaration)cmemd, true));
                    }
                } else if (cmemd instanceof TypeDeclaration) {
                    imembers.add((TypeDeclaration)cmemd.deepClone());
                }
            }
            ++i;
        }
        return res;
    }

    public static ClassDeclaration createAdapterClass(String adapterName, ClassDeclaration classDecl) {
        JavaProgramFactory factory = classDecl.getFactory();
        FieldReference delegationObject = new FieldReference(factory.createIdentifier("delegationObject" + classDecl.getName()));
        ClassDeclaration adapterClass = factory.createClassDeclaration(new ASTArrayList<DeclarationSpecifier>(), factory.createIdentifier(adapterName), factory.createExtends(), factory.createImplements(), new ASTArrayList<MemberDeclaration>());
        int i2 = 0;
        while (i2 < classDecl.getMembers().size()) {
            MethodDeclaration method;
            MemberDeclaration member = (MemberDeclaration)classDecl.getMembers().get(i2);
            if (member instanceof MethodDeclaration && (method = (MethodDeclaration)member).isPublic()) {
                Debug.info(2, "adapting public method " + method.getName());
                MethodDeclaration clone = MethodKit.createAdapterMethod(delegationObject, method);
                if (clone != null) {
                    adapterClass.getMembers().add(clone);
                }
            }
            ++i2;
        }
        return adapterClass;
    }

    public static List<TypeReference> getInfluencedReferences(CrossReferenceSourceInfo xr, String newTypeName, NonTerminalProgramElement context) {
        Debug.assertNonnull(xr, newTypeName, context);
        context = MiscKit.getScopeDefiningElement(context);
        Type t = xr.getType(newTypeName, context);
        if (t == null) {
            return new ArrayList<TypeReference>(0);
        }
        List<TypeReference> list = xr.getReferences(t);
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        int i = list.size() - 1;
        while (i >= 0) {
            TypeReference tr = list.get(i);
            if (MiscKit.contains(context, tr)) {
                result.add(tr);
            }
            --i;
        }
        return result;
    }

    public static List<TypeReference> getReferences(CrossReferenceSourceInfo xr, Type t, NonTerminalProgramElement root, boolean scanTree) {
        Debug.assertNonnull(xr, t, root);
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        if (scanTree) {
            TreeWalker tw = new TreeWalker(root);
            while (tw.next(TypeReference.class)) {
                TypeReference tr = (TypeReference)tw.getProgramElement();
                if (xr.getType(tr) != t) continue;
                result.add(tr);
            }
        } else {
            List<TypeReference> refs = xr.getReferences(t);
            int i = 0;
            int s = refs.size();
            while (i < s) {
                TypeReference tr = refs.get(i);
                if (MiscKit.contains(root, tr)) {
                    result.add(tr);
                }
                ++i;
            }
        }
        return result;
    }

    public static List<Member> getMembers(ClassTypeContainer ctc) {
        List<Member> mlist;
        ArrayList<Member> result = new ArrayList<Member>();
        if (ctc instanceof ClassType) {
            ClassType ct = (ClassType)ctc;
            mlist = ct.getConstructors();
            if (mlist != null) {
                result.addAll(mlist);
            }
            if ((mlist = ct.getFields()) != null) {
                result.addAll(mlist);
            }
            if ((mlist = ct.getMethods()) != null) {
                result.addAll(mlist);
            }
        }
        if ((mlist = ctc.getTypes()) != null) {
            result.addAll(mlist);
        }
        return result;
    }

    public static ClassType getSuperClass(NameInfo ni, ClassType ct) {
        if (!ct.isInterface()) {
            List<ClassType> ctl = ct.getSupertypes();
            int i = 0;
            while (i < ctl.size()) {
                ct = ctl.get(i);
                if (!ct.isInterface()) {
                    return ct;
                }
                ++i;
            }
        }
        return ni.getJavaLangObject();
    }

    public static boolean isLessVisible(Member x, Member y) {
        if (x.isPublic()) {
            return false;
        }
        if (y.isPublic()) {
            return true;
        }
        if (x.isProtected()) {
            return false;
        }
        if (y.isProtected()) {
            return true;
        }
        return x.isPrivate() && !y.isPrivate();
    }

    public static boolean isCovered(ProgramModelInfo pmi, List<? extends ClassType> x, List<? extends ClassType> y) {
        Debug.assertNonnull(x, y);
        boolean found = true;
        int i = x.size() - 1;
        while (i >= 0 && found) {
            ClassType ct = x.get(i);
            found = false;
            int j = y.size() - 1;
            while (j >= 0) {
                if (pmi.isSubtype(ct, y.get(j))) {
                    found = true;
                    break;
                }
                --j;
            }
            --i;
        }
        return found;
    }

    public static boolean isValidInterfaceMember(MemberDeclaration member) {
        if (!member.isPublic()) {
            return false;
        }
        if (member instanceof FieldDeclaration) {
            if (!member.isStatic() || !((FieldDeclaration)member).isFinal()) {
                return false;
            }
            List<FieldSpecification> vars = ((FieldDeclaration)member).getVariables();
            int j = 0;
            int z = vars.size();
            while (j < z) {
                if (((VariableSpecification)vars.get(j)).getInitializer() == null) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        if (member instanceof MethodDeclaration) {
            return !(member instanceof ConstructorDeclaration) && !member.isStatic() && ((MethodDeclaration)member).getBody() == null;
        }
        return member instanceof TypeDeclaration;
    }

    public static List<? extends ClassType> getCoveredSubtypes(ProgramModelInfo pmi, List<? extends ClassType> list) {
        ArrayList<ClassType> copy = new ArrayList<ClassType>();
        copy.addAll(list);
        return TypeKit.removeCoveredSubtypes(pmi, copy);
    }

    public static List<ClassType> removeCoveredSubtypes(ProgramModelInfo pmi, List<ClassType> list) {
        ArrayList<ClassType> removed = new ArrayList<ClassType>();
        int i = list.size() - 1;
        while (i >= 0) {
            ClassType ct = list.get(i);
            int j = list.size() - 1;
            while (j >= 0) {
                ClassType ct2;
                if (j != i && pmi.isSubtype(ct, ct2 = list.get(j))) {
                    removed.add(ct);
                    list.remove(i);
                    break;
                }
                --j;
            }
            --i;
        }
        return removed;
    }

    public static List<TypeReference> getRedundantSuperInterfaces(SourceInfo si, TypeDeclaration td) {
        TypeReference tr;
        ClassType superclass = null;
        List<Object> superinterfaces = new ArrayList(0);
        if (td instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)td;
            if (id.getExtendedTypes() != null) {
                superinterfaces = id.getExtendedTypes().getSupertypes();
            }
        } else {
            ClassDeclaration cd = (ClassDeclaration)td;
            if (cd.getImplementedTypes() != null) {
                superinterfaces = cd.getImplementedTypes().getSupertypes();
            }
            if (cd.getExtendedTypes() != null) {
                superclass = (ClassType)si.getType((TypeReference)cd.getExtendedTypes().getSupertypes().get(0));
            }
        }
        ArrayList<TypeReference> redundantReferences = new ArrayList<TypeReference>();
        ArrayList<ClassType> types = new ArrayList<ClassType>();
        int i = 0;
        while (i < superinterfaces.size()) {
            tr = (TypeReference)superinterfaces.get(i);
            types.add((ClassType)si.getType(tr));
            ++i;
        }
        i = superinterfaces.size() - 1;
        while (i >= 0) {
            tr = (TypeReference)superinterfaces.get(i);
            ClassType ct = (ClassType)types.get(i);
            if (superclass != null && si.isSubtype(superclass, ct)) {
                redundantReferences.add(tr);
            } else {
                int j = superinterfaces.size() - 1;
                while (j >= 0) {
                    ClassType st;
                    if (i != j && si.isSubtype(st = (ClassType)types.get(j), ct)) {
                        redundantReferences.add(tr);
                        break;
                    }
                    --j;
                }
            }
            --i;
        }
        return redundantReferences;
    }

    public static List<TypeReference> getRedundantExceptions(SourceInfo si, Throws t) {
        ASTList<TypeReference> exceptions = t.getExceptions();
        ArrayList<TypeReference> redundantReferences = new ArrayList<TypeReference>();
        ArrayList<ClassType> types = new ArrayList<ClassType>(exceptions.size());
        int i = 0;
        while (i < exceptions.size()) {
            types.add((ClassType)si.getType((TypeReference)exceptions.get(i)));
            ++i;
        }
        i = exceptions.size() - 1;
        while (i >= 0) {
            ClassType ct = (ClassType)types.get(i);
            int j = exceptions.size() - 1;
            while (j >= 0) {
                ClassType st;
                if (i != j && si.isSubtype(ct, st = (ClassType)types.get(j))) {
                    redundantReferences.add((TypeReference)exceptions.get(i));
                    break;
                }
                --j;
            }
            --i;
        }
        return redundantReferences;
    }
}

