/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.ProgramElementWalker;
import recoder.java.Expression;
import recoder.java.JavaProgramFactory;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Branch;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Default;
import recoder.java.statement.Else;
import recoder.java.statement.EmptyStatement;
import recoder.java.statement.ExpressionJumpStatement;
import recoder.java.statement.Finally;
import recoder.java.statement.LabelJumpStatement;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Then;
import recoder.java.statement.Try;
import recoder.kit.ExpressionKit;
import recoder.kit.MiscKit;
import recoder.kit.Transformation;
import recoder.kit.TypeKit;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class StatementKit {
    private StatementKit() {
    }

    public static ASTList<Statement> prepareStatementMutableList(Statement s, ChangeHistory ch) {
        Debug.assertNonnull(s);
        StatementContainer con = s.getStatementContainer();
        if (con == null) {
            ASTArrayList<Statement> result = new ASTArrayList<Statement>();
            result.add(s);
            return result;
        }
        ASTList<Statement> result = StatementKit.getStatementMutableList(s);
        if (result == null) {
            result = StatementKit.wrapWithStatementBlock(s, ch).getBody();
        }
        return result;
    }

    public static ASTList<Statement> getStatementMutableList(Statement s) {
        Debug.assertNonnull(s);
        StatementContainer con = s.getStatementContainer();
        if (con == null) {
            return null;
        }
        Statement body = null;
        if (con instanceof Statement) {
            if (con instanceof StatementBlock) {
                return ((StatementBlock)con).getBody();
            }
            if (con instanceof Try) {
                body = ((Try)con).getBody();
            } else if (con instanceof SynchronizedBlock) {
                body = ((SynchronizedBlock)con).getBody();
            } else if (con instanceof LabeledStatement) {
                return StatementKit.getStatementMutableList((LabeledStatement)con);
            }
        } else if (con instanceof MemberDeclaration) {
            if (con instanceof MethodDeclaration) {
                body = ((MethodDeclaration)con).getBody();
            } else if (con instanceof ClassInitializer) {
                body = ((ClassInitializer)con).getBody();
            }
        } else if (con instanceof Branch) {
            if (con instanceof Then) {
                body = ((Then)con).getBody();
            } else if (con instanceof Else) {
                body = ((Else)con).getBody();
            } else {
                if (con instanceof Case) {
                    return ((Case)con).getBody();
                }
                if (con instanceof Default) {
                    return ((Default)con).getBody();
                }
                if (con instanceof Catch) {
                    body = ((Catch)con).getBody();
                } else if (con instanceof Finally) {
                    body = ((Finally)con).getBody();
                }
            }
        }
        if (body == null) {
            Debug.assertBoolean(true, "Could not handle container of statement " + Format.toString("%c \"%s\" @%p in %f", s));
        }
        if (body instanceof StatementBlock && body != s) {
            return body.getBody();
        }
        return null;
    }

    public static StatementBlock wrapWithStatementBlock(Statement s, ChangeHistory ch) {
        Debug.assertNonnull(s);
        StatementContainer con = s.getStatementContainer();
        StatementBlock block = s.getFactory().createStatementBlock();
        if (con != null) {
            con.replaceChild(s, block);
            if (ch != null) {
                ch.replaced(s, block);
            }
        }
        block.setBody(new ASTArrayList<boolean>(true));
        block.getBody().add(s);
        block.makeParentRoleValid();
        return block;
    }

    public static boolean canSafelyWrapWithStatementBlock(CrossReferenceSourceInfo xr, Statement s) {
        Debug.assertNonnull((Object)xr, s);
        if (s instanceof LocalVariableDeclaration) {
            LocalVariableDeclaration lvd = (LocalVariableDeclaration)s;
            List<VariableSpecification> vsl = lvd.getVariables();
            int j = vsl.size() - 1;
            while (j >= 0) {
                Variable v = vsl.get(j);
                List<VariableReference> vrl = xr.getReferences(v);
                int i = vrl.size() - 1;
                while (i >= 0) {
                    if (!MiscKit.contains(lvd, vrl.get(i))) {
                        return false;
                    }
                    --i;
                }
                --j;
            }
        }
        return true;
    }

    public static void preparePrepend(ChangeHistory ch, SourceInfo si, ExpressionJumpStatement returnOrThrow) {
        Debug.assertNonnull((Object)si, returnOrThrow);
        ASTList<Statement> destination = StatementKit.prepareStatementMutableList(returnOrThrow, ch);
        if (returnOrThrow.getExpressionCount() == 0) {
            return;
        }
        Expression expr = returnOrThrow.getExpressionAt(0);
        if (!ExpressionKit.containsStatements(expr)) {
            return;
        }
        JavaProgramFactory f = returnOrThrow.getFactory();
        Type type = si.getType(expr);
        String vname = VariableKit.getNewVariableName(si, type, MiscKit.getScopeDefiningElement(expr));
        TypeReference tref = TypeKit.createTypeReference(si, type, expr);
        LocalVariableDeclaration lvd = f.createLocalVariableDeclaration(tref, f.createIdentifier(vname));
        lvd.getVariables().get(0).setInitializer(expr);
        lvd.makeAllParentRolesValid();
        VariableReference vref = f.createVariableReference(f.createIdentifier(vname));
        returnOrThrow.replaceChild(expr, vref);
        if (ch != null) {
            ch.replaced(expr, vref);
        }
        StatementContainer destParent = returnOrThrow.getStatementContainer();
        int idx = 0;
        while (destination.get(idx) != returnOrThrow) {
            ++idx;
        }
        destination.add(idx, lvd);
        lvd.setStatementContainer(destParent);
        if (ch != null) {
            ch.attached(lvd);
        }
    }

    public static boolean isReachable(Statement s, SourceInfo si) {
        MemberDeclaration member = MiscKit.getParentMemberDeclaration(s);
        ControlFlowWalker w = new ControlFlowWalker(member, si);
        while (w.next()) {
            if (w.getStatement() != s) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReachableEnd(StatementBlock block, SourceInfo si) {
        ASTList<Statement> body = block.getBody();
        if (body == null || body.isEmpty()) {
            return true;
        }
        EmptyStatement dummyExit = block.getFactory().createEmptyStatement();
        body.add(dummyExit);
        dummyExit.setStatementContainer(block);
        boolean result = StatementKit.isReachable(dummyExit, si);
        body.remove(body.size() - 1);
        return result;
    }

    public static LabeledStatement getCorrespondingLabel(LabelJumpStatement s) {
        String idText = s.getIdentifier().getText();
        NonTerminalProgramElement parent = s.getASTParent();
        while (parent != null) {
            LabeledStatement lstat;
            if (parent instanceof LabeledStatement && idText.equals((lstat = (LabeledStatement)parent).getIdentifier().getText())) {
                return lstat;
            }
            parent = parent.getASTParent();
        }
        return null;
    }

    public static List<Statement> getExits(MemberDeclaration mdecl, SourceInfo si) {
        Debug.assertNonnull((Object)mdecl, si);
        ArrayList<Statement> result = new ArrayList<Statement>();
        StatementBlock body = null;
        if (mdecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)mdecl).getBody();
        } else if (mdecl instanceof ClassInitializer) {
            body = ((ClassInitializer)mdecl).getBody();
        }
        if (body == null) {
            return new ArrayList<Statement>(0);
        }
        EmptyStatement dummyExit = body.getFactory().createEmptyStatement();
        int s = body.getBody() == null ? 0 : body.getBody().size();
        Transformation.doAttach((Statement)dummyExit, body, s);
        ControlFlowWalker w = new ControlFlowWalker(mdecl, si);
        while (w.next()) {
            ProgramElement p = w.getProgramElement();
            if (p == dummyExit) {
                result.add(body);
                continue;
            }
            if (!(p instanceof ExpressionJumpStatement)) continue;
            result.add((Statement)p);
        }
        Transformation.doDetach(dummyExit);
        return result;
    }

    public static class ControlFlowWalker
    implements ProgramElementWalker {
        private SourceInfo si;
        private Statement current;
        private List<Statement> successors;
        private Set<Statement> reached;
        private List<Statement> stack;

        public ControlFlowWalker(MemberDeclaration parent, SourceInfo si) {
            StatementBlock body;
            if (si == null || parent == null) {
                throw new IllegalArgumentException();
            }
            this.si = si;
            this.reached = new HashSet<Statement>();
            this.stack = new ArrayList<Statement>();
            if (parent instanceof MethodDeclaration) {
                StatementBlock body2 = ((MethodDeclaration)parent).getBody();
                if (body2 != null) {
                    this.stack.add(body2);
                }
            } else if (parent instanceof ClassInitializer && (body = ((ClassInitializer)parent).getBody()) != null) {
                this.stack.add(body);
            }
        }

        @Override
        public boolean next() {
            int size = this.stack.size();
            if (size == 0) {
                this.current = null;
                this.successors = null;
                return false;
            }
            this.current = this.stack.get(size - 1);
            this.reached.add(this.current);
            this.stack.remove(size - 1);
            this.successors = this.si.getSucceedingStatements(this.current);
            int i = 0;
            int s = this.successors.size();
            while (i < s) {
                Statement f = this.successors.get(i);
                if (f != SourceInfo.METHOD_EXIT && !this.reached.contains(f)) {
                    this.stack.add(f);
                }
                ++i;
            }
            return true;
        }

        @Override
        public ProgramElement getProgramElement() {
            return this.current;
        }

        public Statement getStatement() {
            return this.current;
        }

        public List<Statement> getSucceedingStatements() {
            return this.successors;
        }

        public boolean isReachable(Statement s) {
            return this.reached.contains(s);
        }
    }
}

