/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Member;
import recoder.bytecode.AccessFlags;
import recoder.java.Declaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.Modifier;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.declaration.modifier.Volatile;
import recoder.kit.MiscKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ChangeHistory;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class ModifierKit
implements AccessFlags {
    public static final int PACKAGE = 512;

    private ModifierKit() {
    }

    public static Modifier createModifier(ProgramFactory f, int code) {
        Debug.assertNonnull(f);
        switch (code) {
            case 512: {
                return null;
            }
            case 1: {
                return f.createPublic();
            }
            case 4: {
                return f.createProtected();
            }
            case 2: {
                return f.createPrivate();
            }
            case 8: {
                return f.createStatic();
            }
            case 16: {
                return f.createFinal();
            }
            case 1024: {
                return f.createAbstract();
            }
            case 32: {
                return f.createSynchronized();
            }
            case 128: {
                return f.createTransient();
            }
            case 2048: {
                return f.createStrictFp();
            }
            case 64: {
                return f.createVolatile();
            }
            case 256: {
                return f.createNative();
            }
        }
        throw new IllegalArgumentException("Unsupported modifier code " + code);
    }

    public static int getCode(Modifier m) {
        if (m == null) {
            return 512;
        }
        if (m instanceof VisibilityModifier) {
            if (m instanceof Public) {
                return 1;
            }
            if (m instanceof Protected) {
                return 4;
            }
            if (m instanceof Private) {
                return 2;
            }
        } else {
            if (m instanceof Static) {
                return 8;
            }
            if (m instanceof Final) {
                return 16;
            }
            if (m instanceof Abstract) {
                return 1024;
            }
            if (m instanceof Synchronized) {
                return 32;
            }
            if (m instanceof Transient) {
                return 128;
            }
            if (m instanceof StrictFp) {
                return 2048;
            }
            if (m instanceof Volatile) {
                return 64;
            }
            if (m instanceof Native) {
                return 256;
            }
        }
        throw new IllegalArgumentException("Unknown Modifier " + m.getClass().getName());
    }

    public static VisibilityModifier getVisibilityModifier(Declaration decl) {
        Debug.assertNonnull(decl);
        ASTList<DeclarationSpecifier> mods = decl.getDeclarationSpecifiers();
        if (mods == null) {
            return null;
        }
        int i = 0;
        while (i < mods.size()) {
            DeclarationSpecifier res = (DeclarationSpecifier)mods.get(i);
            if (res instanceof VisibilityModifier) {
                return (VisibilityModifier)res;
            }
            ++i;
        }
        return null;
    }

    private static boolean containsModifier(Declaration decl, Class<? extends Modifier> mod) {
        Debug.assertNonnull((Object)decl, mod);
        ASTList<DeclarationSpecifier> mods = decl.getDeclarationSpecifiers();
        if (mods == null) {
            return false;
        }
        int i = 0;
        while (i < mods.size()) {
            DeclarationSpecifier res = (DeclarationSpecifier)mods.get(i);
            if (mod.isInstance(res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static DeclarationSpecifier modify(ChangeHistory ch, int code, Declaration decl) {
        Modifier m;
        Debug.assertNonnull(decl);
        ASTList<DeclarationSpecifier> mods = decl.getDeclarationSpecifiers();
        ProgramFactory fact = decl.getFactory();
        int insertPos = 0;
        switch (code) {
            case 512: {
                if (code == 512) {
                    VisibilityModifier m2 = ModifierKit.getVisibilityModifier(decl);
                    if (m2 != null) {
                        MiscKit.remove(ch, m2);
                    }
                    return null;
                }
            }
            case 1: {
                m = ModifierKit.getVisibilityModifier(decl);
                if (m instanceof Public) {
                    return null;
                }
                if (m != null) {
                    MiscKit.remove(ch, m);
                }
                if (mods == null) {
                    mods = new ASTArrayList<DeclarationSpecifier>();
                    decl.setDeclarationSpecifiers(mods);
                }
                m = fact.createPublic();
                insertPos = 0;
                break;
            }
            case 4: {
                m = ModifierKit.getVisibilityModifier(decl);
                if (m instanceof Protected) {
                    return null;
                }
                if (m != null) {
                    MiscKit.remove(ch, m);
                }
                if (mods == null) {
                    mods = new ASTArrayList<DeclarationSpecifier>();
                    decl.setDeclarationSpecifiers(mods);
                }
                m = fact.createProtected();
                insertPos = 0;
                break;
            }
            case 2: {
                m = ModifierKit.getVisibilityModifier(decl);
                if (m instanceof Private) {
                    return null;
                }
                if (m != null) {
                    MiscKit.remove(ch, m);
                }
                if (mods == null) {
                    mods = new ASTArrayList<DeclarationSpecifier>();
                    decl.setDeclarationSpecifiers(mods);
                }
                m = fact.createPrivate();
                insertPos = 0;
                break;
            }
            case 8: {
                if (ModifierKit.containsModifier(decl, Static.class)) {
                    return null;
                }
                m = ModifierKit.getVisibilityModifier(decl);
                insertPos = m == null ? 0 : 1;
                m = fact.createStatic();
                break;
            }
            case 16: {
                if (ModifierKit.containsModifier(decl, Final.class)) {
                    return null;
                }
                m = ModifierKit.getVisibilityModifier(decl);
                int n = insertPos = m == null ? 0 : 1;
                if (ModifierKit.containsModifier(decl, Static.class)) {
                    ++insertPos;
                }
                m = fact.createFinal();
                break;
            }
            case 1024: {
                if (ModifierKit.containsModifier(decl, Abstract.class)) {
                    return null;
                }
                m = ModifierKit.getVisibilityModifier(decl);
                insertPos = m == null ? 0 : 1;
                m = fact.createAbstract();
                break;
            }
            case 32: {
                if (ModifierKit.containsModifier(decl, Synchronized.class)) {
                    return null;
                }
                insertPos = mods == null ? 0 : mods.size();
                m = fact.createSynchronized();
                break;
            }
            case 128: {
                if (ModifierKit.containsModifier(decl, Transient.class)) {
                    return null;
                }
                insertPos = mods == null ? 0 : mods.size();
                m = fact.createTransient();
                break;
            }
            case 2048: {
                if (ModifierKit.containsModifier(decl, StrictFp.class)) {
                    return null;
                }
                insertPos = mods == null ? 0 : mods.size();
                m = fact.createStrictFp();
                break;
            }
            case 64: {
                if (ModifierKit.containsModifier(decl, Volatile.class)) {
                    return null;
                }
                insertPos = mods == null ? 0 : mods.size();
                m = fact.createVolatile();
                break;
            }
            case 256: {
                if (ModifierKit.containsModifier(decl, Native.class)) {
                    return null;
                }
                insertPos = mods == null ? 0 : mods.size();
                m = fact.createNative();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modifier code " + code);
            }
        }
        mods.add(insertPos, m);
        m.setParent(decl);
        if (ch != null) {
            ch.attached(m);
        }
        return m;
    }

    public static boolean makeVisible(ChangeHistory ch, SourceInfo si, MemberDeclaration mdecl, ClassType ct) {
        Debug.assertNonnull(si, mdecl, ct);
        Debug.assertBoolean(mdecl instanceof Member);
        if (si.isVisibleFor((Member)((Object)mdecl), ct)) {
            return true;
        }
        TypeDeclaration mt = mdecl.getMemberParent();
        int minimumNeeded = mt == ct ? 2 : (mt.getPackage() == ct.getPackage() ? 512 : (si.isSubtype(mt, ct) ? 4 : 1));
        ModifierKit.modify(ch, minimumNeeded, mdecl);
        return false;
    }
}

