/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Method;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.Comment;
import recoder.java.DocComment;
import recoder.java.Expression;
import recoder.java.JavaProgramFactory;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ParameterContainer;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.expression.operator.New;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.statement.Return;
import recoder.kit.DifferentReturnTypeOverwrite;
import recoder.kit.FinalOverwrite;
import recoder.kit.IllegalInterfaceMember;
import recoder.kit.IllegalName;
import recoder.kit.MiscKit;
import recoder.kit.MorePrivateOverwrite;
import recoder.kit.NameConflict;
import recoder.kit.NonStaticOverwrite;
import recoder.kit.Problem;
import recoder.kit.TypeKit;
import recoder.kit.UncoveredExceptionsOverwrite;
import recoder.kit.VariableKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class MethodKit {
    private MethodKit() {
    }

    public static ASTList<Expression> createArguments(ParameterContainer p) {
        int c = p.getParameterDeclarationCount();
        ASTArrayList<int> res = new ASTArrayList<int>(c);
        int i = 0;
        while (i < c) {
            res.add((int)VariableKit.createVariableReference(p.getParameterDeclarationAt(i)));
            ++i;
        }
        return res;
    }

    public static MethodReference createMethodReference(MethodDeclaration decl) {
        JavaProgramFactory factory = decl.getFactory();
        return factory.createMethodReference(factory.createIdentifier(decl.getName()), MethodKit.createArguments(decl));
    }

    public static MethodReference createMethodReference(ReferencePrefix prefix, MethodDeclaration decl) {
        JavaProgramFactory factory = decl.getFactory();
        return factory.createMethodReference(prefix, factory.createIdentifier(decl.getName()), MethodKit.createArguments(decl));
    }

    public static New createNew(ConstructorDeclaration decl) {
        return decl.getFactory().createNew(null, TypeKit.createTypeReference(decl), MethodKit.createArguments(decl));
    }

    public static MethodDeclaration createAbstractMethodDeclaration(MethodDeclaration decl, boolean forInterface) {
        JavaProgramFactory factory = decl.getFactory();
        if (decl.isStatic()) {
            throw new IllegalArgumentException("A static method cannot made abstract!");
        }
        StatementBlock body = decl.getBody();
        decl.setBody(null);
        MethodDeclaration res = decl.deepClone();
        decl.setBody(body);
        Abstract anAbstract = factory.createAbstract();
        ASTList<DeclarationSpecifier> modList = res.getDeclarationSpecifiers();
        int abstractPos = modList == null ? -1 : modList.indexOf(anAbstract);
        VisibilityModifier vismod = res.getVisibilityModifier();
        if (forInterface) {
            if (abstractPos >= 0) {
                modList.remove(abstractPos);
            }
            if (vismod != null) {
                modList.remove(modList.indexOf(vismod));
            }
        } else if (abstractPos < 0) {
            if (modList == null) {
                modList = new ASTArrayList<boolean>(true);
                res.setDeclarationSpecifiers(modList);
            }
            modList.add(vismod == null ? 0 : 1, anAbstract);
        } else {
            return res;
        }
        return res;
    }

    public static MethodDeclaration createAdapterMethod(ReferencePrefix delegationObject, MethodDeclaration method) {
        MethodDeclaration clone = method.deepClone();
        clone.setComments(new ASTArrayList<Comment>(new DocComment("/** generated by createAdapterMethod */")));
        clone.setBody(new StatementBlock(new ASTArrayList<Statement>()));
        MethodReference call = MethodKit.createMethodReference(delegationObject, method);
        clone.getBody().getBody().add(call);
        return clone;
    }

    public static ClassDeclaration createPackerClass(String packerClassName, List<ParameterDeclaration> parameters) {
        throw new RuntimeException("Taken out as of 0.93, might come back later... Sorry!");
    }

    public static List<MethodDeclaration> getGetters(SourceInfo si, FieldSpecification f) {
        Debug.assertNonnull((Object)si, f);
        ArrayList<MethodDeclaration> res = new ArrayList<MethodDeclaration>();
        TypeDeclaration tdecl = (TypeDeclaration)f.getContainingClassType();
        if (tdecl instanceof InterfaceDeclaration) {
            return res;
        }
        ASTList<MemberDeclaration> mems = tdecl.getMembers();
        if (mems == null) {
            return res;
        }
        Type fieldType = si.getType(f);
        int i = mems.size() - 1;
        while (i >= 0) {
            MemberDeclaration md = (MemberDeclaration)mems.get(i);
            if (md instanceof MethodDeclaration) {
                MethodDeclaration m = (MethodDeclaration)md;
                if (!(!(fieldType instanceof PrimitiveType) ? !si.isWidening(fieldType, m.getReturnType()) : m.getReturnType() != fieldType)) {
                    FieldReference fr;
                    Expression expr;
                    Statement last;
                    ASTList<Statement> statements;
                    StatementBlock body = m.getBody();
                    if (body != null && (statements = body.getBody()) != null && (last = (Statement)statements.get(statements.size() - 1)) instanceof Return && (expr = ((Return)last).getExpression()) instanceof FieldReference && si.getField(fr = (FieldReference)expr) == f) {
                        res.add(m);
                    }
                }
            }
            --i;
        }
        return res;
    }

    public static List<Method> getRedefinedMethods(Method m) {
        if (m == null) {
            throw new NullPointerException();
        }
        return MethodKit.internalGetRedefinedMethods(m, m.getContainingClassType().getSupertypes());
    }

    public static List<Method> getAllRedefinedMethods(Method m) {
        if (m == null) {
            throw new NullPointerException();
        }
        List<ClassType> supers = m.getContainingClassType().getAllSupertypes();
        supers = m.getProgramModelInfo().removeErasedTypesFromList(supers);
        supers.remove(0);
        return MethodKit.internalGetRedefinedMethods(m, supers);
    }

    private static List<Method> internalGetRedefinedMethods(Method m, List<? extends ClassType> supers) {
        if (m instanceof Constructor) {
            return Collections.emptyList();
        }
        ProgramModelInfo pmi = m.getProgramModelInfo();
        String mname = m.getName();
        List<Type> msig = m.getSignature();
        ArrayList<Method> result = new ArrayList<Method>();
        int i = supers.size() - 1;
        while (i >= 0) {
            List<Method> meths = supers.get(i).getMethods();
            int j = meths.size() - 1;
            while (j >= 0) {
                Method m2 = meths.get(j);
                if (m2.getName().equals(mname) && MethodKit.signatureMatches(pmi, msig, m2.getSignature(), true, m.isVarArgMethod(), m2.isVarArgMethod())) {
                    result.add(m2);
                }
                --j;
            }
            --i;
        }
        return result;
    }

    public static List<Method> getRedefiningMethods(CrossReferenceSourceInfo xr, Method m) {
        Debug.assertNonnull(m);
        if (m instanceof Constructor) {
            return new ArrayList<Method>(0);
        }
        ClassType ct = m.getContainingClassType();
        String mname = m.getName();
        List<Type> msig = m.getSignature();
        ArrayList<Method> result = new ArrayList<Method>();
        List<ClassType> subs = xr.getAllSubtypes(ct);
        int i = subs.size() - 1;
        while (i >= 0) {
            List<Method> meths = subs.get(i).getMethods();
            int j = meths.size() - 1;
            while (j >= 0) {
                Method m2 = meths.get(j);
                if (m2.getName().equals(mname) && MethodKit.signatureMatches(xr, m2.getSignature(), msig, xr.getServiceConfiguration().getProjectSettings().java5Allowed(), m2.isVarArgMethod(), m.isVarArgMethod())) {
                    result.add(m2);
                }
                --j;
            }
            --i;
        }
        return result;
    }

    public static boolean isMain(NameInfo ni, Method m) {
        if (!m.isPublic()) {
            return false;
        }
        if (!m.isStatic()) {
            return false;
        }
        if (!m.getName().equals("main")) {
            return false;
        }
        if (m.getReturnType() != null) {
            return false;
        }
        List<Type> list = m.getSignature();
        if (list.size() != 1) {
            return false;
        }
        return list.get(0) == ni.getArrayType(ni.getJavaLangString());
    }

    public static boolean isSerializationMethod(NameInfo ni, Method m) {
        if (m.getName().equals("writeObject") && m.isPrivate() && m.getReturnType() == null && m.getSignature().size() == 1 && m.getSignature().get(0) == ni.getClassType("java.io.ObjectOutputStream")) {
            return true;
        }
        if (m.getName().equals("readObject") && m.isPrivate() && m.getReturnType() == null && m.getSignature().size() == 1 && m.getSignature().get(0) == ni.getClassType("java.io.ObjectInputStream")) {
            return true;
        }
        if (m.getName().equals("writeReplace") && m.getReturnType() == ni.getJavaLangObject() && m.getSignature().isEmpty()) {
            return true;
        }
        return m.getName().equals("readResolve") && m.getReturnType() == ni.getJavaLangObject() && m.getSignature().isEmpty();
    }

    public static MethodDeclaration cloneHeader(MethodDeclaration md) {
        StatementBlock body = md.getBody();
        md.setBody(null);
        MethodDeclaration result = md.deepClone();
        md.setBody(body);
        return result;
    }

    public static Method getDefinedMethod(ClassType type, String name, List<Type> signature, boolean signatureIsVarArg) {
        List<Method> methods = type.getMethods();
        int j = methods.size() - 1;
        while (j >= 0) {
            Method m = methods.get(j);
            if (name.equals(m.getName()) && MethodKit.signatureMatches(type.getProgramModelInfo(), signature, m.getSignature(), type.getProgramModelInfo().getServiceConfiguration().getProjectSettings().java5Allowed(), signatureIsVarArg, m.isVarArgMethod())) {
                return m;
            }
            --j;
        }
        return null;
    }

    public static boolean signatureMatches(ProgramModelInfo pmi, List<Type> sig1, List<Type> sig2, boolean java5, boolean sig1vararg, boolean sig2vararg) {
        return java5 ? pmi.isCompatibleSignature(sig1, sig2, false, sig2vararg) && pmi.isCompatibleSignature(sig2, sig1, false, sig1vararg) : sig1.equals(sig2);
    }

    public static List<Method> getRedefinedMethods(NameInfo ni, ClassType base, String name, List<Type> signature, boolean signatureIsVarArg) {
        List<ClassType> supers = base.getSupertypes();
        ArrayList<Method> result = new ArrayList<Method>();
        boolean hasClass = false;
        int i = 0;
        while (i < supers.size()) {
            ClassType ct = supers.get(i);
            Method m = MethodKit.getDefinedMethod(ct, name, signature, signatureIsVarArg);
            if (m != null) {
                if (!ct.isInterface()) {
                    result.add(0, m);
                    hasClass = true;
                } else {
                    result.add(m);
                }
            }
            ++i;
        }
        if (!hasClass) {
            ClassType ct = base;
            do {
                Method m;
                if ((m = MethodKit.getDefinedMethod(ct = TypeKit.getSuperClass(ni, ct), name, signature, signatureIsVarArg)) == null) continue;
                result.add(0, m);
                break;
            } while (ct != ni.getJavaLangObject());
        }
        return result;
    }

    public static Problem checkMethodRedefinition(ProgramModelInfo pmi, Method redefined, Method redefining) {
        List<ClassType> redefinedex;
        if (redefining instanceof Constructor) {
            return null;
        }
        if (redefined.isFinal() || redefined.getContainingClassType().isFinal()) {
            return new FinalOverwrite(redefined);
        }
        if (redefined.getReturnType() != redefining.getReturnType()) {
            return new DifferentReturnTypeOverwrite(redefined);
        }
        if (TypeKit.isLessVisible(redefining, redefined)) {
            return new MorePrivateOverwrite(redefined);
        }
        if (!redefining.isStatic() && redefined.isStatic()) {
            return new NonStaticOverwrite(redefined);
        }
        List<ClassType> exceptions = redefining.getExceptions();
        if (!(exceptions == null || (redefinedex = redefined.getExceptions()) != null && TypeKit.isCovered(pmi, redefinedex, exceptions))) {
            return new UncoveredExceptionsOverwrite(redefined);
        }
        return null;
    }

    public static Problem checkMethodDeclaration(NameInfo ni, SourceInfo si, TypeDeclaration context, MethodDeclaration candidate) {
        if (context instanceof InterfaceDeclaration && !TypeKit.isValidInterfaceMember(candidate)) {
            return new IllegalInterfaceMember(candidate);
        }
        if (candidate instanceof Constructor) {
            if (!candidate.getName().equals(context.getName())) {
                return new NameConflict(context);
            }
        } else if (Naming.isKeyword(candidate.getName())) {
            return new IllegalName(candidate);
        }
        ASTList<MemberDeclaration> members = context.getMembers();
        String name = candidate.getName();
        List<Type> signature = candidate.getSignature();
        if (members != null) {
            int i = members.size() - 1;
            while (i >= 0) {
                MethodDeclaration m;
                MemberDeclaration md = (MemberDeclaration)members.get(i);
                if (md instanceof MethodDeclaration && (m = (MethodDeclaration)md).getName().equals(name) && MethodKit.signatureMatches(si, m.getSignature(), signature, si.getServiceConfiguration().getProjectSettings().java5Allowed(), m.isVarArgMethod(), candidate.isVarArgMethod())) {
                    return new NameConflict(m);
                }
                --i;
            }
        }
        if (candidate instanceof Constructor) {
            return null;
        }
        List<Method> redefined = MethodKit.getRedefinedMethods(ni, context, name, signature, candidate.isVarArgMethod());
        int i = 0;
        while (i < redefined.size()) {
            Problem problem = MethodKit.checkMethodRedefinition(si, redefined.get(i), candidate);
            if (problem != null) {
                return problem;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static List<MemberReference> getReferences(CrossReferenceSourceInfo xr, Method m, NonTerminalProgramElement root, boolean scanTree) {
        block5: {
            block4: {
                Debug.assertNonnull(xr, m, root);
                result = new ArrayList<MemberReference>();
                if (!scanTree) break block4;
                tw = new TreeWalker(root);
                if (!(m instanceof Constructor)) ** GOTO lbl17
                while (tw.next(ConstructorReference.class)) {
                    cr = (ConstructorReference)tw.getProgramElement();
                    if (xr.getConstructor(cr) != m) continue;
                    result.add(cr);
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    mr = (MethodReference)tw.getProgramElement();
                    if (xr.getMethod(mr) != m) continue;
                    result.add(mr);
lbl17:
                    // 3 sources

                    ** while (tw.next(MethodReference.class))
                }
lbl18:
                // 1 sources

                break block5;
            }
            refs = xr.getReferences(m);
            i = 0;
            s = refs.size();
            while (i < s) {
                mr = refs.get(i);
                if (MiscKit.contains(root, mr)) {
                    result.add(mr);
                }
                ++i;
            }
        }
        return result;
    }

    public static List<Method> getAllRelatedMethods(CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature, boolean signatureIsVarArg) {
        Debug.assertNonnull(xrsi, type, methodName, signature);
        RelatedMethodsHelper rmh = new RelatedMethodsHelper(xrsi, type, methodName, signature, signatureIsVarArg);
        return rmh.findRelatedMethods();
    }

    public static List<Method> getAllRelatedMethods(CrossReferenceSourceInfo xrsi, Method method) {
        Debug.assertNonnull(method);
        return MethodKit.getAllRelatedMethods(xrsi, method.getContainingClassType(), method.getName(), method.getSignature(), method.isVarArgMethod());
    }

    public static List<Method> getAllRelatedMethods(NameInfo ni, CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature) {
        return MethodKit.getAllRelatedMethods(ni, xrsi, type, methodName, signature, false);
    }

    public static List<Method> getAllRelatedMethods(NameInfo ni, CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature, boolean signatureIsVarArg) {
        HashSet<ClassType> visited = new HashSet<ClassType>();
        LinkedList<ClassType> q = new LinkedList<ClassType>();
        q.add(type);
        visited.add(type);
        ArrayList<Method> result = new ArrayList<Method>();
        while (!q.isEmpty()) {
            type = (ClassType)q.remove();
            Method m = MethodKit.getDefinedMethod(type, methodName, signature, signatureIsVarArg);
            if (m != null) {
                result.add(m);
            }
            List<Method> redefined = MethodKit.getRedefinedMethods(ni, type, methodName, signature, signatureIsVarArg);
            int i = redefined.size() - 1;
            while (i >= 0) {
                ClassType ct = redefined.get(i).getContainingClassType();
                if (visited.add(ct)) {
                    q.add(ct);
                }
                --i;
            }
            if (m == null && redefined.isEmpty()) continue;
            List<ClassType> types = xrsi.getSubtypes(type);
            int i2 = types.size() - 1;
            while (i2 >= 0) {
                ClassType ct = types.get(i2);
                if (visited.add(ct)) {
                    q.add(ct);
                }
                --i2;
            }
        }
        return result;
    }

    private static class RelatedMethodsHelper {
        private List<Method> methods = new ArrayList<Method>();
        private Set<ClassType> searchedUp = new HashSet<ClassType>();
        private Set<ClassType> searchedDown = new HashSet<ClassType>();
        private CrossReferenceSourceInfo xrsi;
        private ClassType starting_type;
        private String methodName;
        private List<Type> signature;
        private boolean signatureIsVarArg;

        public RelatedMethodsHelper(CrossReferenceSourceInfo xrsi, ClassType type, String methodName, List<Type> signature, boolean signatureIsVarArg) {
            this.xrsi = xrsi;
            this.methodName = methodName;
            this.signature = signature;
            this.starting_type = type;
            this.signatureIsVarArg = signatureIsVarArg;
        }

        public List<Method> findRelatedMethods() {
            this.addMethodsFromSubTypes(this.starting_type);
            return this.methods;
        }

        private void addMethodsFromSubTypes(ClassType type) {
            if (!this.searchedDown.add(type)) {
                return;
            }
            List<ClassType> subTypes = this.xrsi.getSubtypes(type);
            if (subTypes.isEmpty()) {
                this.addMethodsFromSuperTypes(type);
            } else {
                int i = subTypes.size() - 1;
                while (i >= 0) {
                    ClassType child = subTypes.get(i);
                    this.addMethodsFromSubTypes(child);
                    --i;
                }
            }
        }

        private void addMethodsFromSuperTypes(ClassType type) {
            if (!this.searchedUp.add(type)) {
                return;
            }
            Method m = MethodKit.getDefinedMethod(type, this.methodName, this.signature, this.signatureIsVarArg);
            if (m != null) {
                this.methods.add(m);
                this.addMethodsFromSubTypes(type);
            }
            List<ClassType> superTypes = type.getSupertypes();
            int i = superTypes.size() - 1;
            while (i >= 0) {
                ClassType parent = superTypes.get(i);
                this.addMethodsFromSuperTypes(parent);
                --i;
            }
        }
    }
}

