/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit;

import java.util.List;
import recoder.ProgramFactory;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Statement;
import recoder.java.expression.Assignment;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.VariableReference;
import recoder.list.generic.ASTArrayList;
import recoder.service.NameInfo;
import recoder.util.Debug;

public class ExpressionKit {
    private ExpressionKit() {
    }

    public static boolean containsStatements(Expression expr) {
        if (expr instanceof Statement && !(expr instanceof ParenthesizedExpression)) {
            return true;
        }
        if (expr instanceof ExpressionContainer) {
            ExpressionContainer con = (ExpressionContainer)((Object)expr);
            int i = 0;
            int s = con.getExpressionCount();
            while (i < s) {
                if (ExpressionKit.containsStatements(con.getExpressionAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isLValue(Expression r) {
        if (r instanceof VariableReference || r instanceof ArrayReference) {
            ExpressionContainer c = r.getExpressionContainer();
            return c instanceof Assignment && c.getExpressionAt(0) == r;
        }
        return false;
    }

    public static List<Expression> collectPreceedingExpressions(Expression x) {
        ReferencePrefix rp;
        Debug.assertNonnull(x);
        ASTArrayList<Expression> dest = new ASTArrayList<Expression>();
        if (x instanceof MethodReference || x instanceof ConstructorReference) {
            ExpressionContainer ec = (ExpressionContainer)((Object)x);
            int i = 0;
            int s = ec.getExpressionCount();
            while (i < s) {
                dest.add(ec.getExpressionAt(i));
                ++i;
            }
        } else if (x instanceof ReferenceSuffix && (rp = ((ReferenceSuffix)((Object)x)).getReferencePrefix()) instanceof Expression) {
            dest.add((Expression)((Object)rp));
        }
        ExpressionContainer parent;
        while ((parent = x.getExpressionContainer()) != null) {
            Expression expr;
            int i;
            boolean leftAssociative = parent instanceof Operator ? ((Operator)parent).isLeftAssociative() : true;
            if (leftAssociative) {
                i = 0;
                if (parent instanceof ReferenceSuffix && ((ReferenceSuffix)((Object)parent)).getReferencePrefix() instanceof Expression) {
                    i = 1;
                }
                while ((expr = parent.getExpressionAt(i)) != x) {
                    dest.add(expr);
                    ++i;
                }
            } else {
                i = parent.getExpressionCount() - 1;
                while ((expr = parent.getExpressionAt(i)) != x) {
                    dest.add(expr);
                    --i;
                }
            }
            if (!(parent instanceof Expression)) {
                return dest;
            }
            x = (Expression)((Object)parent);
        }
        return dest;
    }

    public static Literal createDefaultValue(ProgramFactory f, NameInfo ni, Type t) {
        Debug.assertNonnull(f, ni, t);
        if (t instanceof PrimitiveType) {
            if (t == ni.getIntType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getBooleanType()) {
                return f.createBooleanLiteral(false);
            }
            if (t == ni.getCharType()) {
                return f.createCharLiteral('\u0000');
            }
            if (t == ni.getShortType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getByteType()) {
                return f.createIntLiteral(0);
            }
            if (t == ni.getLongType()) {
                return f.createLongLiteral(0L);
            }
            if (t == ni.getFloatType()) {
                return f.createFloatLiteral(0.0f);
            }
            if (t == ni.getDoubleType()) {
                return f.createDoubleLiteral(0.0);
            }
            throw new IllegalArgumentException("Unknown primitive type " + t.getName());
        }
        return f.createNullLiteral();
    }
}

