/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.statement.JavaStatement;

public class SynchronizedBlock
extends JavaStatement
implements StatementContainer,
ExpressionContainer {
    private static final long serialVersionUID = -9179480508765855081L;
    private Expression expression;
    private StatementBlock body;

    public SynchronizedBlock() {
    }

    public SynchronizedBlock(StatementBlock body) {
        this.setBody(body);
        this.makeParentRoleValid();
    }

    public SynchronizedBlock(Expression e, StatementBlock body) {
        this.setExpression(e);
        this.setBody(body);
        this.makeParentRoleValid();
    }

    protected SynchronizedBlock(SynchronizedBlock proto) {
        super(proto);
        if (proto.expression != null) {
            this.expression = proto.expression.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public SynchronizedBlock deepClone() {
        return new SynchronizedBlock(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
        if (this.expression != null) {
            this.expression.setExpressionContainer(this);
        }
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.expression == p) {
            Expression r;
            this.expression = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.body == p) {
            StatementBlock r;
            this.body = r = (StatementBlock)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        return this.expression != null ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.expression != null && index == 0) {
            return this.expression;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setExpression(Expression e) {
        this.expression = e;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.expression != null) {
            ++result;
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.expression != null) {
            if (index == 0) {
                return this.expression;
            }
            --index;
        }
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.expression == child) {
            return 0;
        }
        if (this.body == child) {
            return 1;
        }
        return -1;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitSynchronizedBlock(this);
    }
}

