/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.LoopInitializer;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.java.expression.ExpressionStatement;
import recoder.java.statement.JavaStatement;
import recoder.list.generic.ASTList;

public abstract class LoopStatement
extends JavaStatement
implements StatementContainer,
ExpressionContainer {
    private static final long serialVersionUID = 1L;
    private Expression guard;
    ASTList<LoopInitializer> inits;
    private ASTList<Expression> updates;
    Statement body;

    public LoopStatement() {
    }

    public LoopStatement(Statement body) {
        this.setBody(body);
    }

    protected LoopStatement(LoopStatement proto) {
        super(proto);
        if (proto.guard != null) {
            this.guard = proto.guard.deepClone();
        }
        if (proto.inits != null) {
            this.inits = proto.inits.deepClone();
        }
        if (proto.updates != null) {
            this.updates = proto.updates.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
    }

    @Override
    public void makeParentRoleValid() {
        int i;
        super.makeParentRoleValid();
        if (this.inits != null) {
            i = this.inits.size() - 1;
            while (i >= 0) {
                LoopInitializer li = (LoopInitializer)this.inits.get(i);
                if (li instanceof ExpressionStatement) {
                    ((ExpressionStatement)li).setExpressionContainer(this);
                } else {
                    li.setStatementContainer(this);
                }
                --i;
            }
        }
        if (this.guard != null) {
            this.guard.setExpressionContainer(this);
        }
        if (this.updates != null) {
            i = this.updates.size() - 1;
            while (i >= 0) {
                ((Expression)this.updates.get(i)).setExpressionContainer(this);
                --i;
            }
        }
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.inits != null) {
            result += this.inits.size();
        }
        if (this.guard != null) {
            ++result;
        }
        if (this.updates != null) {
            result += this.updates.size();
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.inits != null) {
            len = this.inits.size();
            if (len > index) {
                return (ProgramElement)this.inits.get(index);
            }
            index -= len;
        }
        if (this.isCheckedBeforeIteration() && this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        if (this.updates != null) {
            len = this.updates.size();
            if (len > index) {
                return (ProgramElement)this.updates.get(index);
            }
            index -= len;
        }
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        if (!this.isCheckedBeforeIteration() && this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.inits != null && (index = this.inits.indexOf(child)) >= 0) {
            return index << 4;
        }
        if (this.guard == child) {
            return 1;
        }
        if (this.updates != null && (index = this.updates.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        if (this.body == child) {
            return 3;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.inits == null ? 0 : this.inits.size();
        int i = 0;
        while (i < count) {
            if (this.inits.get(i) == p) {
                if (q == null) {
                    this.inits.remove(i);
                } else {
                    LoopInitializer r = (LoopInitializer)q;
                    this.inits.set(i, r);
                    if (r instanceof ExpressionStatement) {
                        ((ExpressionStatement)r).setExpressionContainer(this);
                    } else {
                        r.setStatementContainer(this);
                    }
                }
                return true;
            }
            ++i;
        }
        if (this.guard == p) {
            Expression r;
            this.guard = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        count = this.updates == null ? 0 : this.updates.size();
        i = 0;
        while (i < count) {
            if (this.updates.get(i) == p) {
                if (q == null) {
                    this.updates.remove(i);
                } else {
                    Expression r = (Expression)q;
                    this.updates.set(i, r);
                    r.setExpressionContainer(this);
                }
                return true;
            }
            ++i;
        }
        if (this.body == p) {
            Statement r;
            this.body = r = (Statement)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        int result = 0;
        if (this.guard != null) {
            ++result;
        }
        if (this.inits != null) {
            int i = this.inits.size() - 1;
            while (i >= 0) {
                if (this.inits.get(i) instanceof Expression) {
                    ++result;
                }
                --i;
            }
        }
        if (this.updates != null) {
            result += this.updates.size();
        }
        return result;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.guard != null) {
            if (index == 0) {
                return this.guard;
            }
            --index;
        }
        if (this.inits != null) {
            int s = this.inits.size();
            int i = 0;
            while (i < s && index >= 0) {
                LoopInitializer ii = (LoopInitializer)this.inits.get(i);
                if (ii instanceof Expression) {
                    if (index == 0) {
                        return (Expression)((Object)ii);
                    }
                    --index;
                }
                ++i;
            }
        }
        if (this.updates != null) {
            return (Expression)this.updates.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Expression getGuard() {
        return this.guard;
    }

    public void setGuard(Expression expr) {
        this.guard = expr;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement statement) {
        this.body = statement;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ASTList<LoopInitializer> getInitializers() {
        return this.inits;
    }

    public ASTList<Expression> getUpdates() {
        return this.updates;
    }

    public abstract boolean isExitCondition();

    public abstract boolean isCheckedBeforeIteration();

    public void setInitializers(ASTList<LoopInitializer> list) {
        this.inits = list;
    }

    public void setUpdates(ASTList<Expression> list) {
        this.updates = list;
    }

    @Override
    public abstract LoopStatement deepClone();
}

