/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.ModelException;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.statement.Branch;
import recoder.java.statement.BranchStatement;
import recoder.java.statement.Else;
import recoder.java.statement.Then;
import recoder.service.SyntaxException;

public class If
extends BranchStatement
implements ExpressionContainer {
    private static final long serialVersionUID = -6352480723638689470L;
    private Then thenBranch;
    private Else elseBranch;
    private Expression expression;

    public If() {
    }

    public If(Expression e, Statement thenStatement) {
        this(e, thenStatement, null);
    }

    public If(Expression e, Then thenBranch) {
        this(e, thenBranch, null);
    }

    public If(Expression e, Then thenBranch, Else elseBranch) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.expression = e;
        this.setThen(thenBranch);
        this.setElse(elseBranch);
        this.makeParentRoleValid();
    }

    public If(Expression e, Statement thenStatement, Statement elseStatement) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.expression = e;
        this.setThen(this.getFactory().createThen(thenStatement));
        if (elseStatement != null) {
            this.setElse(this.getFactory().createElse(elseStatement));
        }
        this.makeParentRoleValid();
    }

    protected If(If proto) {
        super(proto);
        if (proto.thenBranch != null) {
            this.thenBranch = proto.thenBranch.deepClone();
        }
        if (proto.elseBranch != null) {
            this.elseBranch = proto.elseBranch.deepClone();
        }
        if (proto.expression != null) {
            this.expression = proto.expression.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public If deepClone() {
        return new If(this);
    }

    @Override
    public SourceElement getLastElement() {
        return this.getChildAt(this.getChildCount() - 1).getLastElement();
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.expression != null) {
            ++result;
        }
        if (this.thenBranch != null) {
            ++result;
        }
        if (this.elseBranch != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.expression != null) {
            if (index == 0) {
                return this.expression;
            }
            --index;
        }
        if (this.thenBranch != null) {
            if (index == 0) {
                return this.thenBranch;
            }
            --index;
        }
        if (this.elseBranch != null && index == 0) {
            return this.elseBranch;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.expression == child) {
            return 0;
        }
        if (this.thenBranch == child) {
            return 1;
        }
        if (this.elseBranch == child) {
            return 2;
        }
        return -1;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.expression != null) {
            this.expression.setExpressionContainer(this);
        }
        if (this.thenBranch != null) {
            this.thenBranch.setParent(this);
        }
        if (this.elseBranch != null) {
            this.elseBranch.setParent(this);
        }
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.expression == p) {
            Expression r;
            this.expression = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.thenBranch == p) {
            Then r;
            this.thenBranch = r = (Then)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.elseBranch == p) {
            Else r;
            this.elseBranch = r = (Else)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        return this.expression != null ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.expression != null && index == 0) {
            return this.expression;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expr) {
        this.expression = expr;
    }

    public Then getThen() {
        return this.thenBranch;
    }

    public Else getElse() {
        return this.elseBranch;
    }

    public void setThen(Then thenBranch) {
        this.thenBranch = thenBranch;
    }

    public void setElse(Else elseBranch) {
        this.elseBranch = elseBranch;
    }

    @Override
    public int getBranchCount() {
        int result = 0;
        if (this.thenBranch != null) {
            ++result;
        }
        if (this.elseBranch != null) {
            ++result;
        }
        return result;
    }

    @Override
    public Branch getBranchAt(int index) {
        if (this.thenBranch != null) {
            if (index == 0) {
                return this.thenBranch;
            }
            --index;
        }
        if (this.elseBranch != null && index == 0) {
            return this.elseBranch;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitIf(this);
    }

    @Override
    public void validate() throws ModelException {
        super.validate();
        if (this.getExpression() == null) {
            throw new SyntaxException(this, "No expression");
        }
        if (this.getThen() == null) {
            throw new SyntaxException(this, "No then-block");
        }
    }
}

