/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import java.util.Collections;
import java.util.List;
import recoder.java.ParameterContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.VariableScope;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.statement.Branch;
import recoder.java.statement.Try;
import recoder.util.Debug;

public class Catch
extends Branch
implements ParameterContainer,
VariableScope {
    private static final long serialVersionUID = -6747731923114431193L;
    private ParameterDeclaration parameter;
    private StatementBlock body;

    public Catch() {
    }

    public Catch(ParameterDeclaration e, StatementBlock body) {
        this.setBody(body);
        this.setParameterDeclaration(e);
        this.makeParentRoleValid();
    }

    protected Catch(Catch proto) {
        super(proto);
        if (proto.parameter != null) {
            this.parameter = proto.parameter.deepClone();
        }
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public Catch deepClone() {
        return new Catch(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.parameter != null) {
            this.parameter.setParameterContainer(this);
        }
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
    }

    @Override
    public SourceElement getLastElement() {
        return this.body != null ? this.body.getLastElement() : this;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.parameter != null) {
            ++result;
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.parameter != null) {
            if (index == 0) {
                return this.parameter;
            }
            --index;
        }
        if (this.body != null) {
            if (index == 0) {
                return this.body;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.parameter == child) {
            return 0;
        }
        if (this.body == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.parameter == p) {
            ParameterDeclaration r;
            this.parameter = r = (ParameterDeclaration)q;
            if (r != null) {
                r.setParameterContainer(this);
            }
            return true;
        }
        if (this.body == p) {
            StatementBlock r;
            this.body = r = (StatementBlock)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getParameterDeclarationCount() {
        return this.parameter != null ? 1 : 0;
    }

    @Override
    public ParameterDeclaration getParameterDeclarationAt(int index) {
        if (this.parameter != null && index == 0) {
            return this.parameter;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement statement) {
        this.body = (StatementBlock)statement;
    }

    public void setParent(Try parent) {
        this.parent = parent;
    }

    public ParameterDeclaration getParameterDeclaration() {
        return this.parameter;
    }

    public void setParameterDeclaration(ParameterDeclaration p) {
        this.parameter = p;
    }

    @Override
    public boolean isDefinedScope() {
        return true;
    }

    @Override
    public void setDefinedScope(boolean defined) {
    }

    public List<VariableSpecification> getVariablesInScope() {
        if (this.parameter != null) {
            return this.parameter.getVariables();
        }
        return Collections.emptyList();
    }

    @Override
    public VariableSpecification getVariableInScope(String name) {
        VariableSpecification v;
        Debug.assertNonnull(name);
        if (this.parameter != null && name.equals((v = this.parameter.getVariableSpecification()).getName())) {
            return v;
        }
        return null;
    }

    @Override
    public void addVariableToScope(VariableSpecification var) {
        Debug.assertNonnull(var);
    }

    @Override
    public void removeVariableFromScope(String name) {
        Debug.assertNonnull(name);
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitCatch(this);
    }
}

