/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.statement;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.statement.JavaStatement;

public class Assert
extends JavaStatement
implements ExpressionContainer {
    private static final long serialVersionUID = -5203926244893543507L;
    private Expression condition;
    private Expression message;

    public Assert() {
    }

    public Assert(Expression cond) {
        this(cond, null);
    }

    public Assert(Expression cond, Expression msg) {
        if (cond == null) {
            throw new NullPointerException();
        }
        this.condition = cond;
        this.message = msg;
        this.makeParentRoleValid();
    }

    protected Assert(Assert proto) {
        super(proto);
        if (proto.condition != null) {
            this.condition = proto.condition.deepClone();
        }
        if (proto.message != null) {
            this.message = proto.message.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public Assert deepClone() {
        return new Assert(this);
    }

    @Override
    public SourceElement getLastElement() {
        return this.message != null ? this.message.getLastElement() : this.condition.getLastElement();
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.condition != null) {
            ++result;
        }
        if (this.message != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.condition != null) {
            if (index == 0) {
                return this.condition;
            }
            --index;
        }
        if (this.message != null && index == 0) {
            return this.message;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.condition == child) {
            return 0;
        }
        if (this.message == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.condition != null) {
            this.condition.setExpressionContainer(this);
        }
        if (this.message != null) {
            this.message.setExpressionContainer(this);
        }
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.condition == p) {
            Expression r;
            this.condition = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        if (this.message == p) {
            Expression r;
            this.message = r = (Expression)q;
            if (r != null) {
                r.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getExpressionCount() {
        int c = 0;
        if (this.condition != null) {
            ++c;
        }
        if (this.message != null) {
            ++c;
        }
        return c;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.condition != null) {
            if (index == 0) {
                return this.condition;
            }
            --index;
        }
        if (this.message != null && index == 0) {
            return this.message;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression expr) {
        this.condition = expr;
    }

    public Expression getMessage() {
        return this.message;
    }

    public void setMessage(Expression expr) {
        this.message = expr;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitAssert(this);
    }
}

