/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.SpecialConstructorReference;
import recoder.list.generic.ASTList;

public class SuperConstructorReference
extends SpecialConstructorReference
implements ReferenceSuffix {
    private static final long serialVersionUID = 5432343818938120448L;
    private ReferencePrefix accessPath;
    private ASTList<TypeArgumentDeclaration> typeArguments;

    public SuperConstructorReference() {
        this.makeParentRoleValid();
    }

    public SuperConstructorReference(ASTList<Expression> arguments) {
        super(arguments);
        this.makeParentRoleValid();
    }

    public SuperConstructorReference(ReferencePrefix path, ASTList<Expression> arguments) {
        super(arguments);
        this.setReferencePrefix(path);
        this.makeParentRoleValid();
    }

    protected SuperConstructorReference(SuperConstructorReference proto) {
        super(proto);
        if (proto.accessPath != null) {
            this.accessPath = (ReferencePrefix)proto.accessPath.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.accessPath != null) {
            this.accessPath.setReferenceSuffix(this);
        }
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.accessPath == child) {
            return 0;
        }
        if (this.arguments != null && (index = this.arguments.indexOf(child)) >= 0) {
            return index << 4 | 1;
        }
        if (this.typeArguments != null && (index = this.arguments.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        return -1;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.accessPath;
    }

    public void setReferencePrefix(ReferencePrefix qualifier) {
        this.accessPath = qualifier;
    }

    @Override
    public SuperConstructorReference deepClone() {
        return new SuperConstructorReference(this);
    }

    @Override
    public SourceElement getFirstElement() {
        return this.accessPath == null ? this : this.accessPath.getFirstElement();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitSuperConstructorReference(this);
    }

    public String toString() {
        return "<SuperConstructorReference>";
    }
}

