/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Identifier;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.reference.PackageReferenceContainer;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReferenceInfix;

public class PackageReference
extends JavaNonTerminalProgramElement
implements TypeReferenceInfix,
PackageReferenceContainer {
    private static final long serialVersionUID = -4209613321578432317L;
    private ReferencePrefix prefix;
    private PackageReferenceContainer parent;
    private Identifier name;

    public PackageReference() {
    }

    public PackageReference(Identifier id) {
        this.setIdentifier(id);
        this.makeParentRoleValid();
    }

    public PackageReference(PackageReference path, Identifier id) {
        this.setReferencePrefix(path);
        this.setIdentifier(id);
        this.makeParentRoleValid();
    }

    protected PackageReference(PackageReference proto) {
        super(proto);
        if (proto.prefix != null) {
            this.prefix = (ReferencePrefix)proto.prefix.deepClone();
        }
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public PackageReference deepClone() {
        return new PackageReference(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.prefix != null) {
            this.prefix.setReferenceSuffix(this);
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.prefix == null ? this.name : this.prefix.getFirstElement();
    }

    @Override
    public SourceElement getLastElement() {
        return this.name;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.prefix != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.prefix != null) {
            if (index == 0) {
                return this.prefix;
            }
            --index;
        }
        if (this.name != null && index == 0) {
            return this.name;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.prefix == child) {
            return 0;
        }
        if (this.name == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.prefix == p) {
            PackageReference r = (PackageReference)q;
            this.prefix = r;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    public void setParent(PackageReferenceContainer parent) {
        this.parent = parent;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.prefix;
    }

    @Override
    public PackageReference getPackageReference() {
        return this.prefix instanceof PackageReference ? (PackageReference)this.prefix : null;
    }

    @Override
    public void setReferencePrefix(ReferencePrefix prefix) {
        this.prefix = prefix;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.parent instanceof ReferenceSuffix ? (ReferenceSuffix)((Object)this.parent) : null;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix x) {
        this.parent = (PackageReferenceContainer)((Object)x);
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitPackageReference(this);
    }

    public String toString() {
        return "<PackageReference> " + this.getName();
    }
}

