/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Identifier;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.StatementContainer;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.expression.ExpressionStatement;
import recoder.java.reference.MemberReference;
import recoder.java.reference.NameReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.list.generic.ASTList;

public class MethodReference
extends JavaNonTerminalProgramElement
implements MemberReference,
ReferencePrefix,
ReferenceSuffix,
ExpressionStatement,
TypeReferenceContainer,
NameReference {
    private static final long serialVersionUID = -3016310919182753074L;
    private ExpressionContainer expressionParent;
    private StatementContainer statementParent;
    private ReferenceSuffix qualifierParent;
    private ReferencePrefix accessPath;
    private Identifier name;
    private ASTList<Expression> arguments;
    private ASTList<TypeArgumentDeclaration> typeArguments;

    public MethodReference() {
    }

    public MethodReference(Identifier name) {
        this.setIdentifier(name);
        this.makeParentRoleValid();
    }

    public MethodReference(ReferencePrefix accessPath, Identifier name) {
        this.setReferencePrefix(accessPath);
        this.setIdentifier(name);
        this.makeParentRoleValid();
    }

    public MethodReference(Identifier name, ASTList<Expression> args) {
        this.setIdentifier(name);
        this.setArguments(args);
        this.makeParentRoleValid();
    }

    public MethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args) {
        this.setReferencePrefix(accessPath);
        this.setIdentifier(name);
        this.setArguments(args);
        this.makeParentRoleValid();
    }

    public MethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args, ASTList<TypeArgumentDeclaration> typeArgs) {
        this.setReferencePrefix(accessPath);
        this.setIdentifier(name);
        this.setArguments(args);
        this.setTypeArguments(typeArgs);
        this.makeParentRoleValid();
    }

    protected MethodReference(MethodReference proto) {
        super(proto);
        if (proto.accessPath != null) {
            this.accessPath = (ReferencePrefix)proto.accessPath.deepClone();
        }
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.arguments != null) {
            this.arguments = proto.arguments.deepClone();
        }
        if (proto.typeArguments != null) {
            this.typeArguments = proto.typeArguments.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public MethodReference deepClone() {
        return new MethodReference(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.accessPath != null) {
            this.accessPath.setReferenceSuffix(this);
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.arguments != null) {
            int i = this.arguments.size() - 1;
            while (i >= 0) {
                ((Expression)this.arguments.get(i)).setExpressionContainer(this);
                --i;
            }
        }
        if (this.typeArguments != null) {
            for (TypeArgumentDeclaration ta : this.typeArguments) {
                ta.setParent(this);
            }
        }
    }

    @Override
    public SourceElement getFirstElement() {
        return this.accessPath == null ? this.getChildAt(0).getFirstElement() : this.accessPath.getFirstElement();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        if (this.statementParent != null) {
            return this.statementParent;
        }
        if (this.expressionParent != null) {
            return this.expressionParent;
        }
        return this.qualifierParent;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.accessPath;
    }

    public void setReferencePrefix(ReferencePrefix qualifier) {
        this.accessPath = qualifier;
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.qualifierParent;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix path) {
        this.qualifierParent = path;
        this.expressionParent = null;
        this.statementParent = null;
    }

    @Override
    public StatementContainer getStatementContainer() {
        return this.statementParent;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.expressionParent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer parent) {
        this.expressionParent = parent;
        this.statementParent = null;
        this.qualifierParent = null;
    }

    @Override
    public void setStatementContainer(StatementContainer parent) {
        this.statementParent = parent;
        this.expressionParent = null;
        this.qualifierParent = null;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.accessPath != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        if (this.arguments != null) {
            result += this.arguments.size();
        }
        if (this.typeArguments != null) {
            result += this.typeArguments.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.accessPath != null) {
            if (index == 0) {
                return this.accessPath;
            }
            --index;
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.arguments != null) {
            len = this.arguments.size();
            if (len > index) {
                return (ProgramElement)this.arguments.get(index);
            }
            index -= len;
        }
        if (this.typeArguments != null) {
            len = this.typeArguments.size();
            if (len > index) {
                return (ProgramElement)this.typeArguments.get(index);
            }
            index -= len;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.accessPath == child) {
            return 0;
        }
        if (this.name == child) {
            return 1;
        }
        if (this.arguments != null && (index = this.arguments.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        if (this.typeArguments != null && (index = this.typeArguments.indexOf(child)) >= 0) {
            return index << 4 | 3;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.accessPath == p) {
            ReferencePrefix r;
            this.accessPath = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        int count = this.arguments == null ? 0 : this.arguments.size();
        int i = 0;
        while (i < count) {
            if (this.arguments.get(i) == p) {
                if (q == null) {
                    this.arguments.remove(i);
                } else {
                    Expression r = (Expression)q;
                    this.arguments.set(i, r);
                    r.setExpressionContainer(this);
                }
                return true;
            }
            ++i;
        }
        if (this.typeArguments != null && (idx = this.typeArguments.indexOf(p)) != -1) {
            if (q == null) {
                this.typeArguments.remove(idx);
            } else {
                TypeArgumentDeclaration tad = (TypeArgumentDeclaration)q;
                this.typeArguments.set(idx, tad);
                tad.setParent(this);
            }
        }
        return false;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.accessPath instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.accessPath instanceof TypeReference && index == 0) {
            return (TypeReference)this.accessPath;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getExpressionCount() {
        int result = 0;
        if (this.accessPath instanceof Expression) {
            ++result;
        }
        if (this.arguments != null) {
            result += this.arguments.size();
        }
        return result;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.accessPath instanceof Expression) {
            if (index == 0) {
                return (Expression)((Object)this.accessPath);
            }
            --index;
        }
        if (this.arguments != null) {
            return (Expression)this.arguments.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    public ASTList<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(ASTList<Expression> list) {
        this.arguments = list;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitMethodReference(this);
    }

    public void setTypeArguments(ASTList<TypeArgumentDeclaration> typeArguments) {
        this.typeArguments = typeArguments;
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        return this.typeArguments;
    }

    public String toString() {
        return "<MethodReference> " + this.name.getText() + "(" + (this.arguments == null ? 0 : this.arguments.size()) + ")";
    }
}

