/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.reference.MemberReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.VariableReference;

public class FieldReference
extends VariableReference
implements MemberReference,
ReferenceSuffix,
TypeReferenceContainer,
ExpressionContainer {
    private static final long serialVersionUID = -1475141413582182288L;
    private ReferencePrefix prefix;

    public FieldReference() {
    }

    public FieldReference(Identifier id) {
        super(id);
    }

    public FieldReference(ReferencePrefix prefix, Identifier id) {
        super(id);
        this.setReferencePrefix(prefix);
        this.makeParentRoleValid();
    }

    protected FieldReference(FieldReference proto) {
        super(proto);
        if (proto.prefix != null) {
            this.prefix = (ReferencePrefix)proto.prefix.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public FieldReference deepClone() {
        return new FieldReference(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.prefix != null) {
            this.prefix.setReferenceSuffix(this);
        }
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.prefix != null) {
            ++result;
        }
        if (this.name != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.prefix != null) {
            if (index == 0) {
                return this.prefix;
            }
            --index;
        }
        if (this.name != null && index == 0) {
            return this.name;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (this.prefix == child) {
            return 0;
        }
        if (this.name == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.prefix;
    }

    public void setReferencePrefix(ReferencePrefix prefix) {
        this.prefix = prefix;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.prefix instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.prefix instanceof TypeReference && index == 0) {
            return (TypeReference)this.prefix;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getExpressionCount() {
        return this.prefix instanceof Expression ? 1 : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.prefix instanceof Expression && index == 0) {
            return (Expression)((Object)this.prefix);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.prefix == p) {
            ReferencePrefix r;
            this.prefix = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public SourceElement getFirstElement() {
        return this.prefix == null ? this.name : this.prefix.getFirstElement();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitFieldReference(this);
    }

    @Override
    public String toString() {
        return "<FieldReference> " + this.getName();
    }
}

