/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.StatementContainer;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.reference.ConstructorReference;
import recoder.list.generic.ASTList;

public class EnumConstructorReference
extends JavaNonTerminalProgramElement
implements ConstructorReference,
TypeDeclarationContainer {
    private static final long serialVersionUID = 346152574064180781L;
    private ClassDeclaration classDeclaration;
    private ASTList<Expression> args;
    private EnumConstantSpecification parent;

    public EnumConstructorReference() {
    }

    public EnumConstructorReference(ASTList<Expression> args, ClassDeclaration anonymousClass) {
        this.args = args;
        this.classDeclaration = anonymousClass;
        this.makeParentRoleValid();
    }

    protected EnumConstructorReference(EnumConstructorReference proto) {
        super(proto);
        if (proto.classDeclaration != null) {
            this.classDeclaration = proto.classDeclaration.deepClone();
        }
        if (proto.args != null) {
            this.args = proto.args.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitEnumConstructorReference(this);
    }

    @Override
    public EnumConstructorReference deepClone() {
        return new EnumConstructorReference(this);
    }

    @Override
    public StatementContainer getStatementContainer() {
        return null;
    }

    @Override
    public void setStatementContainer(StatementContainer c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTypeDeclarationCount() {
        return this.classDeclaration == null ? 0 : 1;
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.classDeclaration != null && index == 0) {
            return this.classDeclaration;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.args != null) {
            int l = this.args.size();
            if (index < l) {
                return (ProgramElement)this.args.get(index);
            }
            index -= l;
        }
        if (this.classDeclaration != null) {
            if (index == 0) {
                return this.classDeclaration;
            }
            --index;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount() {
        return this.getTypeDeclarationCount() + (this.args == null ? 0 : this.args.size());
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.classDeclaration != null) {
            this.classDeclaration.setParent(this);
        }
        if (this.args != null) {
            int i = 0;
            int max = this.args.size();
            while (i < max) {
                Expression e = (Expression)this.args.get(i);
                e.setExpressionContainer(this);
                ++i;
            }
        }
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        if (p == this.classDeclaration) {
            this.classDeclaration = (ClassDeclaration)q;
            if (q != null) {
                this.classDeclaration.setParent(this);
            }
            return true;
        }
        if (this.args != null && (idx = this.args.indexOf(p)) != -1) {
            if (q == null) {
                this.args.remove(idx);
            } else {
                Expression s = (Expression)q;
                this.args.set(idx, s);
                s.setExpressionContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int idx;
        if (child == this.classDeclaration) {
            return 0;
        }
        if (this.args != null && (idx = this.args.indexOf(child)) != -1) {
            return idx << 4 | 1;
        }
        return -1;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    public final void setClassDeclaration(ClassDeclaration classDeclaration) {
        this.classDeclaration = classDeclaration;
    }

    @Override
    public ASTList<Expression> getArguments() {
        return this.args;
    }

    @Override
    public void setArguments(ASTList<Expression> list) {
        this.args = list;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    public void setParent(EnumConstantSpecification parent) {
        this.parent = parent;
    }

    @Override
    public int getExpressionCount() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.args == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (Expression)this.args.get(index);
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        return null;
    }

    @Override
    public ProgramElement getFirstElement() {
        if (this.args != null && this.args.size() > 0) {
            return (ProgramElement)this.args.get(0);
        }
        return this;
    }

    @Override
    public ProgramElement getLastElement() {
        if (this.classDeclaration != null) {
            return this.classDeclaration;
        }
        if (this.args != null && this.args.size() > 0) {
            return (ProgramElement)this.args.get(this.args.size() - 1);
        }
        return this;
    }
}

