/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.reference;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.list.generic.ASTList;

public class ArrayReference
extends JavaNonTerminalProgramElement
implements Reference,
Expression,
ReferencePrefix,
ReferenceSuffix,
ExpressionContainer,
TypeReferenceContainer {
    private static final long serialVersionUID = 5264208667205795216L;
    private ReferenceSuffix accessParent;
    private ExpressionContainer parent;
    private ReferencePrefix accessPath;
    private ASTList<Expression> inits;

    public ArrayReference() {
    }

    public ArrayReference(ReferencePrefix accessPath, ASTList<Expression> initializers) {
        this.setReferencePrefix(accessPath);
        this.setDimensionExpressions(initializers);
        this.makeParentRoleValid();
    }

    protected ArrayReference(ArrayReference proto) {
        super(proto);
        if (proto.accessPath != null) {
            this.accessPath = (ReferencePrefix)proto.accessPath.deepClone();
        }
        if (proto.inits != null) {
            this.inits = proto.inits.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public ArrayReference deepClone() {
        return new ArrayReference(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.accessPath != null) {
            this.accessPath.setReferenceSuffix(this);
        }
        if (this.inits != null) {
            int i = this.inits.size() - 1;
            while (i >= 0) {
                ((Expression)this.inits.get(i)).setExpressionContainer(this);
                --i;
            }
        }
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return this.accessParent;
    }

    @Override
    public int getExpressionCount() {
        int c = 0;
        if (this.accessPath instanceof Expression) {
            ++c;
        }
        if (this.inits != null) {
            c += this.inits.size();
        }
        return c;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.accessPath instanceof Expression) {
            if (index == 0) {
                return (Expression)((Object)this.accessPath);
            }
            --index;
        }
        if (this.inits != null) {
            return (Expression)this.inits.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.accessPath == p) {
            ReferencePrefix r;
            this.accessPath = r = (ReferencePrefix)q;
            if (r != null) {
                r.setReferenceSuffix(this);
            }
            return true;
        }
        int count = this.inits == null ? 0 : this.inits.size();
        int i = 0;
        while (i < count) {
            if (this.inits.get(i) == p) {
                if (q == null) {
                    this.inits.remove(i);
                } else {
                    Expression r = (Expression)q;
                    this.inits.set(i, r);
                    r.setExpressionContainer(this);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.accessPath instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.accessPath instanceof TypeReference && index == 0) {
            return (TypeReference)this.accessPath;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public ReferenceSuffix getReferenceSuffix() {
        return this.accessParent;
    }

    @Override
    public void setReferenceSuffix(ReferenceSuffix path) {
        this.accessParent = path;
    }

    @Override
    public ReferencePrefix getReferencePrefix() {
        return this.accessPath;
    }

    public void setReferencePrefix(ReferencePrefix accessPath) {
        this.accessPath = accessPath;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.accessPath != null) {
            ++result;
        }
        if (this.inits != null) {
            result += this.inits.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.accessPath != null) {
            if (index == 0) {
                return this.accessPath;
            }
            --index;
        }
        if (this.inits != null) {
            return (ProgramElement)this.inits.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.accessPath == child) {
            return 0;
        }
        if (this.inits != null && (index = this.inits.indexOf(child)) >= 0) {
            return index << 4 | 1;
        }
        return -1;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.parent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer c) {
        this.parent = c;
    }

    public ASTList<Expression> getDimensionExpressions() {
        return this.inits;
    }

    public void setDimensionExpressions(ASTList<Expression> list) {
        this.inits = list;
    }

    @Override
    public SourceElement getFirstElement() {
        return this.accessPath == null ? this : this.accessPath.getFirstElement();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitArrayReference(this);
    }

    public String toString() {
        return "<ArrayReference>";
    }
}

