/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.literal;

import recoder.java.SourceVisitor;
import recoder.java.expression.Literal;

public class LongLiteral
extends Literal {
    private static final long serialVersionUID = -8507020453717633759L;
    private String value;

    public LongLiteral() {
        this.setValue("0L");
    }

    public LongLiteral(long value) {
        this.setValue("" + value + 'L');
    }

    public LongLiteral(String value) {
        this.setValue(value.endsWith("L") || value.endsWith("l") ? value : String.valueOf(value) + 'L');
    }

    protected LongLiteral(LongLiteral proto) {
        super(proto);
        this.value = proto.value;
    }

    @Override
    public LongLiteral deepClone() {
        return new LongLiteral(this);
    }

    public void setValue(String str) {
        this.value = str.intern();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitLongLiteral(this);
    }

    @Override
    public Object getEquivalentJavaType() {
        return Long.valueOf(this.value);
    }
}

