/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.literal;

import recoder.java.SourceVisitor;
import recoder.java.expression.Literal;

public class FloatLiteral
extends Literal {
    private static final long serialVersionUID = 9215865599908556320L;
    private String value;

    public FloatLiteral() {
        this.setValue("0.0F");
    }

    public FloatLiteral(float value) {
        this.setValue("" + value + 'F');
    }

    public FloatLiteral(String value) {
        this.setValue(value.endsWith("F") || value.endsWith("f") ? value : String.valueOf(value) + 'F');
    }

    protected FloatLiteral(FloatLiteral proto) {
        super(proto);
        this.value = proto.value;
    }

    @Override
    public FloatLiteral deepClone() {
        return new FloatLiteral(this);
    }

    public void setValue(String str) {
        this.value = str.intern();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitFloatLiteral(this);
    }

    @Override
    public Object getEquivalentJavaType() {
        return Float.valueOf(this.value);
    }
}

