/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression.literal;

import recoder.java.SourceVisitor;
import recoder.java.expression.Literal;

public class CharLiteral
extends Literal {
    private static final long serialVersionUID = -558509934440205638L;
    private String value;

    public CharLiteral() {
    }

    public CharLiteral(char value) {
        this.setValue(value);
    }

    public CharLiteral(String value) {
        this.setValue(value);
    }

    protected CharLiteral(CharLiteral proto) {
        super(proto);
        this.value = proto.value;
    }

    @Override
    public CharLiteral deepClone() {
        return new CharLiteral(this);
    }

    public void setValue(char c) {
        this.setValue("'" + c + "'");
    }

    public void setValue(String str) {
        if (!str.startsWith("'") || !str.endsWith("'")) {
            throw new IllegalArgumentException("Bad char literal " + this.value);
        }
        this.value = str.intern();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitCharLiteral(this);
    }

    @Override
    public Object getEquivalentJavaType() {
        return Character.valueOf(this.value.charAt(0));
    }
}

