/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.expression;

import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.list.generic.ASTList;

public class ArrayInitializer
extends JavaNonTerminalProgramElement
implements Expression,
ExpressionContainer {
    private static final long serialVersionUID = 7171507009155916797L;
    private ExpressionContainer expressionParent;
    private ASTList<Expression> children;

    public ArrayInitializer() {
    }

    public ArrayInitializer(ASTList<Expression> args) {
        this.setArguments(args);
        this.makeParentRoleValid();
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.children != null) {
            int i = this.children.size() - 1;
            while (i >= 0) {
                ((Expression)this.children.get(i)).setExpressionContainer(this);
                --i;
            }
        }
    }

    protected ArrayInitializer(ArrayInitializer proto) {
        super(proto);
        if (proto.children != null) {
            this.children = proto.children.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public ArrayInitializer deepClone() {
        return new ArrayInitializer(this);
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.expressionParent;
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.children != null) {
            return (ProgramElement)this.children.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.children != null && (index = this.children.indexOf(child)) >= 0) {
            return index << 4;
        }
        return -1;
    }

    @Override
    public ExpressionContainer getExpressionContainer() {
        return this.expressionParent;
    }

    @Override
    public void setExpressionContainer(ExpressionContainer c) {
        this.expressionParent = c;
    }

    @Override
    public int getExpressionCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public Expression getExpressionAt(int index) {
        if (this.children != null) {
            return (Expression)this.children.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.children == null ? 0 : this.children.size();
        int i = 0;
        while (i < count) {
            if (this.children.get(i) == p) {
                if (q == null) {
                    this.children.remove(i);
                } else {
                    Expression r = (Expression)q;
                    this.children.set(i, r);
                    r.setExpressionContainer(this);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public ASTList<Expression> getArguments() {
        return this.children;
    }

    public void setArguments(ASTList<Expression> list) {
        this.children = list;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitArrayInitializer(this);
    }
}

