/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.convenience.Naming;
import recoder.java.Identifier;
import recoder.java.NamedProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.SourceElement;
import recoder.java.TypeScope;
import recoder.java.VariableScope;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.JavaDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public abstract class TypeDeclaration
extends JavaDeclaration
implements NamedProgramElement,
MemberDeclaration,
TypeDeclarationContainer,
ClassType,
VariableScope,
TypeScope {
    private static final long serialVersionUID = 1L;
    Identifier name;
    TypeDeclarationContainer parent;
    ASTList<MemberDeclaration> members;
    private SourceInfo service;
    private ArrayType arrayType;
    private static final Map UNDEFINED_SCOPE = Collections.unmodifiableMap(new HashMap(0));
    protected Map<String, TypeDeclaration> name2type = UNDEFINED_SCOPE;
    protected Map<String, FieldSpecification> name2field = UNDEFINED_SCOPE;
    private ErasedType erasedType;

    public TypeDeclaration() {
    }

    public TypeDeclaration(Identifier name) {
        this.setIdentifier(name);
    }

    public TypeDeclaration(ASTList<DeclarationSpecifier> mods, Identifier name) {
        super(mods);
        this.setIdentifier(name);
    }

    protected TypeDeclaration(TypeDeclaration proto) {
        super(proto);
        if (proto.name != null) {
            this.name = proto.name.deepClone();
        }
        if (proto.members != null) {
            this.members = proto.members.deepClone();
        }
    }

    @Override
    public void makeParentRoleValid() {
        int i;
        if (this.declarationSpecifiers != null) {
            i = this.declarationSpecifiers.size() - 1;
            while (i >= 0) {
                ((DeclarationSpecifier)this.declarationSpecifiers.get(i)).setParent(this);
                --i;
            }
        }
        if (this.name != null) {
            this.name.setParent(this);
        }
        if (this.members != null) {
            i = this.members.size() - 1;
            while (i >= 0) {
                ((MemberDeclaration)this.members.get(i)).setMemberParent(this);
                --i;
            }
        }
    }

    @Override
    public SourceElement getFirstElement() {
        if (this.declarationSpecifiers != null && !this.declarationSpecifiers.isEmpty()) {
            return (SourceElement)this.declarationSpecifiers.get(0);
        }
        return this;
    }

    @Override
    public SourceElement getLastElement() {
        return this;
    }

    @Override
    public final String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    @Override
    public void setIdentifier(Identifier id) {
        this.name = id;
    }

    public TypeDeclarationContainer getParent() {
        return this.parent;
    }

    @Override
    public TypeDeclaration getMemberParent() {
        if (this.parent instanceof TypeDeclaration) {
            return (TypeDeclaration)this.parent;
        }
        return null;
    }

    public void setParent(TypeDeclarationContainer p) {
        this.parent = p;
    }

    @Override
    public void setMemberParent(TypeDeclaration p) {
        this.parent = p;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    public ASTList<MemberDeclaration> getMembers() {
        return this.members;
    }

    public void setMembers(ASTList<MemberDeclaration> list) {
        this.members = list;
    }

    @Override
    public int getTypeDeclarationCount() {
        int count = 0;
        if (this.members != null) {
            int i = this.members.size() - 1;
            while (i >= 0) {
                if (this.members.get(i) instanceof TypeDeclaration) {
                    ++count;
                }
                --i;
            }
        }
        if (this.getTypeParameters() != null) {
            count += this.getTypeParameters().size();
        }
        return count;
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.members != null) {
            int s = this.members.size();
            int i = 0;
            while (i < s && index >= 0) {
                MemberDeclaration md = (MemberDeclaration)this.members.get(i);
                if (md instanceof TypeDeclaration) {
                    if (index == 0) {
                        return (TypeDeclaration)md;
                    }
                    --index;
                }
                ++i;
            }
        }
        if (this.getTypeParameters() != null) {
            return (TypeDeclaration)this.getTypeParameters().get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean isFinal() {
        return super.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return super.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return super.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isStatic();
    }

    @Override
    public boolean isStrictFp() {
        return super.isStrictFp();
    }

    @Override
    public boolean isAbstract() {
        return super.isAbstract();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.service;
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo service) {
        if (!(service instanceof SourceInfo)) {
            throw new IllegalArgumentException("service for TypeDeclaration must be of type SourceInfo.");
        }
        this.service = (SourceInfo)service;
    }

    private void updateModel() {
        this.getFactory().getServiceConfiguration().getChangeHistory().updateModel();
    }

    @Override
    public String getFullName() {
        return Naming.getFullName(this);
    }

    @Override
    public String getBinaryName() {
        throw new RuntimeException();
    }

    @Override
    public ClassTypeContainer getContainer() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getClassTypeContainer(this);
    }

    @Override
    public ClassType getContainingClassType() {
        ClassTypeContainer ctc;
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return (ctc = this.service.getClassTypeContainer(this)) instanceof ClassType ? (ClassType)ctc : null;
    }

    @Override
    public Package getPackage() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getPackage(this);
    }

    @Override
    public abstract boolean isInterface();

    @Override
    public List<ClassType> getSupertypes() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getSupertypes(this);
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getAllSupertypes(this);
    }

    public List<FieldSpecification> getFields() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        List<FieldSpecification> fields = this.service.getFields(this);
        return fields;
    }

    @Override
    public List<Field> getAllFields() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getAllFields(this);
    }

    @Override
    public List<Method> getMethods() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getMethods(this);
    }

    @Override
    public List<Method> getAllMethods() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getAllMethods(this);
    }

    @Override
    public List<? extends Constructor> getConstructors() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getConstructors(this);
    }

    public List<TypeDeclaration> getTypes() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        List<TypeDeclaration> types = this.service.getTypes(this);
        return types;
    }

    @Override
    public List<ClassType> getAllTypes() {
        if (this.service == null) {
            Debug.log("Zero service while " + Debug.makeStackTrace());
            this.updateModel();
        }
        if (this.service == null) {
            Debug.error("Service not defined in TypeDeclaration " + this.getName());
        }
        return this.service.getAllTypes(this);
    }

    @Override
    public boolean isDefinedScope() {
        return this.name2type != UNDEFINED_SCOPE;
    }

    @Override
    public void setDefinedScope(boolean defined) {
        if (!defined) {
            this.name2type = UNDEFINED_SCOPE;
            this.name2field = UNDEFINED_SCOPE;
        } else {
            this.name2type = null;
            this.name2field = null;
        }
    }

    public List<TypeDeclaration> getTypesInScope() {
        if (this.name2type == null || this.name2type.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeDeclaration> res = new ArrayList<TypeDeclaration>();
        for (TypeDeclaration td : this.name2type.values()) {
            res.add(td);
        }
        return res;
    }

    @Override
    public ClassType getTypeInScope(String tname) {
        Debug.assertNonnull(tname);
        if (this.name2type == null) {
            return null;
        }
        return this.name2type.get(tname);
    }

    @Override
    public void addTypeToScope(ClassType type, String tname) {
        Debug.assertNonnull((Object)type, tname);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            this.name2type = new HashMap<String, TypeDeclaration>();
        }
        this.name2type.put(tname, (TypeDeclaration)type);
    }

    @Override
    public void removeTypeFromScope(String tname) {
        Debug.assertNonnull(tname);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            return;
        }
        this.name2type.remove(tname);
    }

    public List<FieldSpecification> getFieldsInScope() {
        if (this.name2field == null || this.name2field.isEmpty()) {
            return new ASTArrayList<boolean>(false);
        }
        ASTArrayList<FieldSpecification> res = new ASTArrayList<FieldSpecification>();
        for (FieldSpecification fs : this.name2field.values()) {
            res.add(fs);
        }
        return res;
    }

    @Override
    public List<? extends VariableSpecification> getVariablesInScope() {
        return this.getFieldsInScope();
    }

    @Override
    public VariableSpecification getVariableInScope(String tname) {
        Debug.assertNonnull(tname);
        if (this.name2field == null) {
            return null;
        }
        return this.name2field.get(tname);
    }

    @Override
    public void addVariableToScope(VariableSpecification var) {
        Debug.assertBoolean(var instanceof FieldSpecification || var instanceof EnumConstantSpecification && this instanceof EnumDeclaration);
        if (this.name2field == null || this.name2field == UNDEFINED_SCOPE) {
            this.name2field = new HashMap<String, FieldSpecification>();
        }
        this.name2field.put(var.getName(), (FieldSpecification)var);
    }

    @Override
    public void removeVariableFromScope(String tname) {
        Debug.assertNonnull(tname);
        if (this.name2field == null || this.name2field == UNDEFINED_SCOPE) {
            return;
        }
        this.name2field.remove(tname);
    }

    public abstract ASTList<TypeParameterDeclaration> getTypeParameters();

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getFullName();
    }

    @Override
    public abstract TypeDeclaration deepClone();

    @Override
    public String getFullSignature() {
        String res = this.getFullName();
        List tps = this.getTypeParameters();
        if (tps == null || tps.size() == 0) {
            return res;
        }
        res = String.valueOf(res) + "<";
        String delim = "";
        for (TypeParameterDeclaration tpd : tps) {
            res = String.valueOf(res) + delim;
            res = String.valueOf(res) + tpd.getFullSignature();
            delim = ",";
        }
        res = String.valueOf(res) + ">";
        return res;
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.service.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    @Override
    public ErasedType getErasedType() {
        if (this.erasedType == null) {
            this.erasedType = new ErasedType(this, this.getFactory().getServiceConfiguration().getImplicitElementInfo());
        }
        return this.erasedType;
    }

    @Override
    public ClassType getBaseClassType() {
        return this;
    }
}

