/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.convenience.Naming;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.expression.operator.New;
import recoder.java.reference.MethodReference;
import recoder.java.reference.SpecialConstructorReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.list.generic.ASTList;
import recoder.service.DefaultImplicitElementInfo;
import recoder.service.DefaultSourceInfo;

public class TypeArgumentDeclaration
extends JavaNonTerminalProgramElement
implements TypeReferenceContainer,
TypeArgument {
    private static final long serialVersionUID = -8369885569636132718L;
    private TypeReference typeReference;
    private TypeArgument.WildcardMode wildcardMode;
    private Reference parent;

    public TypeArgumentDeclaration() {
        this(null, TypeArgument.WildcardMode.Any);
    }

    protected TypeArgumentDeclaration(TypeArgumentDeclaration proto) {
        super(proto);
        this.wildcardMode = proto.wildcardMode;
        if (proto.typeReference != null) {
            this.typeReference = proto.typeReference.deepClone();
        }
        this.makeParentRoleValid();
    }

    public TypeArgumentDeclaration(TypeReference tr) {
        this(tr, TypeArgument.WildcardMode.None);
    }

    public TypeArgumentDeclaration(TypeReference tr, TypeArgument.WildcardMode wm) {
        this.typeReference = tr;
        this.wildcardMode = wm;
        this.makeParentRoleValid();
    }

    @Override
    public int getTypeReferenceCount() {
        return this.typeReference == null ? 0 : 1;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (index == 0 && this.typeReference != null) {
            return this.typeReference;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public int getChildCount() {
        return this.getTypeReferenceCount();
    }

    @Override
    public ProgramElement getChildAt(int index) {
        return this.getTypeReferenceAt(index);
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (child == this.typeReference) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p == this.typeReference) {
            this.typeReference = (TypeReference)q;
            if (this.typeReference != null) {
                this.typeReference.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return (NonTerminalProgramElement)((Object)this.parent);
    }

    public Reference getParent() {
        return this.parent;
    }

    public void setParent(Reference tr) {
        this.parent = tr;
        if (!(tr instanceof TypeReference || tr instanceof UncollatedReferenceQualifier || tr instanceof MethodReference || tr instanceof SpecialConstructorReference || tr instanceof New)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitTypeArgument(this);
    }

    @Override
    public TypeArgumentDeclaration deepClone() {
        return new TypeArgumentDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.typeReference != null) {
            this.typeReference.setParent(this);
        }
    }

    @Override
    public TypeArgument.WildcardMode getWildcardMode() {
        return this.wildcardMode;
    }

    @Override
    public String getTypeName() {
        if (this.isTypeVariable()) {
            return this.typeReference.getName();
        }
        if (this.typeReference == null) {
            assert (this.wildcardMode == TypeArgument.WildcardMode.Any);
            return "";
        }
        String trName = Naming.toPathName(this.typeReference);
        Type t = ((DefaultSourceInfo)this.getFactory().getServiceConfiguration().getSourceInfo()).getType(trName, this.typeReference);
        if (t == null) {
            return "<Unknown>." + this.typeReference.getName();
        }
        return t.getFullName();
    }

    public ASTList<TypeArgumentDeclaration> getTypeArguments() {
        if (this.wildcardMode == TypeArgument.WildcardMode.Any) {
            return null;
        }
        return this.typeReference.getTypeArguments();
    }

    public void setWildcardMode(TypeArgument.WildcardMode wm) {
        this.wildcardMode = wm;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference tr) {
        this.typeReference = tr;
    }

    @Override
    public SourceElement getFirstElement() {
        if (this.wildcardMode != TypeArgument.WildcardMode.None) {
            return this;
        }
        return this.typeReference == null ? this : this.typeReference.getFirstElement();
    }

    @Override
    public boolean semanticalEquality(TypeArgument tad) {
        return TypeArgument.EqualsImpl.equals(this, tad, (DefaultImplicitElementInfo)this.parent.getFactory().getServiceConfiguration().getImplicitElementInfo());
    }

    @Override
    public int semanticalHashCode() {
        return TypeArgument.EqualsImpl.semanticalHashCode(this);
    }

    @Override
    public TypeParameter getTargetedTypeParameter() {
        if (this.parent instanceof TypeReference) {
            int idx = ((TypeReference)this.parent).getTypeArguments().indexOf(this);
            ClassType t = (ClassType)this.getFactory().getServiceConfiguration().getSourceInfo().getType(this.parent);
            assert (t instanceof ParameterizedType);
            return ((ParameterizedType)t).getGenericType().getTypeParameters().get(idx);
        }
        return null;
    }

    @Override
    public String getFullSignature() {
        return TypeArgument.DescriptionImpl.getFullDescription(this);
    }

    @Override
    public boolean isTypeVariable() {
        if (this.typeReference == null) {
            assert (this.wildcardMode == TypeArgument.WildcardMode.Any);
            return false;
        }
        if (this.typeReference.getReferencePrefix() != null) {
            return false;
        }
        NonTerminalProgramElement nt = (NonTerminalProgramElement)((Object)this.parent);
        while (nt != null) {
            int i;
            List tps;
            if (nt instanceof MethodDeclaration) {
                tps = ((MethodDeclaration)nt).getTypeParameters();
                if (tps != null) {
                    i = 0;
                    while (i < tps.size()) {
                        if (((TypeParameterDeclaration)tps.get(i)).getName().equals(this.typeReference.getName())) {
                            return true;
                        }
                        ++i;
                    }
                }
            } else if (nt instanceof TypeDeclaration && (tps = ((TypeDeclaration)nt).getTypeParameters()) != null) {
                i = 0;
                while (i < tps.size()) {
                    if (((TypeParameterDeclaration)tps.get(i)).getName().equals(this.typeReference.getName())) {
                        return true;
                    }
                    ++i;
                }
            }
            nt = nt.getASTParent();
        }
        return false;
    }
}

