/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import recoder.java.Declaration;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.Modifier;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.declaration.modifier.Volatile;
import recoder.list.generic.ASTList;

public abstract class JavaDeclaration
extends JavaNonTerminalProgramElement
implements Declaration {
    private static final long serialVersionUID = 1L;
    ASTList<DeclarationSpecifier> declarationSpecifiers;

    public JavaDeclaration() {
    }

    public JavaDeclaration(ASTList<DeclarationSpecifier> mods) {
        this.setDeclarationSpecifiers(mods);
    }

    protected JavaDeclaration(JavaDeclaration proto) {
        super(proto);
        if (proto.declarationSpecifiers != null) {
            this.declarationSpecifiers = proto.declarationSpecifiers.deepClone();
        }
    }

    public List<Modifier> getModifiers() {
        if (this.declarationSpecifiers == null) {
            return Collections.emptyList();
        }
        ArrayList<Modifier> mml = new ArrayList<Modifier>();
        int i = 0;
        int max = this.declarationSpecifiers.size();
        while (i < max) {
            DeclarationSpecifier ds = (DeclarationSpecifier)this.declarationSpecifiers.get(i);
            if (ds instanceof Modifier) {
                mml.add((Modifier)ds);
            }
            ++i;
        }
        mml.trimToSize();
        return mml;
    }

    public List<AnnotationUseSpecification> getAnnotations() {
        if (this.declarationSpecifiers == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUseSpecification> result = new ArrayList<AnnotationUseSpecification>(this.declarationSpecifiers.size());
        int s = this.declarationSpecifiers.size();
        int i = 0;
        while (i < s) {
            DeclarationSpecifier ds = (DeclarationSpecifier)this.declarationSpecifiers.get(i);
            if (ds instanceof AnnotationUseSpecification) {
                result.add((AnnotationUseSpecification)ds);
            }
            ++i;
        }
        return result;
    }

    @Override
    public ASTList<DeclarationSpecifier> getDeclarationSpecifiers() {
        return this.declarationSpecifiers;
    }

    @Override
    public void setDeclarationSpecifiers(ASTList<DeclarationSpecifier> m) {
        this.declarationSpecifiers = m;
    }

    public VisibilityModifier getVisibilityModifier() {
        if (this.declarationSpecifiers == null) {
            return null;
        }
        int i = this.declarationSpecifiers.size() - 1;
        while (i >= 0) {
            DeclarationSpecifier m = (DeclarationSpecifier)this.declarationSpecifiers.get(i);
            if (m instanceof VisibilityModifier) {
                return (VisibilityModifier)m;
            }
            --i;
        }
        return null;
    }

    final boolean containsModifier(Class<? extends Modifier> type) {
        int s = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        int i = 0;
        while (i < s) {
            if (type.isInstance(this.declarationSpecifiers.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isAbstract() {
        return this.containsModifier(Abstract.class);
    }

    protected boolean isPrivate() {
        return this.containsModifier(Private.class);
    }

    protected boolean isProtected() {
        return this.containsModifier(Protected.class);
    }

    protected boolean isPublic() {
        return this.containsModifier(Public.class);
    }

    protected boolean isStatic() {
        return this.containsModifier(Static.class);
    }

    protected boolean isTransient() {
        return this.containsModifier(Transient.class);
    }

    protected boolean isVolatile() {
        return this.containsModifier(Volatile.class);
    }

    protected boolean isStrictFp() {
        return this.containsModifier(StrictFp.class);
    }

    protected boolean isFinal() {
        return this.containsModifier(Final.class);
    }

    protected boolean isNative() {
        return this.containsModifier(Native.class);
    }

    protected boolean isSynchronized() {
        return this.containsModifier(Synchronized.class);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.declarationSpecifiers != null) {
            int i = this.declarationSpecifiers.size() - 1;
            while (i >= 0) {
                ((DeclarationSpecifier)this.declarationSpecifiers.get(i)).setParent(this);
                --i;
            }
        }
    }
}

