/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import java.util.ArrayList;
import java.util.List;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class FieldDeclaration
extends VariableDeclaration
implements MemberDeclaration {
    private static final long serialVersionUID = 2577966836277961911L;
    TypeDeclaration parent;
    ASTList<FieldSpecification> fieldSpecs;

    public FieldDeclaration() {
    }

    public FieldDeclaration(TypeReference typeRef, FieldSpecification fs) {
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)fs);
        this.setFieldSpecifications(list);
        this.makeParentRoleValid();
    }

    public FieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, FieldSpecification fs) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        ASTArrayList<boolean> list = new ASTArrayList<boolean>(true);
        list.add((boolean)fs);
        this.setFieldSpecifications(list);
        this.makeParentRoleValid();
    }

    public FieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<FieldSpecification> vars) {
        this.setDeclarationSpecifiers(mods);
        this.setTypeReference(typeRef);
        this.setFieldSpecifications(vars);
        this.makeParentRoleValid();
    }

    protected FieldDeclaration(FieldDeclaration proto) {
        super(proto);
        if (proto.fieldSpecs != null) {
            this.fieldSpecs = proto.fieldSpecs.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public FieldDeclaration deepClone() {
        return new FieldDeclaration(this);
    }

    @Override
    public TypeDeclaration getASTParent() {
        return this.parent;
    }

    @Override
    public TypeDeclaration getMemberParent() {
        return this.parent;
    }

    @Override
    public void setMemberParent(TypeDeclaration p) {
        this.parent = p;
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.fieldSpecs != null) {
            int i = this.fieldSpecs.size() - 1;
            while (i >= 0) {
                ((FieldSpecification)this.fieldSpecs.get(i)).setParent(this);
                --i;
            }
        }
    }

    public ASTList<FieldSpecification> getFieldSpecifications() {
        return this.fieldSpecs;
    }

    public void setFieldSpecifications(ASTList<FieldSpecification> l) {
        this.fieldSpecs = l;
    }

    public List<FieldSpecification> getVariables() {
        return new ArrayList<FieldSpecification>(this.fieldSpecs);
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.typeReference != null) {
            ++result;
        }
        if (this.fieldSpecs != null) {
            result += this.fieldSpecs.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            int len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.typeReference != null) {
            if (index == 0) {
                return this.typeReference;
            }
            --index;
        }
        if (this.fieldSpecs != null) {
            return (ProgramElement)this.fieldSpecs.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4;
        }
        if (this.typeReference == child) {
            return 1;
        }
        if (this.fieldSpecs != null && (index = this.fieldSpecs.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        int i = 0;
        while (i < count) {
            if (this.declarationSpecifiers.get(i) == p) {
                if (q == null) {
                    this.declarationSpecifiers.remove(i);
                } else {
                    DeclarationSpecifier r = (DeclarationSpecifier)q;
                    this.declarationSpecifiers.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        if (this.typeReference == p) {
            TypeReference r;
            if (q instanceof UncollatedReferenceQualifier) {
                q = ((UncollatedReferenceQualifier)q).toTypeReference();
            }
            this.typeReference = r = (TypeReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        count = this.fieldSpecs == null ? 0 : this.fieldSpecs.size();
        i = 0;
        while (i < count) {
            if (this.fieldSpecs.get(i) == p) {
                if (q == null) {
                    this.fieldSpecs.remove(i);
                } else {
                    FieldSpecification r = (FieldSpecification)q;
                    this.fieldSpecs.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isFinal() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isFinal();
    }

    @Override
    public boolean isPrivate() {
        return super.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return super.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.getASTParent() instanceof InterfaceDeclaration || super.isStatic();
    }

    @Override
    public boolean isTransient() {
        return !(this.getASTParent() instanceof InterfaceDeclaration) && super.isTransient();
    }

    @Override
    public boolean isStrictFp() {
        return super.isStrictFp();
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitFieldDeclaration(this);
    }
}

