/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.java.SourceVisitor;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class EnumConstantDeclaration
extends FieldDeclaration {
    private static final long serialVersionUID = 6254325025698455465L;

    public EnumConstantDeclaration() {
    }

    public EnumConstantDeclaration(EnumConstantSpecification spec, ASTList<DeclarationSpecifier> annotations) {
        this.setEnumConstantSpecification(spec);
        this.setDeclarationSpecifiers(annotations);
        this.makeParentRoleValid();
    }

    protected EnumConstantDeclaration(EnumConstantDeclaration proto) {
        super(proto);
        this.makeParentRoleValid();
    }

    public EnumDeclaration getParent() {
        return (EnumDeclaration)this.parent;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitEnumConstantDeclaration(this);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public TypeDeclaration getASTParent() {
        return this.parent;
    }

    @Override
    public EnumConstantDeclaration deepClone() {
        return new EnumConstantDeclaration(this);
    }

    public EnumConstantSpecification getEnumConstantSpecification() {
        if (this.fieldSpecs == null || this.fieldSpecs.size() == 0) {
            return null;
        }
        return (EnumConstantSpecification)this.fieldSpecs.get(0);
    }

    public void setEnumConstantSpecification(EnumConstantSpecification spec) {
        if (this.fieldSpecs == null) {
            this.fieldSpecs = new ASTArrayList<boolean>(true);
        }
        this.fieldSpecs.add(spec);
    }

    @Override
    public TypeDeclaration getMemberParent() {
        return this.parent;
    }

    @Override
    public void setMemberParent(TypeDeclaration t) {
        if (!(t instanceof EnumDeclaration)) {
            throw new IllegalArgumentException("Only an EnumDeclarations can be parent of an EnumConstantDeclaration");
        }
        super.setMemberParent(t);
    }

    @Override
    public void validate() throws ModelException {
        if (this.typeReference != null) {
            throw new ModelException("TypeReference set in EnumConstantDeclaration in " + this.parent.getFullName());
        }
        if (this.declarationSpecifiers != null) {
            int i = 0;
            while (i < this.declarationSpecifiers.size()) {
                DeclarationSpecifier ds = (DeclarationSpecifier)this.declarationSpecifiers.get(i);
                if (!(ds instanceof AnnotationUse)) {
                    throw new ModelException("EnumConstantDeclaration may not contain modifiers in " + this.parent.getFullName());
                }
                ++i;
            }
        }
        if (!(this.parent instanceof EnumDeclaration)) {
            throw new ModelException("Illegal parent type (" + this.parent.getClass().getCanonicalName() + " - " + this.parent.getFullName() + ") for EnumConstantDeclaration");
        }
        if (this.fieldSpecs.size() != 1) {
            throw new ModelException("Only one EnumConstantSpecification per EnumConstantDeclaration allowed in " + this.parent.getFullName());
        }
        if (!(this.fieldSpecs.get(0) instanceof EnumConstantSpecification)) {
            throw new ModelException("child of EnumConstantDeclaration is not an EnumConstantSpecification in " + this.parent.getFullName());
        }
    }
}

