/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.JavaDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.modifier.Static;
import recoder.list.generic.ASTArrayList;

public class ClassInitializer
extends JavaDeclaration
implements MemberDeclaration,
StatementContainer {
    private static final long serialVersionUID = 7172264701196251395L;
    private TypeDeclaration parent;
    private StatementBlock body;

    public ClassInitializer() {
    }

    public ClassInitializer(StatementBlock body) {
        this.setBody(body);
        this.makeParentRoleValid();
    }

    public ClassInitializer(Static modifier, StatementBlock body) {
        if (modifier != null) {
            ASTArrayList<DeclarationSpecifier> mods = new ASTArrayList<DeclarationSpecifier>(1);
            mods.add(modifier);
            this.setDeclarationSpecifiers(mods);
        }
        this.setBody(body);
        this.makeParentRoleValid();
    }

    protected ClassInitializer(ClassInitializer proto) {
        super(proto);
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public ClassInitializer deepClone() {
        return new ClassInitializer(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.body != null) {
            this.body.setStatementContainer(this);
        }
    }

    @Override
    public SourceElement getFirstElement() {
        if (this.declarationSpecifiers != null && !this.declarationSpecifiers.isEmpty()) {
            return (SourceElement)this.declarationSpecifiers.get(0);
        }
        return this.body;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? 1 : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.body != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.declarationSpecifiers != null) {
            int len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.body != null && index == 0) {
            return this.body;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4;
        }
        if (this.body == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        int i = 0;
        while (i < count) {
            if (this.declarationSpecifiers.get(i) == p) {
                if (q == null) {
                    this.declarationSpecifiers.remove(i);
                } else {
                    Static r = (Static)q;
                    this.declarationSpecifiers.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        if (this.body == p) {
            StatementBlock r;
            this.body = r = (StatementBlock)q;
            if (r != null) {
                r.setStatementContainer(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public TypeDeclaration getMemberParent() {
        return this.parent;
    }

    @Override
    public void setMemberParent(TypeDeclaration t) {
        this.parent = t;
    }

    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.declarationSpecifiers != null && !this.declarationSpecifiers.isEmpty();
    }

    @Override
    public SourceElement getLastElement() {
        return this.body;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitClassInitializer(this);
    }
}

