/*
 * Decompiled with CFR 0.152.
 */
package recoder.java.declaration;

import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.Extends;
import recoder.java.declaration.Implements;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.list.generic.ASTList;

public class ClassDeclaration
extends TypeDeclaration
implements Statement {
    private static final long serialVersionUID = -1520369925548201696L;
    private Extends extending;
    private ASTList<TypeParameterDeclaration> typeParameters;
    private Implements implementing;

    public ClassDeclaration() {
    }

    public ClassDeclaration(ASTList<DeclarationSpecifier> declSpecs, Identifier name, Extends extended, Implements implemented, ASTList<MemberDeclaration> members, ASTList<TypeParameterDeclaration> typeParameters) {
        super(declSpecs, name);
        this.setExtendedTypes(extended);
        this.setImplementedTypes(implemented);
        this.setMembers(members);
        this.setTypeParameters(typeParameters);
        this.makeParentRoleValid();
    }

    public ClassDeclaration(ASTList<DeclarationSpecifier> declSpecs, Identifier name, Extends extended, Implements implemented, ASTList<MemberDeclaration> members) {
        this(declSpecs, name, extended, implemented, members, null);
    }

    public ClassDeclaration(ASTList<MemberDeclaration> members) {
        this.setMembers(members);
        this.makeParentRoleValid();
    }

    protected ClassDeclaration(ClassDeclaration proto) {
        super(proto);
        if (proto.extending != null) {
            this.extending = proto.extending.deepClone();
        }
        if (proto.implementing != null) {
            this.implementing = proto.implementing.deepClone();
        }
        if (proto.typeParameters != null) {
            this.typeParameters = proto.typeParameters.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public ClassDeclaration deepClone() {
        return new ClassDeclaration(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.extending != null) {
            this.extending.setParent(this);
        }
        if (this.implementing != null) {
            this.implementing.setParent(this);
        }
        if (this.typeParameters != null) {
            for (TypeParameterDeclaration tp : this.typeParameters) {
                tp.setParent(this);
            }
        }
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.declarationSpecifiers != null) {
            result += this.declarationSpecifiers.size();
        }
        if (this.name != null) {
            ++result;
        }
        if (this.extending != null) {
            ++result;
        }
        if (this.implementing != null) {
            ++result;
        }
        if (this.members != null) {
            result += this.members.size();
        }
        if (this.typeParameters != null) {
            result += this.typeParameters.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.declarationSpecifiers != null) {
            len = this.declarationSpecifiers.size();
            if (len > index) {
                return (ProgramElement)this.declarationSpecifiers.get(index);
            }
            index -= len;
        }
        if (this.name != null) {
            if (index == 0) {
                return this.name;
            }
            --index;
        }
        if (this.typeParameters != null) {
            len = this.typeParameters.size();
            if (len > index) {
                return (ProgramElement)this.typeParameters.get(index);
            }
            index -= len;
        }
        if (this.extending != null) {
            if (index == 0) {
                return this.extending;
            }
            --index;
        }
        if (this.implementing != null) {
            if (index == 0) {
                return this.implementing;
            }
            --index;
        }
        if (this.members != null) {
            if (index < this.members.size()) {
                return (ProgramElement)this.members.get(index);
            }
            index -= this.members.size();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.declarationSpecifiers != null && (index = this.declarationSpecifiers.indexOf(child)) >= 0) {
            return index << 4;
        }
        if (this.name == child) {
            return 1;
        }
        if (this.extending == child) {
            return 2;
        }
        if (this.implementing == child) {
            return 3;
        }
        if (this.members != null && (index = this.members.indexOf(child)) >= 0) {
            return index << 4 | 4;
        }
        if (this.typeParameters != null && (index = this.typeParameters.size()) >= 0) {
            return index << 4 | 5;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        int idx;
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.declarationSpecifiers == null ? 0 : this.declarationSpecifiers.size();
        int i = 0;
        while (i < count) {
            if (this.declarationSpecifiers.get(i) == p) {
                if (q == null) {
                    this.declarationSpecifiers.remove(i);
                } else {
                    DeclarationSpecifier r = (DeclarationSpecifier)q;
                    this.declarationSpecifiers.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        if (this.name == p) {
            Identifier r;
            this.name = r = (Identifier)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.extending == p) {
            Extends r;
            this.extending = r = (Extends)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        if (this.implementing == p) {
            Implements r;
            this.implementing = r = (Implements)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        count = this.members == null ? 0 : this.members.size();
        i = 0;
        while (i < count) {
            if (this.members.get(i) == p) {
                if (q == null) {
                    this.members.remove(i);
                } else {
                    MemberDeclaration r = (MemberDeclaration)q;
                    this.members.set(i, r);
                    r.setMemberParent(this);
                }
                return true;
            }
            ++i;
        }
        if (this.typeParameters != null && (idx = this.typeParameters.indexOf(p)) != -1) {
            if (q == null) {
                this.typeParameters.remove(idx);
            } else {
                TypeParameterDeclaration r = (TypeParameterDeclaration)q;
                this.typeParameters.set(idx, r);
                r.setParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public StatementContainer getStatementContainer() {
        return this.parent instanceof StatementContainer ? (StatementContainer)((Object)this.parent) : null;
    }

    @Override
    public void setStatementContainer(StatementContainer p) {
        this.parent = (StatementBlock)p;
    }

    public Extends getExtendedTypes() {
        return this.extending;
    }

    public void setExtendedTypes(Extends spec) {
        this.extending = spec;
    }

    public Implements getImplementedTypes() {
        return this.implementing;
    }

    public void setImplementedTypes(Implements spec) {
        this.implementing = spec;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return true;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitClassDeclaration(this);
    }

    public void setTypeParameters(ASTList<TypeParameterDeclaration> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public ASTList<TypeParameterDeclaration> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean isInner() {
        if (this.isStatic()) {
            return false;
        }
        if (!(this.getContainingClassType() instanceof ClassDeclaration)) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        return this.getStatementContainer() == null;
    }
}

