/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.abstraction.ClassType;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementContainer;
import recoder.java.TypeScope;
import recoder.java.VariableScope;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.declaration.VariableSpecification;
import recoder.java.statement.JavaStatement;
import recoder.list.generic.ASTList;
import recoder.util.Debug;

public class StatementBlock
extends JavaStatement
implements StatementContainer,
TypeDeclarationContainer,
VariableScope,
TypeScope {
    private static final long serialVersionUID = -3288497346043639754L;
    private ASTList<Statement> body;
    private static final Map UNDEFINED_SCOPE = new HashMap(0);
    private Map<String, TypeDeclaration> name2type = UNDEFINED_SCOPE;
    private Map<String, VariableSpecification> name2var = UNDEFINED_SCOPE;

    public StatementBlock() {
    }

    public StatementBlock(ASTList<Statement> block) {
        this.setBody(block);
        this.makeParentRoleValid();
    }

    protected StatementBlock(StatementBlock proto) {
        super(proto);
        if (proto.body != null) {
            this.body = proto.body.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public StatementBlock deepClone() {
        return new StatementBlock(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.body != null) {
            int i = this.body.size() - 1;
            while (i >= 0) {
                ((Statement)this.body.get(i)).setStatementContainer(this);
                --i;
            }
        }
    }

    public ASTList<Statement> getBody() {
        return this.body;
    }

    public void setBody(ASTList<Statement> list) {
        this.body = list;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        int count = this.body == null ? 0 : this.body.size();
        int i = 0;
        while (i < count) {
            if (this.body.get(i) == p) {
                if (q == null) {
                    this.body.remove(i);
                } else {
                    Statement r = (Statement)q;
                    this.body.set(i, r);
                    r.setStatementContainer(this);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getChildCount() {
        return this.body != null ? this.body.size() : 0;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        int len;
        if (this.body != null && (len = this.body.size()) > index) {
            return (ProgramElement)this.body.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (this.body != null && (index = this.body.indexOf(child)) >= 0) {
            return index << 4;
        }
        return -1;
    }

    @Override
    public int getStatementCount() {
        return this.body != null ? this.body.size() : 0;
    }

    @Override
    public Statement getStatementAt(int index) {
        if (this.body != null) {
            return (Statement)this.body.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getTypeDeclarationCount() {
        int count = 0;
        if (this.body != null) {
            int i = this.body.size() - 1;
            while (i >= 0) {
                if (this.body.get(i) instanceof TypeDeclaration) {
                    ++count;
                }
                --i;
            }
        }
        return count;
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.body != null) {
            int s = this.body.size();
            int i = 0;
            while (i < s && index >= 0) {
                Statement st = (Statement)this.body.get(i);
                if (st instanceof TypeDeclaration) {
                    if (index == 0) {
                        return (TypeDeclaration)((Object)st);
                    }
                    --index;
                }
                ++i;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public boolean isDefinedScope() {
        return this.name2type != UNDEFINED_SCOPE;
    }

    @Override
    public void setDefinedScope(boolean defined) {
        if (!defined) {
            this.name2type = UNDEFINED_SCOPE;
            this.name2var = UNDEFINED_SCOPE;
        } else {
            this.name2type = null;
            this.name2var = null;
        }
    }

    public List<TypeDeclaration> getTypesInScope() {
        if (this.name2type == null || this.name2type.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeDeclaration> res = new ArrayList<TypeDeclaration>(this.name2type.size());
        for (TypeDeclaration td : this.name2type.values()) {
            res.add(td);
        }
        return res;
    }

    @Override
    public ClassType getTypeInScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2type == null) {
            return null;
        }
        return this.name2type.get(name);
    }

    @Override
    public void addTypeToScope(ClassType type, String name) {
        Debug.assertNonnull((Object)type, name);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            this.name2type = new HashMap<String, TypeDeclaration>();
        }
        this.name2type.put(name, (TypeDeclaration)type);
    }

    @Override
    public void removeTypeFromScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            return;
        }
        this.name2type.remove(name);
    }

    public List<VariableSpecification> getVariablesInScope() {
        if (this.name2var == null || this.name2var.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VariableSpecification> res = new ArrayList<VariableSpecification>(this.name2var.size());
        for (VariableSpecification vs : this.name2var.values()) {
            res.add(vs);
        }
        return res;
    }

    @Override
    public VariableSpecification getVariableInScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2var == null) {
            return null;
        }
        return this.name2var.get(name);
    }

    @Override
    public void addVariableToScope(VariableSpecification var) {
        Debug.assertNonnull(var);
        if (this.name2var == null || this.name2var == UNDEFINED_SCOPE) {
            this.name2var = new HashMap<String, VariableSpecification>();
        }
        this.name2var.put(var.getName(), var);
    }

    @Override
    public void removeVariableFromScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2var == null || this.name2var == UNDEFINED_SCOPE) {
            return;
        }
        this.name2var.remove(name);
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitStatementBlock(this);
    }
}

