/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import recoder.io.PropertyNames;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.PackageSpecification;
import recoder.java.PrettyPrintingException;
import recoder.java.ProgramElement;
import recoder.java.SingleLineComment;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationElementValuePair;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.Volatile;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Assignment;
import recoder.java.expression.ElementValueArrayInitializer;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryAndAssignment;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryOrAssignment;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.BinaryXOrAssignment;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.DivideAssignment;
import recoder.java.expression.operator.Equals;
import recoder.java.expression.operator.GreaterOrEquals;
import recoder.java.expression.operator.GreaterThan;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LessOrEquals;
import recoder.java.expression.operator.LessThan;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.MinusAssignment;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.ModuloAssignment;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.NotEquals;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.PlusAssignment;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftLeftAssignment;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.ShiftRightAssignment;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TimesAssignment;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.expression.operator.UnsignedShiftRightAssignment;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Assert;
import recoder.java.statement.Break;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Continue;
import recoder.java.statement.Default;
import recoder.java.statement.Do;
import recoder.java.statement.Else;
import recoder.java.statement.EmptyStatement;
import recoder.java.statement.EnhancedFor;
import recoder.java.statement.Finally;
import recoder.java.statement.For;
import recoder.java.statement.If;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Return;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Then;
import recoder.java.statement.Throw;
import recoder.java.statement.Try;
import recoder.java.statement.While;
import recoder.list.generic.ASTList;
import recoder.util.StringUtils;

public class PrettyPrinter
extends SourceVisitor
implements PropertyNames {
    private Properties properties;
    private Writer out = null;
    private int line = 1;
    private int column = 1;
    private int level = 0;
    private List<SingleLineComment> singleLineCommentWorkList = new ArrayList<SingleLineComment>();
    private boolean isPrintingSingleLineComments = false;
    private boolean hasJustPrintedComment = false;
    private static char[] BLANKS = new char[128];
    private static char[] FEEDS = new char[8];
    private SourceElement.Position overwritePosition = new SourceElement.Position(0, 0);
    private int indentation;
    private boolean overwriteIndentation;
    private boolean overwriteParsePositions;

    static {
        int i = 0;
        while (i < FEEDS.length) {
            PrettyPrinter.FEEDS[i] = 10;
            ++i;
        }
        i = 0;
        while (i < BLANKS.length) {
            PrettyPrinter.BLANKS[i] = 32;
            ++i;
        }
    }

    protected PrettyPrinter(Writer out, Properties props) {
        this.setWriter(out);
        this.properties = props;
        this.cacheFrequentlyUsed();
    }

    public void setWriter(Writer out) {
        if (out == null) {
            throw new IllegalArgumentException("Impossible to write to null");
        }
        this.out = out;
        this.column = 1;
        this.line = 1;
        this.singleLineCommentWorkList.clear();
        this.isPrintingSingleLineComments = false;
    }

    public Writer getWriter() {
        return this.out;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndentationLevel() {
        return this.level;
    }

    public void setIndentationLevel(int level) {
        this.level = level;
    }

    public int getTotalIndentation() {
        return this.indentation * this.level;
    }

    public void changeLevel(int delta) {
        this.level += delta;
    }

    protected static String encodeUnicodeChars(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 4);
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c >= '\u0100' || c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                buf.append("\\u");
                if (c < '\u1000') {
                    buf.append("0");
                }
                if (c < '\u0100') {
                    buf.append("0");
                }
                if (c < '\u0010') {
                    buf.append("0");
                }
                buf.append(Integer.toString(c, 16));
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    protected void printIndentation(int lf, int blanks) {
        int n;
        if (lf > 0) {
            do {
                n = Math.min(lf, FEEDS.length);
                this.print(FEEDS, 0, n);
            } while ((lf -= n) > 0);
        }
        while (blanks > 0) {
            n = Math.min(blanks, BLANKS.length);
            this.print(BLANKS, 0, n);
            blanks -= n;
        }
    }

    protected SourceElement.Position setElementIndentation(int minlf, int minblanks, SourceElement element) {
        SourceElement.Position indent = element.getRelativePosition();
        this.hasJustPrintedComment = false;
        if (indent == SourceElement.Position.UNDEFINED) {
            if (minlf > 0) {
                minblanks += this.getTotalIndentation();
            }
            indent = new SourceElement.Position(minlf, minblanks);
        } else if (this.overwriteIndentation) {
            if (minlf > 0) {
                minblanks += this.getTotalIndentation();
            }
            indent.setPosition(minlf, minblanks);
        } else {
            if (minlf > 0 && indent.getColumn() == 0 && indent.getLine() == 0) {
                indent.setLine(1);
            }
            if (indent.getLine() > 0 && !(element instanceof Comment)) {
                minblanks += this.getTotalIndentation();
            }
            if (minblanks > indent.getColumn()) {
                indent.setColumn(minblanks);
            }
        }
        element.setRelativePosition(indent);
        return indent;
    }

    protected void printElementIndentation(int minlf, int minblanks, SourceElement element) {
        SourceElement.Position indent = this.setElementIndentation(minlf, minblanks, element);
        this.printIndentation(indent.getLine(), indent.getColumn());
        if (this.overwriteParsePositions) {
            indent.setPosition(this.line, this.column);
            element.setStartPosition(indent);
        }
    }

    protected void printElementIndentation(int minblanks, SourceElement element) {
        this.printElementIndentation(0, minblanks, element);
    }

    protected void printElementIndentation(SourceElement element) {
        this.printElementIndentation(0, 0, element);
    }

    protected void printElement(int lf, int levelChange, int blanks, SourceElement elem) {
        this.level += levelChange;
        this.setElementIndentation(lf, blanks, this.findFirstElementInclComment(elem));
        elem.accept(this);
    }

    protected void printElement(int lf, int blanks, SourceElement elem) {
        this.setElementIndentation(lf, blanks, this.findFirstElementInclComment(elem));
        elem.accept(this);
    }

    protected void printElement(int blanks, SourceElement elem) {
        this.setElementIndentation(0, blanks, this.findFirstElementInclComment(elem));
        elem.accept(this);
    }

    protected void printElement(SourceElement elem) {
        this.setElementIndentation(0, 0, this.findFirstElementInclComment(elem));
        elem.accept(this);
    }

    protected void printProgramElementList(int firstLF, int levelChange, int firstBlanks, String separationSymbol, int separationLF, int separationBlanks, List<? extends ProgramElement> list) {
        int s = list.size();
        if (s == 0) {
            this.level += levelChange;
            return;
        }
        this.printElement(firstLF, levelChange, firstBlanks, list.get(0));
        int i = 1;
        while (i < s) {
            this.print(separationSymbol);
            this.printElement(separationLF, separationBlanks, list.get(i));
            ++i;
        }
    }

    protected void printKeywordList(List<? extends ProgramElement> list) {
        this.printProgramElementList(0, 0, 0, "", 0, 1, list);
    }

    protected void printCommaList(int firstLF, int levelChange, int firstBlanks, List<? extends ProgramElement> list) {
        this.printProgramElementList(firstLF, levelChange, firstBlanks, ",", 0, 1, list);
    }

    protected void printCommaList(int separationBlanks, List<? extends ProgramElement> list) {
        this.printProgramElementList(0, 0, 0, ",", 0, separationBlanks, list);
    }

    protected void printCommaList(List<? extends ProgramElement> list) {
        this.printProgramElementList(0, 0, 0, ",", 0, 1, list);
    }

    protected void printLineList(int firstLF, int levelChange, List<? extends ProgramElement> list) {
        this.printProgramElementList(firstLF, levelChange, 0, "", 1, 0, list);
    }

    protected void printBlockList(int firstLF, int levelChange, List<? extends ProgramElement> list) {
        this.printProgramElementList(firstLF, levelChange, 0, "", 2, 0, list);
    }

    private void dumpComments() {
        int size = this.singleLineCommentWorkList.size();
        if (size > 0) {
            this.isPrintingSingleLineComments = true;
            int i = 0;
            while (i < size) {
                this.singleLineCommentWorkList.get(i).accept(this);
                ++i;
            }
            this.singleLineCommentWorkList.clear();
            this.isPrintingSingleLineComments = false;
        }
    }

    protected void print(int c) {
        if (c == 10) {
            if (!this.isPrintingSingleLineComments) {
                this.dumpComments();
            }
            this.column = 1;
            ++this.line;
        } else {
            ++this.column;
        }
        try {
            this.out.write(c);
        }
        catch (IOException ioe) {
            throw new PrettyPrintingException(ioe);
        }
    }

    protected void print(char[] cbuf, int off, int len) {
        boolean col = false;
        int i = off + len - 1;
        while (i >= off) {
            if (cbuf[i] == '\n') {
                if (!this.isPrintingSingleLineComments) {
                    this.dumpComments();
                }
                ++this.line;
                if (!col) {
                    this.column = off + len - 1 - i + 1;
                    col = true;
                }
            }
            --i;
        }
        if (!col) {
            this.column += len;
        }
        try {
            this.out.write(cbuf, off, len);
        }
        catch (IOException ioe) {
            throw new PrettyPrintingException(ioe);
        }
    }

    protected void print(String str) {
        int i = str.lastIndexOf(10);
        if (i >= 0) {
            this.column = str.length() - i + 1 + 1;
            do {
                this.dumpComments();
                ++this.line;
            } while ((i = str.lastIndexOf(10, i - 1)) >= 0);
        } else {
            this.column += str.length();
        }
        try {
            this.out.write(str);
        }
        catch (IOException ioe) {
            throw new PrettyPrintingException(ioe);
        }
    }

    public boolean getBooleanProperty(String key) {
        return StringUtils.parseBooleanProperty(this.properties.getProperty(key));
    }

    private void cacheFrequentlyUsed() {
        this.indentation = Integer.parseInt(this.properties.getProperty("indentationAmount"));
        if (this.indentation < 0) {
            throw new IllegalArgumentException("Negative indentation");
        }
        this.overwriteIndentation = this.getBooleanProperty("overwriteIndentation");
        this.overwriteParsePositions = this.getBooleanProperty("overwriteParsePositions");
    }

    protected int getIndentation() {
        return this.indentation;
    }

    protected boolean isOverwritingIndentation() {
        return this.overwriteIndentation;
    }

    protected boolean isOverwritingParsePositions() {
        return this.overwriteParsePositions;
    }

    protected void printHeader(int lf, int blanks, ProgramElement elem) {
        this.printHeader(lf, 0, blanks, elem);
    }

    protected void printHeader(int blanks, ProgramElement elem) {
        this.printHeader(0, 0, blanks, elem);
    }

    protected void printHeader(ProgramElement elem) {
        this.printHeader(0, 0, 0, elem);
    }

    private SourceElement findFirstElementInclComment(SourceElement x) {
        if (!(x instanceof ProgramElement)) {
            return x.getFirstElement();
        }
        ASTList<Comment> cl = ((ProgramElement)x).getComments();
        int s = cl == null ? 0 : cl.size();
        int i = 0;
        while (i < s) {
            Comment c = (Comment)cl.get(i);
            if (c.isPrefixed()) {
                return c;
            }
            ++i;
        }
        return x.getFirstElement();
    }

    protected void printHeader(int lf, int levelChange, int blanks, ProgramElement x) {
        this.level += levelChange;
        if (lf > 0) {
            blanks += this.getTotalIndentation();
        }
        SourceElement first = this.findFirstElementInclComment(x);
        this.setElementIndentation(lf, blanks, first);
        this.hasJustPrintedComment = false;
        int s = x.getComments() != null ? x.getComments().size() : 0;
        int i = 0;
        while (i < s) {
            Comment c = (Comment)x.getComments().get(i);
            if (c.isPrefixed()) {
                c.accept(this);
                this.hasJustPrintedComment = true;
            }
            ++i;
        }
    }

    protected void printFooter(ProgramElement x) {
        if (this.overwriteParsePositions) {
            this.overwritePosition.setPosition(this.line, this.column);
            x.setEndPosition(this.overwritePosition);
        }
        int s = x.getComments() != null ? x.getComments().size() : 0;
        int i = 0;
        while (i < s) {
            Comment c = (Comment)x.getComments().get(i);
            if (!c.isPrefixed() && !c.isContainerComment()) {
                if (c instanceof SingleLineComment) {
                    this.singleLineCommentWorkList.add((SingleLineComment)c);
                } else {
                    c.accept(this);
                }
            }
            ++i;
        }
    }

    protected boolean printContainerComments(ProgramElement x) {
        boolean commentPrinted = false;
        int s = x.getComments() != null ? x.getComments().size() : 0;
        int i = 0;
        while (i < s) {
            Comment c = (Comment)x.getComments().get(i);
            if (c.isContainerComment()) {
                c.accept(this);
                this.printIndentation(1, this.getIndentation());
                commentPrinted = true;
            }
            ++i;
        }
        return commentPrinted;
    }

    protected void printOperator(Operator x, String symbol) {
        ASTList<Expression> children = x.getArguments();
        if (children != null) {
            boolean addParentheses = x.isToBeParenthesized();
            if (addParentheses) {
                this.print(40);
            }
            block0 : switch (x.getArity()) {
                case 2: {
                    this.printElement(0, (SourceElement)children.get(0));
                    if (this.getBooleanProperty("glueInfixOperators")) {
                        this.printElementIndentation(0, x);
                        this.print(symbol);
                        this.printElement((SourceElement)children.get(1));
                        break;
                    }
                    this.printElementIndentation(1, x);
                    this.print(symbol);
                    this.printElement(1, (SourceElement)children.get(1));
                    break;
                }
                case 1: {
                    switch (x.getNotation()) {
                        case 0: {
                            this.printElementIndentation(x);
                            this.print(symbol);
                            if (this.getBooleanProperty("glueUnaryOperators")) {
                                this.printElement(0, (SourceElement)children.get(0));
                                break block0;
                            }
                            this.printElement(1, (SourceElement)children.get(0));
                            break block0;
                        }
                        case 2: {
                            this.printElement(0, (SourceElement)children.get(0));
                            if (this.getBooleanProperty("glueUnaryOperators")) {
                                this.printElementIndentation(x);
                                this.print(symbol);
                                break block0;
                            }
                            this.printElementIndentation(1, x);
                            this.print(symbol);
                            break block0;
                        }
                    }
                }
            }
            if (addParentheses) {
                this.print(41);
            }
            if (x instanceof Assignment && ((Assignment)x).getStatementContainer() != null) {
                this.print(59);
            }
        }
    }

    @Override
    public void visitIdentifier(Identifier x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getText());
        this.printFooter(x);
    }

    @Override
    public void visitIntLiteral(IntLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getValue());
        this.printFooter(x);
    }

    @Override
    public void visitBooleanLiteral(BooleanLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getValue() ? "true" : "false");
        this.printFooter(x);
    }

    @Override
    public void visitStringLiteral(StringLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(PrettyPrinter.encodeUnicodeChars(x.getValue()));
        this.printFooter(x);
    }

    @Override
    public void visitNullLiteral(NullLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("null");
        this.printFooter(x);
    }

    @Override
    public void visitCharLiteral(CharLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(PrettyPrinter.encodeUnicodeChars(x.getValue()));
        this.printFooter(x);
    }

    @Override
    public void visitDoubleLiteral(DoubleLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getValue());
        this.printFooter(x);
    }

    @Override
    public void visitLongLiteral(LongLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getValue());
        this.printFooter(x);
    }

    @Override
    public void visitFloatLiteral(FloatLiteral x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(x.getValue());
        this.printFooter(x);
    }

    @Override
    public void visitPackageSpecification(PackageSpecification x) {
        this.printHeader(x);
        int m = 0;
        if (x.getAnnotations() != null && x.getAnnotations().size() > 0) {
            m = x.getAnnotations().size();
            this.printKeywordList(x.getAnnotations());
            m = 1;
        }
        this.printElementIndentation(m, x);
        this.print("package");
        this.printElement(1, x.getPackageReference());
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitTypeReference(TypeReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(46);
        }
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        if (x.getTypeArguments() != null && x.getTypeArguments().size() > 0) {
            this.print(60);
            this.printCommaList(x.getTypeArguments());
            this.print(62);
        }
        int i = 0;
        while (i < x.getDimensions()) {
            this.print("[]");
            ++i;
        }
        this.printFooter(x);
    }

    @Override
    public void visitPackageReference(PackageReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(46);
        }
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        this.printFooter(x);
    }

    @Override
    public void visitThrows(Throws x) {
        this.printHeader(x);
        if (x.getExceptions() != null) {
            this.printElementIndentation(x);
            this.print("throws");
            this.printCommaList(0, 0, 1, x.getExceptions());
        }
        this.printFooter(x);
    }

    @Override
    public void visitArrayInitializer(ArrayInitializer x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(123);
        this.printContainerComments(x);
        if (x.getArguments() != null) {
            this.printCommaList(0, 0, 1, x.getArguments());
        }
        if (x.getArguments() != null && x.getArguments().size() > 0 && x.getRelativePosition().getLine() > 0) {
            this.printIndentation(1, this.getTotalIndentation());
            this.print(125);
        } else {
            this.print(" }");
        }
        this.printFooter(x);
    }

    @Override
    public void visitElementValueArrayInitializer(ElementValueArrayInitializer x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(123);
        if (x.getElementValues() != null) {
            this.printCommaList(0, 0, 1, x.getElementValues());
        }
        if (x.getElementValues() != null && x.getElementValues().size() > 0 && x.getRelativePosition().getLine() > 0) {
            this.printIndentation(1, this.getTotalIndentation());
            this.print(125);
        } else {
            this.print(" }");
        }
        this.printFooter(x);
    }

    @Override
    public void visitCompilationUnit(CompilationUnit x) {
        boolean hasImports;
        boolean hasPackageSpec;
        this.column = 1;
        this.line = 1;
        this.printHeader(x);
        this.setIndentationLevel(0);
        boolean bl = hasPackageSpec = x.getPackageSpecification() != null;
        if (hasPackageSpec) {
            this.printElement(x.getPackageSpecification());
        }
        boolean bl2 = hasImports = x.getImports() != null && x.getImports().size() > 0;
        if (hasImports) {
            this.printLineList(x.getPackageSpecification() != null ? 2 : 1, 0, x.getImports());
        }
        if (x.getDeclarations() != null) {
            this.printBlockList(hasImports || hasPackageSpec ? 2 : 0, 0, x.getDeclarations());
        }
        this.printFooter(x);
        this.printIndentation(1, 0);
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration x) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
        }
        if (m > 0) {
            this.printKeywordList(x.getDeclarationSpecifiers());
            m = 1;
        }
        if (x.getIdentifier() != null) {
            this.printElementIndentation(m, x);
            this.print("class");
            this.printElement(1, x.getIdentifier());
        }
        if (x.getTypeParameters() != null && x.getTypeParameters().size() > 0) {
            this.print("<");
            this.printCommaList(x.getTypeParameters());
            this.print("> ");
        }
        if (x.getExtendedTypes() != null) {
            this.printElement(1, x.getExtendedTypes());
        }
        if (x.getImplementedTypes() != null) {
            this.printElement(1, x.getImplementedTypes());
        }
        if (x.getIdentifier() != null) {
            this.print(32);
        }
        this.print(123);
        this.printContainerComments(x);
        if (x.getMembers() != null && !x.getMembers().isEmpty()) {
            this.printBlockList(2, 1, x.getMembers());
            this.changeLevel(-1);
        }
        this.printIndentation(1, this.getTotalIndentation());
        this.print(125);
        this.printFooter(x);
    }

    @Override
    public void visitInterfaceDeclaration(InterfaceDeclaration x) {
        this.visitInterfaceDeclaration(x, false);
    }

    private void visitInterfaceDeclaration(InterfaceDeclaration x, boolean annotation) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
        }
        if (m > 0) {
            this.printKeywordList(x.getDeclarationSpecifiers());
            m = 1;
        }
        if (x.getIdentifier() != null) {
            this.printElementIndentation(m, x);
            if (annotation) {
                this.print("@");
            }
            this.print("interface");
            this.printElement(1, x.getIdentifier());
        }
        if (x.getTypeParameters() != null && x.getTypeParameters().size() > 0) {
            this.print("<");
            this.printCommaList(x.getTypeParameters());
            this.print("> ");
        }
        if (x.getExtendedTypes() != null) {
            this.printElement(1, x.getExtendedTypes());
        }
        this.print(" {");
        this.printContainerComments(x);
        if (x.getMembers() != null && !x.getMembers().isEmpty()) {
            this.printBlockList(2, 1, x.getMembers());
            this.changeLevel(-1);
        }
        this.printIndentation(1, this.getTotalIndentation());
        this.print(125);
        this.printFooter(x);
    }

    @Override
    public void visitAnnotationDeclaration(AnnotationDeclaration x) {
        this.visitInterfaceDeclaration(x, true);
    }

    @Override
    public void visitFieldDeclaration(FieldDeclaration x) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
            this.printKeywordList(x.getDeclarationSpecifiers());
        }
        this.printElement(m > 0 ? 1 : 0, x.getTypeReference());
        List<FieldSpecification> varSpecs = x.getVariables();
        if (varSpecs != null) {
            this.printCommaList(0, 0, 1, varSpecs);
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitLocalVariableDeclaration(LocalVariableDeclaration x) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
            this.printKeywordList(x.getDeclarationSpecifiers());
        }
        this.printElement(m > 0 ? 1 : 0, x.getTypeReference());
        List<VariableSpecification> varSpecs = x.getVariables();
        if (varSpecs != null) {
            this.printCommaList(0, 0, 1, varSpecs);
        }
        if (!(x.getStatementContainer() instanceof LoopStatement)) {
            this.print(59);
        }
        this.printFooter(x);
    }

    @Override
    protected void visitVariableDeclaration(VariableDeclaration x) {
        this.visitVariableDeclaration(x, false);
    }

    protected void visitVariableDeclaration(VariableDeclaration x, boolean spec) {
        List<? extends VariableSpecification> varSpecs;
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
            this.printKeywordList(x.getDeclarationSpecifiers());
        }
        this.printElement(m > 0 ? 1 : 0, x.getTypeReference());
        if (spec) {
            this.print(" ...");
        }
        if ((varSpecs = x.getVariables()) != null) {
            this.printCommaList(0, 0, 1, varSpecs);
        }
        this.printFooter(x);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclaration x) {
        AnnotationPropertyDeclaration apd;
        Expression e;
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
            this.printKeywordList(x.getDeclarationSpecifiers());
        }
        if (x.getTypeParameters() != null && x.getTypeParameters().size() > 0) {
            if (m > 0) {
                this.print(32);
            } else {
                this.printElementIndentation(x);
            }
            this.print(60);
            this.printCommaList(x.getTypeParameters());
            this.print(62);
            m = 1;
        }
        if (x.getTypeReference() != null) {
            if (m > 0) {
                this.printElement(1, x.getTypeReference());
            } else {
                this.printElement(x.getTypeReference());
            }
            this.printElement(1, x.getIdentifier());
        } else if (m > 0) {
            this.printElement(1, x.getIdentifier());
        } else {
            this.printElement(x.getIdentifier());
        }
        if (this.getBooleanProperty("glueParameterLists")) {
            this.print(40);
        } else {
            this.print(" (");
        }
        if (x.getParameters() != null) {
            ASTList<ParameterDeclaration> params = x.getParameters();
            this.printCommaList(this.getBooleanProperty("glueParameters") ? 0 : 1, params);
        }
        this.print(41);
        if (x.getThrown() != null) {
            this.printElement(1, x.getThrown());
        }
        if (x instanceof AnnotationPropertyDeclaration && (e = (apd = (AnnotationPropertyDeclaration)x).getDefaultValueExpression()) != null) {
            this.print(" default ");
            e.accept(this);
        }
        if (x.getBody() != null) {
            this.printElement(1, x.getBody());
        } else {
            this.print(59);
        }
        this.printFooter(x);
    }

    @Override
    public void visitClassInitializer(ClassInitializer x) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
            this.printKeywordList(x.getDeclarationSpecifiers());
        }
        if (x.getBody() != null) {
            this.printElement(m > 0 ? 1 : 0, x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitStatementBlock(StatementBlock x) {
        int lf;
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(123);
        boolean doNotPossiblyPrintIndentation = this.printContainerComments(x);
        if (x.getBody() != null && x.getBody().size() > 0) {
            this.printLineList(1, 1, x.getBody());
            this.changeLevel(-1);
            SourceElement.Position firstStatementEndPosition = ((Statement)x.getBody().get(0)).getEndPosition();
            SourceElement.Position blockEndPosition = x.getEndPosition();
            if (x.getBody().size() > 1 || firstStatementEndPosition.equals(SourceElement.Position.UNDEFINED) || blockEndPosition.equals(SourceElement.Position.UNDEFINED) || firstStatementEndPosition.getLine() < blockEndPosition.getLine()) {
                this.printIndentation(1, this.getTotalIndentation());
            } else {
                this.printIndentation(0, blockEndPosition.getColumn() - firstStatementEndPosition.getColumn() - 1);
            }
        } else if (!doNotPossiblyPrintIndentation && (lf = x.getEndPosition().getLine() - x.getStartPosition().getLine()) > 0) {
            this.printIndentation(lf, this.getIndentation());
        }
        this.print(125);
        this.printFooter(x);
    }

    @Override
    public void visitBreak(Break x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("break");
        if (x.getIdentifier() != null) {
            this.printElement(1, x.getIdentifier());
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitContinue(Continue x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("continue");
        if (x.getIdentifier() != null) {
            this.printElement(1, x.getIdentifier());
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitReturn(Return x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("return");
        if (x.getExpression() != null) {
            this.printElement(1, x.getExpression());
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitThrow(Throw x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("throw");
        if (x.getExpression() != null) {
            this.printElement(1, x.getExpression());
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitDo(Do x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("do");
        if (x.getBody() == null || x.getBody() instanceof EmptyStatement) {
            this.print(59);
        } else if (this.getBooleanProperty("glueStatementBlocks")) {
            this.printElement(1, x.getBody());
        } else if (x.getBody() instanceof StatementBlock) {
            this.printElement(1, 0, x.getBody());
        } else {
            this.printElement(1, 1, 0, x.getBody());
            this.changeLevel(-1);
        }
        if (this.getBooleanProperty("glueStatementBlocks")) {
            this.print(" while");
        } else {
            this.printIndentation(1, this.getTotalIndentation());
            this.print("while");
        }
        if (this.getBooleanProperty("glueParameterLists")) {
            this.print(40);
        } else {
            this.print(" (");
        }
        if (x.getGuard() != null) {
            boolean glueExprParentheses = this.getBooleanProperty("glueExpressionParentheses");
            if (!glueExprParentheses) {
                this.print(32);
            }
            this.printElement(x.getGuard());
            if (!glueExprParentheses) {
                this.print(32);
            }
        }
        this.print(");");
        this.printFooter(x);
    }

    @Override
    public void visitFor(For x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(this.getBooleanProperty("glueControlExpressions") ? "for(" : "for (");
        boolean glueExprParentheses = this.getBooleanProperty("glueExpressionParentheses");
        if (!glueExprParentheses) {
            this.print(32);
        }
        if (x.getInitializers() != null) {
            this.printCommaList(x.getInitializers());
        }
        this.print(59);
        if (x.getGuard() != null) {
            this.printElement(1, x.getGuard());
        }
        this.print(59);
        if (x.getUpdates() != null) {
            this.printCommaList(0, 0, 1, x.getUpdates());
        }
        if (!glueExprParentheses) {
            this.print(32);
        }
        this.print(41);
        if (x.getBody() == null || x.getBody() instanceof EmptyStatement) {
            this.print(59);
        } else if (this.getBooleanProperty("glueStatementBlocks")) {
            this.printElement(1, x.getBody());
        } else if (x.getBody() instanceof StatementBlock) {
            this.printElement(1, 0, x.getBody());
        } else {
            this.printElement(1, 1, 0, x.getBody());
            this.changeLevel(-1);
        }
        this.printFooter(x);
    }

    @Override
    public void visitEnhancedFor(EnhancedFor x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(this.getBooleanProperty("glueControlExpressions") ? "for(" : "for (");
        boolean glueExprParentheses = this.getBooleanProperty("glueExpressionParentheses");
        if (!glueExprParentheses) {
            this.print(32);
        }
        this.printCommaList(x.getInitializers());
        this.print(58);
        this.printElement(1, x.getGuard());
        if (!glueExprParentheses) {
            this.print(32);
        }
        this.print(41);
        if (x.getBody() == null || x.getBody() instanceof EmptyStatement) {
            this.print(59);
        } else if (this.getBooleanProperty("glueStatementBlocks")) {
            this.printElement(1, x.getBody());
        } else {
            this.printElement(1, 1, 0, x.getBody());
            this.changeLevel(-1);
        }
        this.printFooter(x);
    }

    @Override
    public void visitWhile(While x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(this.getBooleanProperty("glueControlExpressions") ? "while(" : "while (");
        boolean glueExpParentheses = this.getBooleanProperty("glueExpressionParentheses");
        if (!glueExpParentheses) {
            this.print(32);
        }
        if (x.getGuard() != null) {
            this.printElement(x.getGuard());
        }
        if (glueExpParentheses) {
            this.print(41);
        } else {
            this.print(" )");
        }
        if (x.getBody() == null || x.getBody() instanceof EmptyStatement) {
            this.print(59);
        } else if (this.getBooleanProperty("glueStatementBlocks")) {
            this.printElement(1, x.getBody());
        } else if (x.getBody() instanceof StatementBlock) {
            this.printElement(1, 0, x.getBody());
        } else {
            this.printElement(1, 1, 0, x.getBody());
            this.changeLevel(-1);
        }
        this.printFooter(x);
    }

    @Override
    public void visitAssert(Assert x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("assert");
        if (x.getCondition() != null) {
            this.printElement(1, x.getCondition());
        }
        if (x.getMessage() != null) {
            this.print(" :");
            this.printElement(1, x.getMessage());
        }
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitIf(If x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(this.getBooleanProperty("glueControlExpressions") ? "if(" : "if (");
        boolean glueExpr = this.getBooleanProperty("glueExpressionParentheses");
        if (x.getExpression() != null) {
            if (glueExpr) {
                this.printElement(x.getExpression());
            } else {
                this.printElement(1, x.getExpression());
            }
        }
        if (glueExpr) {
            this.print(41);
        } else {
            this.print(" )");
        }
        if (x.getThen() != null) {
            if (this.getBooleanProperty("glueStatementBlocks")) {
                this.printElement(1, x.getThen());
            } else if (x.getThen().getBody() instanceof StatementBlock) {
                this.printElement(1, 0, x.getThen());
            } else {
                this.printElement(1, 1, 0, x.getThen());
                this.changeLevel(-1);
            }
        }
        if (x.getElse() != null) {
            if (this.getBooleanProperty("glueSequentialBranches")) {
                this.printElement(1, x.getElse());
            } else {
                this.printElement(1, 0, x.getElse());
            }
        }
        this.printFooter(x);
    }

    @Override
    public void visitSwitch(Switch x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("switch (");
        if (x.getExpression() != null) {
            this.printElement(x.getExpression());
        }
        this.print(") {");
        if (x.getBranchList() != null) {
            if (this.getBooleanProperty("glueSequentialBranches")) {
                this.printLineList(1, 1, x.getBranchList());
                this.changeLevel(-1);
            } else {
                this.printLineList(1, 0, x.getBranchList());
            }
        }
        this.printIndentation(1, this.getTotalIndentation());
        this.print(125);
        this.printFooter(x);
    }

    @Override
    public void visitTry(Try x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("try");
        if (x.getBody() != null) {
            if (this.getBooleanProperty("glueStatementBlocks")) {
                this.printElement(1, x.getBody());
            } else {
                this.printElement(1, 0, x.getBody());
            }
        }
        if (x.getBranchList() != null) {
            if (this.getBooleanProperty("glueSequentialBranches")) {
                int i = 0;
                while (i < x.getBranchList().size()) {
                    this.printElement(1, (SourceElement)x.getBranchList().get(i));
                    ++i;
                }
            } else {
                this.printLineList(1, 0, x.getBranchList());
            }
        }
        this.printFooter(x);
    }

    @Override
    public void visitLabeledStatement(LabeledStatement x) {
        this.printHeader(x);
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
            this.printElementIndentation(x);
            this.print(58);
        }
        if (x.getBody() != null) {
            this.printElement(1, 0, x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitSynchronizedBlock(SynchronizedBlock x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("synchronized");
        if (x.getExpression() != null) {
            this.print(40);
            this.printElement(x.getExpression());
            this.print(41);
        }
        if (x.getBody() != null) {
            this.printElement(1, x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitImport(Import x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("import");
        if (x.isStaticImport()) {
            this.print(" static");
        }
        this.printElement(1, x.getReference());
        if (x.isMultiImport()) {
            this.print(".*;");
        } else {
            if (x.isStaticImport()) {
                this.print(".");
                this.printElement(x.getStaticIdentifier());
            }
            this.print(59);
        }
        this.printFooter(x);
    }

    @Override
    public void visitUncollatedReferenceQualifier(UncollatedReferenceQualifier x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(46);
        }
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        this.printFooter(x);
    }

    @Override
    public void visitExtends(Extends x) {
        this.printHeader(x);
        if (x.getSupertypes() != null) {
            this.printElementIndentation(x);
            this.print("extends");
            this.printCommaList(0, 0, 1, x.getSupertypes());
        }
        this.printFooter(x);
    }

    @Override
    public void visitImplements(Implements x) {
        this.printHeader(x);
        if (x.getSupertypes() != null) {
            this.printElementIndentation(x);
            this.print("implements");
            this.printCommaList(0, 0, 1, x.getSupertypes());
        }
        this.printFooter(x);
    }

    @Override
    public void visitVariableSpecification(VariableSpecification x) {
        this.printHeader(x);
        this.printElement(x.getIdentifier());
        int i = 0;
        while (i < x.getDimensions()) {
            this.print("[]");
            ++i;
        }
        if (x.getInitializer() != null) {
            this.print(" =");
            this.printElement(0, 0, 1, x.getInitializer());
        }
        this.printFooter(x);
    }

    @Override
    public void visitBinaryAnd(BinaryAnd x) {
        this.printHeader(x);
        this.printOperator(x, "&");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryAndAssignment(BinaryAndAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "&=");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryOrAssignment(BinaryOrAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "|=");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryXOrAssignment(BinaryXOrAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "^=");
        this.printFooter(x);
    }

    @Override
    public void visitCopyAssignment(CopyAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "=");
        this.printFooter(x);
    }

    @Override
    public void visitDivideAssignment(DivideAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "/=");
        this.printFooter(x);
    }

    @Override
    public void visitMinusAssignment(MinusAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "-=");
        this.printFooter(x);
    }

    @Override
    public void visitModuloAssignment(ModuloAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "%=");
        this.printFooter(x);
    }

    @Override
    public void visitPlusAssignment(PlusAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "+=");
        this.printFooter(x);
    }

    @Override
    public void visitPostDecrement(PostDecrement x) {
        this.printHeader(x);
        this.printOperator(x, "--");
        this.printFooter(x);
    }

    @Override
    public void visitPostIncrement(PostIncrement x) {
        this.printHeader(x);
        this.printOperator(x, "++");
        this.printFooter(x);
    }

    @Override
    public void visitPreDecrement(PreDecrement x) {
        this.printHeader(x);
        this.printOperator(x, "--");
        this.printFooter(x);
    }

    @Override
    public void visitPreIncrement(PreIncrement x) {
        this.printHeader(x);
        this.printOperator(x, "++");
        this.printFooter(x);
    }

    @Override
    public void visitShiftLeftAssignment(ShiftLeftAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "<<=");
        this.printFooter(x);
    }

    @Override
    public void visitShiftRightAssignment(ShiftRightAssignment x) {
        this.printHeader(x);
        this.printOperator(x, ">>=");
        this.printFooter(x);
    }

    @Override
    public void visitTimesAssignment(TimesAssignment x) {
        this.printHeader(x);
        this.printOperator(x, "*=");
        this.printFooter(x);
    }

    @Override
    public void visitUnsignedShiftRightAssignment(UnsignedShiftRightAssignment x) {
        this.printHeader(x);
        this.printOperator(x, ">>>=");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryNot(BinaryNot x) {
        this.printHeader(x);
        this.printOperator(x, "~");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryOr(BinaryOr x) {
        this.printHeader(x);
        this.printOperator(x, "|");
        this.printFooter(x);
    }

    @Override
    public void visitBinaryXOr(BinaryXOr x) {
        this.printHeader(x);
        this.printOperator(x, "^");
        this.printFooter(x);
    }

    @Override
    public void visitConditional(Conditional x) {
        this.printHeader(x);
        boolean addParentheses = x.isToBeParenthesized();
        if (x.getArguments() != null) {
            if (addParentheses) {
                this.print(40);
            }
            this.printElement(0, (SourceElement)x.getArguments().get(0));
            this.print(" ?");
            this.printElement(1, (SourceElement)x.getArguments().get(1));
            this.print(" :");
            this.printElement(1, (SourceElement)x.getArguments().get(2));
            if (addParentheses) {
                this.print(41);
            }
        }
        this.printFooter(x);
    }

    @Override
    public void visitDivide(Divide x) {
        this.printHeader(x);
        this.printOperator(x, "/");
        this.printFooter(x);
    }

    @Override
    public void visitEquals(Equals x) {
        this.printHeader(x);
        this.printOperator(x, "==");
        this.printFooter(x);
    }

    @Override
    public void visitGreaterOrEquals(GreaterOrEquals x) {
        this.printHeader(x);
        this.printOperator(x, ">=");
        this.printFooter(x);
    }

    @Override
    public void visitGreaterThan(GreaterThan x) {
        this.printHeader(x);
        this.printOperator(x, ">");
        this.printFooter(x);
    }

    @Override
    public void visitLessOrEquals(LessOrEquals x) {
        this.printHeader(x);
        this.printOperator(x, "<=");
        this.printFooter(x);
    }

    @Override
    public void visitLessThan(LessThan x) {
        this.printHeader(x);
        this.printOperator(x, "<");
        this.printFooter(x);
    }

    @Override
    public void visitNotEquals(NotEquals x) {
        this.printHeader(x);
        this.printOperator(x, "!=");
        this.printFooter(x);
    }

    @Override
    public void visitNewArray(NewArray x) {
        this.printHeader(x);
        boolean addParentheses = x.isToBeParenthesized();
        if (addParentheses) {
            this.print(40);
        }
        this.printElementIndentation(x);
        this.print("new");
        this.printElement(1, x.getTypeReference());
        int i = 0;
        if (x.getArguments() != null) {
            while (i < x.getArguments().size()) {
                this.print(91);
                this.printElement((SourceElement)x.getArguments().get(i));
                this.print(93);
                ++i;
            }
        }
        while (i < x.getDimensions()) {
            this.print("[]");
            ++i;
        }
        if (x.getArrayInitializer() != null) {
            this.printElement(1, x.getArrayInitializer());
        }
        if (addParentheses) {
            this.print(41);
        }
        this.printFooter(x);
    }

    @Override
    public void visitInstanceof(Instanceof x) {
        this.printHeader(x);
        boolean addParentheses = x.isToBeParenthesized();
        if (addParentheses) {
            this.print(40);
        }
        if (x.getArguments() != null) {
            this.printElement(0, (SourceElement)x.getArguments().get(0));
        }
        this.printElementIndentation(1, x);
        this.print("instanceof");
        if (x.getTypeReference() != null) {
            this.printElement(1, x.getTypeReference());
        }
        if (addParentheses) {
            this.print(41);
        }
        this.printFooter(x);
    }

    @Override
    public void visitNew(New x) {
        this.printHeader(x);
        boolean addParentheses = x.isToBeParenthesized();
        if (addParentheses) {
            this.print(40);
        }
        if (x.getReferencePrefix() != null) {
            this.printElement(0, x.getReferencePrefix());
            this.print(46);
        }
        this.printElementIndentation(x);
        this.print("new");
        if (x.getConstructorRefTypeArguments() != null && x.getConstructorRefTypeArguments().size() > 0) {
            this.print(60);
            this.printCommaList(x.getConstructorRefTypeArguments());
            this.print(62);
        }
        this.printElement(1, x.getTypeReference());
        if (this.getBooleanProperty("glueParameterLists")) {
            this.print(40);
        } else {
            this.print(" (");
        }
        if (x.getArguments() != null) {
            this.printCommaList(x.getArguments());
        }
        this.print(41);
        if (x.getClassDeclaration() != null) {
            this.printElement(1, x.getClassDeclaration());
        }
        if (addParentheses) {
            this.print(41);
        }
        if (x.getStatementContainer() != null) {
            this.print(59);
        }
        this.printFooter(x);
    }

    @Override
    public void visitTypeCast(TypeCast x) {
        this.printHeader(x);
        boolean addParentheses = x.isToBeParenthesized();
        if (addParentheses) {
            this.print(40);
        }
        this.printElementIndentation(x);
        this.print(40);
        if (x.getTypeReference() != null) {
            this.printElement(0, x.getTypeReference());
        }
        this.print(41);
        if (x.getArguments() != null) {
            this.printElement(0, (SourceElement)x.getArguments().get(0));
        }
        if (addParentheses) {
            this.print(41);
        }
        this.printFooter(x);
    }

    @Override
    public void visitLogicalAnd(LogicalAnd x) {
        this.printHeader(x);
        this.printOperator(x, "&&");
        this.printFooter(x);
    }

    @Override
    public void visitLogicalNot(LogicalNot x) {
        this.printHeader(x);
        this.printOperator(x, "!");
        this.printFooter(x);
    }

    @Override
    public void visitLogicalOr(LogicalOr x) {
        this.printHeader(x);
        this.printOperator(x, "||");
        this.printFooter(x);
    }

    @Override
    public void visitMinus(Minus x) {
        this.printHeader(x);
        this.printOperator(x, "-");
        this.printFooter(x);
    }

    @Override
    public void visitModulo(Modulo x) {
        this.printHeader(x);
        this.printOperator(x, "%");
        this.printFooter(x);
    }

    @Override
    public void visitNegative(Negative x) {
        this.printHeader(x);
        this.printOperator(x, "-");
        this.printFooter(x);
    }

    @Override
    public void visitPlus(Plus x) {
        ArrayList<Plus> plusses = new ArrayList<Plus>();
        this.printHeader(x);
        while (x.getArguments().get(0) instanceof Plus) {
            plusses.add(x);
            x = (Plus)x.getArguments().get(0);
        }
        for (Plus p : plusses) {
            this.printHeader(p);
        }
        this.printOperator(x, "+");
        Collections.reverse(plusses);
        for (Plus p : plusses) {
            int indent = this.getBooleanProperty("glueInfixOperators") ? 0 : 1;
            this.printElementIndentation(indent, x);
            this.print("+");
            this.printElement(indent, (SourceElement)p.getArguments().get(1));
            this.printFooter(p);
        }
    }

    @Override
    public void visitPositive(Positive x) {
        this.printHeader(x);
        this.printOperator(x, "+");
        this.printFooter(x);
    }

    @Override
    public void visitShiftLeft(ShiftLeft x) {
        this.printHeader(x);
        this.printOperator(x, "<<");
        this.printFooter(x);
    }

    @Override
    public void visitShiftRight(ShiftRight x) {
        this.printHeader(x);
        this.printOperator(x, ">>");
        this.printFooter(x);
    }

    @Override
    public void visitTimes(Times x) {
        this.printHeader(x);
        this.printOperator(x, "*");
        this.printFooter(x);
    }

    @Override
    public void visitUnsignedShiftRight(UnsignedShiftRight x) {
        this.printHeader(x);
        this.printOperator(x, ">>>");
        this.printFooter(x);
    }

    @Override
    public void visitArrayReference(ArrayReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
        }
        if (x.getDimensionExpressions() != null) {
            int s = x.getDimensionExpressions().size();
            int i = 0;
            while (i < s) {
                this.print(91);
                this.printElement((SourceElement)x.getDimensionExpressions().get(i));
                this.print(93);
                ++i;
            }
        }
        this.printFooter(x);
    }

    @Override
    public void visitFieldReference(FieldReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(46);
        }
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        this.printFooter(x);
    }

    @Override
    public void visitVariableReference(VariableReference x) {
        this.printHeader(x);
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        this.printFooter(x);
    }

    @Override
    public void visitMetaClassReference(MetaClassReference x) {
        this.printHeader(x);
        if (x.getTypeReference() != null) {
            this.printElement(x.getTypeReference());
            this.printElementIndentation(x);
            this.print(46);
        }
        this.print("class");
        this.printFooter(x);
    }

    @Override
    public void visitMethodReference(MethodReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.print(46);
        }
        if (x.getTypeArguments() != null && x.getTypeArguments().size() > 0) {
            this.print(60);
            this.printCommaList(x.getTypeArguments());
            this.print(62);
        }
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        if (this.getBooleanProperty("glueParameterLists")) {
            this.print(40);
        } else {
            this.print(" (");
        }
        if (x.getArguments() != null) {
            this.printCommaList(x.getArguments());
        }
        this.print(41);
        if (x.getStatementContainer() != null) {
            this.print(59);
        }
        this.printFooter(x);
    }

    @Override
    public void visitSuperConstructorReference(SuperConstructorReference x) {
        this.printHeader(x);
        if (x.getTypeArguments() != null && x.getTypeArguments().size() > 0) {
            this.print(60);
            this.printCommaList(x.getTypeArguments());
            this.print(62);
        }
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.print(46);
        }
        this.printElementIndentation(x);
        if (this.getBooleanProperty("glueParameterLists")) {
            this.print("super(");
        } else {
            this.print("super (");
        }
        if (x.getArguments() != null) {
            this.printCommaList(x.getArguments());
        }
        this.print(");");
        this.printFooter(x);
    }

    @Override
    public void visitThisConstructorReference(ThisConstructorReference x) {
        this.printHeader(x);
        if (x.getTypeArguments() != null && x.getTypeArguments().size() > 0) {
            this.print(60);
            this.printCommaList(x.getTypeArguments());
            this.print(62);
        }
        this.printElementIndentation(x);
        this.print(this.getBooleanProperty("glueParameterLists") ? "this(" : "this (");
        if (x.getArguments() != null) {
            this.printCommaList(x.getArguments());
        }
        this.print(");");
        this.printFooter(x);
    }

    @Override
    public void visitSuperReference(SuperReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(".super");
        } else {
            this.printElementIndentation(x);
            this.print("super");
        }
        this.printFooter(x);
    }

    @Override
    public void visitThisReference(ThisReference x) {
        this.printHeader(x);
        if (x.getReferencePrefix() != null) {
            this.printElement(x.getReferencePrefix());
            this.printElementIndentation(x);
            this.print(".this");
        } else {
            this.printElementIndentation(x);
            this.print("this");
        }
        this.printFooter(x);
    }

    @Override
    public void visitThen(Then x) {
        this.printHeader(x);
        if (x.getBody() != null) {
            this.printElement(x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitElse(Else x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("else");
        if (x.getBody() != null) {
            if (this.getBooleanProperty("glueStatementBlocks")) {
                this.printElement(1, x.getBody());
            } else if (x.getBody() instanceof StatementBlock) {
                this.printElement(1, 0, x.getBody());
            } else {
                this.printElement(1, 1, 0, x.getBody());
                this.changeLevel(-1);
            }
        }
        this.printFooter(x);
    }

    @Override
    public void visitCase(Case x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("case");
        if (x.getExpression() != null) {
            this.printElement(1, x.getExpression());
        }
        this.print(58);
        if (x.getBody() != null && x.getBody().size() > 0) {
            this.printLineList(1, 1, x.getBody());
            this.changeLevel(-1);
        }
        this.printFooter(x);
    }

    @Override
    public void visitCatch(Catch x) {
        this.printHeader(x);
        if (this.getBooleanProperty("glueControlExpressions")) {
            this.printElementIndentation(x);
            this.print("catch(");
        } else {
            this.printElementIndentation(x);
            this.print("catch (");
        }
        if (x.getParameterDeclaration() != null) {
            this.printElement(x.getParameterDeclaration());
        }
        this.print(41);
        if (x.getBody() != null) {
            this.printElement(1, x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitDefault(Default x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("default:");
        if (x.getBody() != null && x.getBody().size() > 0) {
            this.printLineList(1, 1, x.getBody());
            this.changeLevel(-1);
        }
        this.printFooter(x);
    }

    @Override
    public void visitFinally(Finally x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("finally");
        if (x.getBody() != null) {
            this.printElement(1, x.getBody());
        }
        this.printFooter(x);
    }

    @Override
    public void visitAbstract(Abstract x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("abstract");
        this.printFooter(x);
    }

    @Override
    public void visitFinal(Final x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("final");
        this.printFooter(x);
    }

    @Override
    public void visitNative(Native x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("native");
        this.printFooter(x);
    }

    @Override
    public void visitPrivate(Private x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("private");
        this.printFooter(x);
    }

    @Override
    public void visitProtected(Protected x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("protected");
        this.printFooter(x);
    }

    @Override
    public void visitPublic(Public x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("public");
        this.printFooter(x);
    }

    @Override
    public void visitStatic(Static x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("static");
        this.printFooter(x);
    }

    @Override
    public void visitStrictFp(StrictFp x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("strictfp");
        this.printFooter(x);
    }

    @Override
    public void visitSynchronized(Synchronized x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("synchronized");
        this.printFooter(x);
    }

    @Override
    public void visitTransient(Transient x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("transient");
        this.printFooter(x);
    }

    @Override
    public void visitVolatile(Volatile x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print("volatile");
        this.printFooter(x);
    }

    @Override
    public void visitAnnotationUse(AnnotationUseSpecification a) {
        this.printHeader(a);
        this.printElementIndentation(a);
        this.print(64);
        this.printElement(a.getTypeReference());
        List evp = a.getElementValuePairs();
        if (evp != null) {
            this.print(40);
            this.printCommaList(0, 0, 0, evp);
            this.print(41);
        }
        this.printFooter(a);
    }

    @Override
    public void visitElementValuePair(AnnotationElementValuePair x) {
        Expression ev;
        this.printHeader(x);
        this.printElementIndentation(x);
        AnnotationPropertyReference id = x.getElement();
        if (id != null) {
            this.printElement(id);
            this.print(" =");
        }
        if ((ev = x.getElementValue()) != null) {
            this.printElement(ev);
        }
        this.printFooter(x);
    }

    @Override
    public void visitAnnotationPropertyReference(AnnotationPropertyReference x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        Identifier id = x.getIdentifier();
        if (id != null) {
            this.printElement(id);
        }
        this.printFooter(x);
    }

    @Override
    public void visitEmptyStatement(EmptyStatement x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(59);
        this.printFooter(x);
    }

    @Override
    public void visitComment(Comment x) {
        this.printElementIndentation(x);
        this.print(x.getText());
        if (!x.getText().endsWith("\n")) {
            try {
                this.out.write("\n");
                this.column = 1;
                ++this.line;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.overwriteParsePositions) {
            this.overwritePosition.setPosition(this.line, Math.max(0, this.column - 1));
            x.getLastElement().setEndPosition(this.overwritePosition);
        }
    }

    @Override
    public void visitParenthesizedExpression(ParenthesizedExpression x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        this.print(40);
        if (x.getArguments() != null) {
            this.printElement((SourceElement)x.getArguments().get(0));
        }
        this.print(41);
        this.printFooter(x);
    }

    @Override
    public void visitEnumConstructorReference(EnumConstructorReference x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        ASTList<Expression> exprs = x.getArguments();
        if (exprs != null) {
            this.print(40);
            this.printCommaList(exprs);
            this.print(41);
        }
        if (x.getClassDeclaration() != null) {
            this.printElement(x.getClassDeclaration());
        }
    }

    @Override
    public void visitEnumConstantDeclaration(EnumConstantDeclaration x) {
        this.printHeader(x);
        this.printElementIndentation(x);
        if (x.getAnnotations() != null && x.getAnnotations().size() != 0) {
            this.printKeywordList(x.getAnnotations());
            this.print(32);
        }
        this.printElement(1, x.getEnumConstantSpecification());
        this.printFooter(x);
    }

    @Override
    public void visitEnumConstantSpecification(EnumConstantSpecification x) {
        this.printHeader(x);
        this.printElement(x.getIdentifier());
        this.printElement(x.getConstructorReference());
        this.printFooter(x);
    }

    @Override
    public void visitEnumDeclaration(EnumDeclaration x) {
        this.printHeader(x);
        int m = 0;
        if (x.getDeclarationSpecifiers() != null) {
            m = x.getDeclarationSpecifiers().size();
        }
        if (m > 0) {
            this.printKeywordList(x.getDeclarationSpecifiers());
            m = 1;
        }
        this.printElementIndentation(m, x);
        this.print("enum");
        this.printElement(1, x.getIdentifier());
        if (x.getImplementedTypes() != null) {
            this.printElement(1, x.getImplementedTypes());
        }
        this.print(32);
        this.print(123);
        this.printContainerComments(x);
        this.printCommaList(2, 1, 1, x.getConstants());
        this.print(";");
        this.changeLevel(-1);
        this.printBlockList(2, 1, x.getNonConstantMembers());
        this.changeLevel(-1);
        this.printIndentation(1, this.getTotalIndentation());
        this.print(125);
        this.printFooter(x);
    }

    @Override
    public void visitTypeArgument(TypeArgumentDeclaration x) {
        this.printHeader(x);
        switch (x.getWildcardMode()) {
            case None: {
                break;
            }
            case Any: {
                this.print("?");
                break;
            }
            case Extends: {
                this.print("? extends ");
                break;
            }
            case Super: {
                this.print("? super ");
            }
        }
        if (x.getTypeReferenceCount() == 1) {
            this.printElement(x.getTypeReferenceAt(0));
        }
        this.printFooter(x);
    }

    @Override
    public void visitTypeParameter(TypeParameterDeclaration x) {
        this.printHeader(x);
        if (x.getIdentifier() != null) {
            this.printElement(x.getIdentifier());
        }
        if (x.getBounds() != null && x.getBounds().size() != 0) {
            this.print(" extends ");
            this.printProgramElementList(0, 0, 0, "&", 0, 1, x.getBounds());
        }
        this.printFooter(x);
    }

    @Override
    public void visitParameterDeclaration(ParameterDeclaration x) {
        this.visitVariableDeclaration(x, x.isVarArg());
    }
}

