/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import recoder.convenience.Naming;
import recoder.java.CompilationUnit;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.reference.PackageReference;
import recoder.java.reference.PackageReferenceContainer;
import recoder.list.generic.ASTList;

public class PackageSpecification
extends JavaNonTerminalProgramElement
implements PackageReferenceContainer {
    private static final long serialVersionUID = -6415275246661492494L;
    private CompilationUnit parent;
    private PackageReference reference;
    private ASTList<AnnotationUseSpecification> annotations;

    public PackageSpecification() {
    }

    public PackageSpecification(PackageReference pkg) {
        this.setPackageReference(pkg);
        this.makeParentRoleValid();
    }

    protected PackageSpecification(PackageSpecification proto) {
        super(proto);
        if (proto.reference != null) {
            this.reference = proto.reference.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public PackageSpecification deepClone() {
        return new PackageSpecification(this);
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        this.reference.setParent(this);
        if (this.annotations != null) {
            int i = 0;
            while (i < this.annotations.size()) {
                ((AnnotationUseSpecification)this.annotations.get(i)).setParent(this);
                ++i;
            }
        }
    }

    @Override
    public SourceElement getLastElement() {
        return this.reference;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.reference != null) {
            ++result;
        }
        if (this.annotations != null) {
            result += this.annotations.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.reference != null) {
            if (index == 0) {
                return this.reference;
            }
            --index;
        }
        return (ProgramElement)this.annotations.get(index);
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int idx;
        if (child == this.reference) {
            return 0;
        }
        if (this.annotations != null && (idx = this.annotations.indexOf(child)) != -1) {
            return idx << 4 | 1;
        }
        return -1;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.reference == p) {
            PackageReference r;
            this.reference = r = (PackageReference)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        int idx = this.annotations.indexOf(p);
        if (idx != -1) {
            AnnotationUseSpecification aus = (AnnotationUseSpecification)q;
            this.annotations.set(idx, aus);
            if (aus != null) {
                aus.setParent(this);
            }
            return true;
        }
        return false;
    }

    public CompilationUnit getParent() {
        return this.parent;
    }

    public void setParent(CompilationUnit u) {
        this.parent = u;
    }

    @Override
    public PackageReference getPackageReference() {
        return this.reference;
    }

    public void setPackageReference(PackageReference ref) {
        this.reference = ref;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitPackageSpecification(this);
    }

    public void setAnnotations(ASTList<AnnotationUseSpecification> annotations) {
        this.annotations = annotations;
    }

    public ASTList<AnnotationUseSpecification> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "<PackageSpecification> " + Naming.toPathName(this.reference);
    }
}

