/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import recoder.ParserException;
import recoder.ProgramFactory;
import recoder.ServiceConfiguration;
import recoder.abstraction.TypeArgument;
import recoder.convenience.TreeWalker;
import recoder.io.ProjectSettings;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.DocComment;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.JavaSourceElement;
import recoder.java.LoopInitializer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.PrettyPrinter;
import recoder.java.ProgramElement;
import recoder.java.SingleLineComment;
import recoder.java.SourceElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationElementValuePair;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Native;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.StrictFp;
import recoder.java.declaration.modifier.Synchronized;
import recoder.java.declaration.modifier.Transient;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.declaration.modifier.Volatile;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.ElementValueArrayInitializer;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryAndAssignment;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryOrAssignment;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.BinaryXOrAssignment;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.DivideAssignment;
import recoder.java.expression.operator.Equals;
import recoder.java.expression.operator.GreaterOrEquals;
import recoder.java.expression.operator.GreaterThan;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LessOrEquals;
import recoder.java.expression.operator.LessThan;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.MinusAssignment;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.ModuloAssignment;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.NotEquals;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.PlusAssignment;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftLeftAssignment;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.ShiftRightAssignment;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TimesAssignment;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.expression.operator.UnsignedShiftRightAssignment;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Assert;
import recoder.java.statement.Branch;
import recoder.java.statement.Break;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Continue;
import recoder.java.statement.Default;
import recoder.java.statement.Do;
import recoder.java.statement.Else;
import recoder.java.statement.EmptyStatement;
import recoder.java.statement.EnhancedFor;
import recoder.java.statement.Finally;
import recoder.java.statement.For;
import recoder.java.statement.If;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.Return;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Then;
import recoder.java.statement.Throw;
import recoder.java.statement.Try;
import recoder.java.statement.While;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.parser.JavaCCParser;
import recoder.util.StringUtils;

public class JavaProgramFactory
implements ProgramFactory,
PropertyChangeListener {
    private HashMap<ProgramElement, TraceItem> createdItems;
    private boolean doTrace = false;
    private boolean autoTrace = true;
    private ServiceConfiguration serviceConfiguration;
    private StringWriter writer = new StringWriter();
    private PrettyPrinter sourcePrinter;
    private boolean useAddNewlineReader = true;
    private JavaCCParser parser = new JavaCCParser(System.in);
    private static final SourceElement.Position ZERO_POSITION = new SourceElement.Position(0, 0);
    public static boolean TESTING_DeepClone_Each_CU_before_return = false;

    public JavaCCParser getParser() {
        return this.parser;
    }

    public void beginTracing() {
        this.createdItems = new HashMap(1000);
        this.doTrace = true;
    }

    public void detrace(ProgramElement pe) {
        TreeWalker tw = new TreeWalker(pe);
        while (tw.next()) {
            this.createdItems.remove(tw.getProgramElement());
        }
    }

    public TraceItem getTraceItem(ProgramElement pe) {
        return this.createdItems.get(pe);
    }

    public Collection<TraceItem> endTracing() {
        this.doTrace = false;
        return this.createdItems.values();
    }

    public void trace(ProgramElement pe) {
        if (this.doTrace && this.autoTrace) {
            this.createdItems.put(pe, new TraceItem(pe));
        }
    }

    public void manTrace(ProgramElement pe) {
        if (this.doTrace) {
            this.createdItems.put(pe, new TraceItem(pe));
        }
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        this.serviceConfiguration = cfg;
        ProjectSettings settings = this.serviceConfiguration.getProjectSettings();
        settings.addPropertyChangeListener(this);
        this.writer = new StringWriter();
        this.sourcePrinter = new PrettyPrinter(this.writer, settings.getProperties());
        this.parser.setAwareOfAssert(StringUtils.parseBooleanProperty(settings.getProperties().getProperty("jdk1.4")));
        this.parser.setJava5(StringUtils.parseBooleanProperty(settings.getProperties().getProperty("java5")));
    }

    @Override
    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    private void attachComment(Comment c, ProgramElement pe) {
        ASTList<Comment> cml;
        SourceElement.Position p;
        int distPost;
        int distPre;
        int idx;
        NonTerminalProgramElement npe;
        ProgramElement dest = pe;
        if (c.isPrefixed() && pe instanceof CompilationUnit && ((CompilationUnit)pe).getChildCount() > 0) {
            ProgramElement fc = ((CompilationUnit)pe).getChildAt(0);
            int distcu = c.getStartPosition().getLine();
            int distfc = fc.getStartPosition().getLine() - c.getEndPosition().getLine();
            if (c instanceof SingleLineComment) {
                --distcu;
            }
            if (distcu >= distfc) {
                dest = fc;
            }
        } else if (!c.isPrefixed()) {
            NonTerminalProgramElement ppe = dest.getASTParent();
            int i = 0;
            if (ppe != null) {
                while (ppe.getChildAt(i) != dest) {
                    ++i;
                }
            }
            if (i == 0) {
                c.setPrefixed(true);
            } else {
                dest = ppe.getChildAt(i - 1);
                while (dest instanceof NonTerminalProgramElement) {
                    ppe = (NonTerminalProgramElement)dest;
                    i = ppe.getChildCount();
                    if (i == 0) break;
                    dest = ppe.getChildAt(i - 1);
                }
                ppe = dest.getASTParent();
                boolean doChange = false;
                while (ppe != null && ppe.getASTParent() != null && ppe.getEndPosition().compareTo(dest.getEndPosition()) >= 0 && ppe.getASTParent().getEndPosition().compareTo(c.getStartPosition()) <= 0) {
                    ppe = ppe.getASTParent();
                    doChange = true;
                }
                if (ppe != null && doChange) {
                    dest = ppe;
                }
                if (dest instanceof NonTerminalProgramElement && (ppe = (NonTerminalProgramElement)dest).getEndPosition().compareTo(c.getStartPosition()) >= 0) {
                    while (ppe.getChildCount() > 0 && ppe.getChildAt(ppe.getChildCount() - 1).getEndPosition().compareTo(ppe.getEndPosition()) == 0 && ppe.getChildAt(ppe.getChildCount() - 1) instanceof NonTerminalProgramElement) {
                        ppe = (NonTerminalProgramElement)ppe.getChildAt(ppe.getChildCount() - 1);
                        dest = ppe;
                    }
                    c.setContainerComment(true);
                }
                if (!c.isContainerComment() && pe != dest && pe.getFirstElement().getStartPosition().getLine() == dest.getLastElement().getEndPosition().getLine()) {
                    int before = c.getStartPosition().getColumn() - dest.getLastElement().getEndPosition().getColumn();
                    int after = pe.getFirstElement().getStartPosition().getColumn() - c.getEndPosition().getColumn();
                    if (after <= before) {
                        dest = pe;
                        c.setPrefixed(true);
                    }
                }
            }
        }
        if (c.isPrefixed()) {
            npe = dest.getASTParent();
            while (npe != null && npe.getStartPosition().equals(dest.getStartPosition())) {
                dest = npe;
                npe = npe.getASTParent();
            }
        } else if (!c.isContainerComment()) {
            npe = dest.getASTParent();
            while (npe != null && npe.getEndPosition().equals(dest.getEndPosition())) {
                dest = npe;
                npe = npe.getASTParent();
            }
        }
        if (c.isPrefixed() && c.getEndPosition().getLine() < dest.getStartPosition().getLine()) {
            npe = dest.getASTParent();
            if (npe != null && (idx = npe.getIndexOfChild(dest)) > 0) {
                distPre = dest.getStartPosition().getLine() - c.getEndPosition().getLine();
                distPost = c.getStartPosition().getLine() - npe.getChildAt(idx - 1).getEndPosition().getLine();
                if (c instanceof SingleLineComment) {
                    --distPost;
                }
                if (distPost < distPre) {
                    dest = npe.getChildAt(idx - 1);
                    c.setPrefixed(false);
                }
            }
        } else if (!c.isPrefixed() && c.getStartPosition().getLine() > dest.getEndPosition().getLine() && (npe = dest.getASTParent()) != null && (idx = npe.getIndexOfChild(dest)) + 1 < npe.getChildCount()) {
            distPre = npe.getChildAt(idx + 1).getStartPosition().getLine() - c.getEndPosition().getLine();
            distPost = c.getStartPosition().getLine() - dest.getEndPosition().getLine();
            if (c instanceof SingleLineComment) {
                --distPost;
            }
            if (distPre <= distPost) {
                dest = npe.getChildAt(idx + 1);
                c.setPrefixed(true);
            }
        }
        if (c instanceof SingleLineComment && c.isPrefixed() && (p = dest.getFirstElement().getRelativePosition()).getLine() < 1) {
            p.setLine(1);
            dest.getFirstElement().setRelativePosition(p);
        }
        if ((cml = dest.getComments()) == null) {
            cml = new ASTArrayList<Comment>();
            dest.setComments(cml);
        }
        cml.add(c);
    }

    private void postWork(ProgramElement pe, List<Comment> comments) {
        int commentIndex = 0;
        int commentCount = comments.size();
        SourceElement.Position cpos = ZERO_POSITION;
        Comment current = null;
        if (commentIndex < commentCount) {
            current = comments.get(commentIndex);
            cpos = current.getFirstElement().getStartPosition();
        }
        TreeWalker tw = new TreeWalker(pe);
        while (tw.next()) {
            pe = tw.getProgramElement();
            if (pe instanceof NonTerminalProgramElement) {
                ((NonTerminalProgramElement)pe).makeParentRoleValid();
            }
            if (pe instanceof StatementBlock || pe instanceof ArrayInitializer || pe instanceof TypeDeclaration) {
                while ((pe instanceof StatementBlock && ((StatementBlock)pe).getStatementCount() == 0 || pe instanceof ArrayInitializer && (((ArrayInitializer)pe).getArguments() == null || ((ArrayInitializer)pe).getArguments().size() == 0) || pe instanceof TypeDeclaration && (((TypeDeclaration)pe).getMembers() == null || ((TypeDeclaration)pe).getMembers().size() == 0)) && pe.getStartPosition().compareTo(cpos) < 0 && pe.getEndPosition().compareTo(cpos) > 0) {
                    current.setContainerComment(true);
                    ASTList<Comment> cml = pe.getComments();
                    if (cml == null) {
                        cml = new ASTArrayList<Comment>();
                        pe.setComments(cml);
                    }
                    cml.add(current);
                    if (++commentIndex >= commentCount) break;
                    current = comments.get(commentIndex);
                    cpos = current.getFirstElement().getStartPosition();
                }
            }
            SourceElement.Position pos = pe.getFirstElement().getStartPosition();
            while (commentIndex < commentCount && pos.compareTo(cpos) > 0) {
                this.attachComment(current, pe);
                if (++commentIndex >= commentCount) continue;
                current = comments.get(commentIndex);
                cpos = current.getFirstElement().getStartPosition();
            }
        }
        if (commentIndex < commentCount) {
            while (pe.getASTParent() != null) {
                pe = pe.getASTParent();
            }
            do {
                current = comments.get(commentIndex);
                ProgramElement dest = pe;
                ProgramElement newDest = null;
                while (dest instanceof NonTerminalProgramElement) {
                    NonTerminalProgramElement npe = (NonTerminalProgramElement)dest;
                    if (npe.getChildCount() == 0) break;
                    newDest = npe.getChildAt(npe.getChildCount() - 1);
                    if (npe.getEndPosition().compareTo(current.getStartPosition()) <= 0 && (npe.getEndPosition().compareTo(current.getStartPosition()) != 0 || newDest.getEndPosition().compareTo(current.getStartPosition()) > 0) || dest == newDest) break;
                    dest = newDest;
                }
                ASTList<Comment> cml = dest.getComments();
                if (cml == null) {
                    cml = new ASTArrayList<Comment>();
                    dest.setComments(cml);
                }
                current.setPrefixed(false);
                cml.add(current);
            } while (++commentIndex < commentCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit parseCompilationUnit(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(this.useAddNewlineReader ? new AddNewlineReader(in) : in, this);
            CompilationUnit res = this.parser.CompilationUnit();
            this.postWork(res, this.parser.getComments());
            if (TESTING_DeepClone_Each_CU_before_return) {
                res = res.deepClone();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit parseCompilationUnit(Reader in, String sourceVersion) throws IOException, ParserException {
        boolean java14 = true;
        boolean java5 = false;
        if (sourceVersion != null) {
            if (sourceVersion.equals("1.3") || sourceVersion.startsWith("1.3.")) {
                java14 = false;
                java5 = false;
            }
            if (sourceVersion.equals("1.4") || sourceVersion.startsWith("1.4.")) {
                java14 = true;
                java5 = false;
            }
            if (sourceVersion.equals("1.5") || sourceVersion.startsWith("1.5.")) {
                java14 = true;
                java5 = true;
            }
            if (sourceVersion.equals("5") || sourceVersion.startsWith("5.")) {
                java14 = true;
                java5 = true;
            }
        }
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            boolean wasJava14 = this.parser.isAwareOfAssert();
            boolean wasJava5 = this.parser.isJava5();
            this.parser.setAwareOfAssert(java14);
            this.parser.setJava5(java5);
            this.parser.initialize(this.useAddNewlineReader ? new AddNewlineReader(in) : in, this);
            CompilationUnit res = this.parser.CompilationUnit();
            this.postWork(res, this.parser.getComments());
            this.parser.setAwareOfAssert(wasJava14);
            this.parser.setJava5(wasJava5);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDeclaration parseTypeDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            TypeDeclaration res = this.parser.TypeDeclaration();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeArgumentDeclaration parseTypeArgumentDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            TypeArgumentDeclaration res = this.parser.TypeArgument();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldDeclaration parseFieldDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            FieldDeclaration res = this.parser.FieldDeclaration();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodDeclaration parseMethodDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            MethodDeclaration res = this.parser.MethodDeclaration();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemberDeclaration parseMemberDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            MemberDeclaration res = this.parser.ClassBodyDeclaration();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDeclaration parseParameterDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            ParameterDeclaration res = this.parser.FormalParameter();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstructorDeclaration parseConstructorDeclaration(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            ConstructorDeclaration res = this.parser.ConstructorDeclaration();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeReference parseTypeReference(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            TypeReference res = this.parser.ResultType();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageReference parsePackageReference(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            PackageReference res = this.parser.Name().toPackageReference();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression parseExpression(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            Expression res = this.parser.Expression();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASTList<Statement> parseStatements(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            ASTList<Statement> res = this.parser.GeneralizedStatements();
            int i = 0;
            while (i < res.size()) {
                this.postWork((ProgramElement)res.get(i), this.parser.getComments());
                ++i;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementBlock parseStatementBlock(Reader in) throws IOException, ParserException {
        JavaCCParser javaCCParser = this.parser;
        synchronized (javaCCParser) {
            this.parser.initialize(in, this);
            StatementBlock res = this.parser.Block();
            this.postWork(res, this.parser.getComments());
            return res;
        }
    }

    @Override
    public CompilationUnit parseCompilationUnit(String in) throws ParserException {
        try {
            return this.parseCompilationUnit(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public List<CompilationUnit> parseCompilationUnits(String[] ins) throws ParserException {
        try {
            ArrayList<CompilationUnit> cus = new ArrayList<CompilationUnit>();
            int i = 0;
            while (i < ins.length) {
                CompilationUnit cu = this.parseCompilationUnit(new FileReader(ins[i]));
                cus.add(cu);
                ++i;
            }
            return cus;
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public TypeDeclaration parseTypeDeclaration(String in) throws ParserException {
        try {
            return this.parseTypeDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public MemberDeclaration parseMemberDeclaration(String in) throws ParserException {
        try {
            return this.parseMemberDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public FieldDeclaration parseFieldDeclaration(String in) throws ParserException {
        try {
            return this.parseFieldDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public MethodDeclaration parseMethodDeclaration(String in) throws ParserException {
        try {
            return this.parseMethodDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ParameterDeclaration parseParameterDeclaration(String in) throws ParserException {
        try {
            return this.parseParameterDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ConstructorDeclaration parseConstructorDeclaration(String in) throws ParserException {
        try {
            return this.parseConstructorDeclaration(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public TypeReference parseTypeReference(String in) throws ParserException {
        try {
            return this.parseTypeReference(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public PackageReference parsePackageReference(String in) throws ParserException {
        try {
            return this.parsePackageReference(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public Expression parseExpression(String in) throws ParserException {
        try {
            return this.parseExpression(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public ASTList<Statement> parseStatements(String in) throws ParserException {
        try {
            return this.parseStatements(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    @Override
    public StatementBlock parseStatementBlock(String in) throws ParserException {
        try {
            return this.parseStatementBlock(new StringReader(in));
        }
        catch (IOException ioe) {
            throw new ParserException("" + ioe);
        }
    }

    public static int parseInt(String nm) throws NumberFormatException {
        int radix;
        boolean negative = false;
        int index = 0;
        if (nm.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        } else {
            radix = 10;
        }
        if (nm.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        int len = nm.length() - index;
        if (radix == 16 && len == 8) {
            char first = nm.charAt(index);
            int result = Integer.valueOf(nm.substring(++index), radix);
            return negative ? -result : (result |= Character.digit(first, 16) << 28);
        }
        if (radix == 8 && len == 11) {
            char first = nm.charAt(index);
            int result = Integer.valueOf(nm.substring(++index), radix);
            return negative ? -result : (result |= Character.digit(first, 8) << 30);
        }
        if (!negative && radix == 10 && len == 10 && nm.indexOf("2147483648", index) == index) {
            return Integer.MIN_VALUE;
        }
        int result = Integer.valueOf(nm.substring(index), radix);
        return negative ? -result : result;
    }

    public static long parseLong(String nm) throws NumberFormatException {
        int radix;
        if (nm.equalsIgnoreCase("0L")) {
            return 0L;
        }
        boolean negative = false;
        int index = 0;
        if (nm.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        } else {
            radix = 10;
        }
        if (nm.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        int endIndex = nm.length();
        if (nm.endsWith("L") || nm.endsWith("l")) {
            --endIndex;
        }
        int len = endIndex - index;
        if (radix == 16 && len == 16) {
            char first = nm.charAt(index);
            long result = Long.valueOf(nm.substring(++index, endIndex), radix);
            return negative ? -result : (result |= (long)Character.digit(first, 16) << 60);
        }
        if (radix == 8 && len == 21) {
            char first = nm.charAt(index);
            long result = Long.valueOf(nm.substring(++index, endIndex), radix);
            return negative ? -result : (result |= (long)(Character.digit(first, 8) << 63));
        }
        if (!negative && radix == 10 && len == 19 && nm.indexOf("9223372036854775808", index) == index) {
            return Long.MIN_VALUE;
        }
        long result = Long.valueOf(nm.substring(index, endIndex), radix);
        return negative ? -result : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toSource(JavaSourceElement jse) {
        StringWriter stringWriter = this.writer;
        synchronized (stringWriter) {
            this.sourcePrinter.setIndentationLevel(0);
            jse.accept(this.sourcePrinter);
            StringBuffer buf = this.writer.getBuffer();
            String str = buf.toString();
            buf.setLength(0);
            return str;
        }
    }

    @Override
    public PrettyPrinter getPrettyPrinter(Writer out) {
        return new PrettyPrinter(out, this.serviceConfiguration.getProjectSettings().getProperties());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.sourcePrinter = new PrettyPrinter(this.writer, this.serviceConfiguration.getProjectSettings().getProperties());
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("jdk1.4")) {
            this.parser.setAwareOfAssert(StringUtils.parseBooleanProperty(evt.getNewValue().toString()));
        }
        if (changedProp.equals("java5")) {
            this.parser.setJava5(StringUtils.parseBooleanProperty(evt.getNewValue().toString()));
        }
        if (changedProp.equals("extra_newline_at_end_of_file")) {
            this.useAddNewlineReader = StringUtils.parseBooleanProperty(evt.getNewValue().toString());
        }
    }

    @Override
    public Comment createComment() {
        Comment res = new Comment();
        res.setFactory(this);
        return res;
    }

    @Override
    public Comment createComment(String text) {
        Comment res = new Comment(text);
        res.setFactory(this);
        return res;
    }

    @Override
    public Comment createComment(String text, boolean prefixed) {
        Comment res = new Comment(text, prefixed);
        res.setFactory(this);
        return res;
    }

    @Override
    public CompilationUnit createCompilationUnit() {
        CompilationUnit res = new CompilationUnit();
        res.setFactory(this);
        return res;
    }

    @Override
    public CompilationUnit createCompilationUnit(PackageSpecification pkg, ASTList<Import> imports, ASTList<TypeDeclaration> typeDeclarations) {
        CompilationUnit res = new CompilationUnit(pkg, imports, typeDeclarations);
        res.setFactory(this);
        return res;
    }

    @Override
    public DocComment createDocComment() {
        DocComment res = new DocComment();
        res.setFactory(this);
        return res;
    }

    @Override
    public DocComment createDocComment(String text) {
        DocComment res = new DocComment(text);
        res.setFactory(this);
        return res;
    }

    @Override
    public Identifier createIdentifier() {
        Identifier res = new Identifier();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Identifier createIdentifier(String text) {
        Identifier res = new Identifier(text);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Import createImport() {
        Import res = new Import();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Import createImport(TypeReference t, boolean multi) {
        Import res = new Import(t, multi);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Import createImport(PackageReference t) {
        Import res = new Import(t);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Import createStaticImport(TypeReference t) {
        Import res = new Import(t, true, true);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Import createStaticImport(TypeReference t, Identifier id) {
        Import res = new Import(t, id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PackageSpecification createPackageSpecification() {
        PackageSpecification res = new PackageSpecification();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PackageSpecification createPackageSpecification(PackageReference pkg) {
        PackageSpecification res = new PackageSpecification(pkg);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SingleLineComment createSingleLineComment() {
        SingleLineComment res = new SingleLineComment();
        res.setFactory(this);
        return res;
    }

    @Override
    public SingleLineComment createSingleLineComment(String text) {
        SingleLineComment res = new SingleLineComment(text);
        res.setFactory(this);
        return res;
    }

    @Override
    public TypeReference createTypeReference() {
        TypeReference res = new TypeReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeReference createTypeReference(Identifier name) {
        TypeReference res = new TypeReference(name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeReference createTypeReference(ReferencePrefix prefix, Identifier name) {
        TypeReference res = new TypeReference(prefix, name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeReference createTypeReference(Identifier name, int dim) {
        TypeReference res = new TypeReference(name, dim);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PackageReference createPackageReference() {
        PackageReference res = new PackageReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PackageReference createPackageReference(Identifier id) {
        PackageReference res = new PackageReference(id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PackageReference createPackageReference(PackageReference path, Identifier id) {
        PackageReference res = new PackageReference(path, id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier() {
        UncollatedReferenceQualifier res = new UncollatedReferenceQualifier();
        res.setFactory(this);
        return res;
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier(Identifier id) {
        UncollatedReferenceQualifier res = new UncollatedReferenceQualifier(id);
        res.setFactory(this);
        return res;
    }

    @Override
    public UncollatedReferenceQualifier createUncollatedReferenceQualifier(ReferencePrefix prefix, Identifier id) {
        UncollatedReferenceQualifier res = new UncollatedReferenceQualifier(prefix, id);
        res.setFactory(this);
        return res;
    }

    @Override
    public ClassDeclaration createClassDeclaration() {
        ClassDeclaration res = new ClassDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ClassDeclaration createClassDeclaration(ASTList<DeclarationSpecifier> declSpecs, Identifier name, Extends extended, Implements implemented, ASTList<MemberDeclaration> members) {
        ClassDeclaration res = new ClassDeclaration(declSpecs, name, extended, implemented, members);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ClassDeclaration createClassDeclaration(ASTList<MemberDeclaration> members) {
        ClassDeclaration res = new ClassDeclaration(members);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeArgumentDeclaration createTypeArgumentDeclaration(TypeReference ref) {
        TypeArgumentDeclaration res = new TypeArgumentDeclaration(ref);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeArgumentDeclaration createTypeArgumentDeclaration(TypeReference ref, TypeArgument.WildcardMode wm) {
        TypeArgumentDeclaration res = new TypeArgumentDeclaration(ref, wm);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeArgumentDeclaration createTypeArgumentDeclaration() {
        TypeArgumentDeclaration res = new TypeArgumentDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeParameterDeclaration createTypeParameterDeclaration() {
        TypeParameterDeclaration res = new TypeParameterDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ClassInitializer createClassInitializer() {
        ClassInitializer res = new ClassInitializer();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ClassInitializer createClassInitializer(StatementBlock body) {
        ClassInitializer res = new ClassInitializer(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ClassInitializer createClassInitializer(Static modifier, StatementBlock body) {
        ClassInitializer res = new ClassInitializer(modifier, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ConstructorDeclaration createConstructorDeclaration() {
        ConstructorDeclaration res = new ConstructorDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ConstructorDeclaration createConstructorDeclaration(VisibilityModifier modifier, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions, StatementBlock body) {
        ConstructorDeclaration res = new ConstructorDeclaration(modifier, name, parameters, exceptions, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Throws createThrows() {
        Throws res = new Throws();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Throws createThrows(TypeReference exception) {
        Throws res = new Throws(exception);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Throws createThrows(ASTList<TypeReference> list) {
        Throws res = new Throws(list);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldDeclaration createFieldDeclaration() {
        FieldDeclaration res = new FieldDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldDeclaration createFieldDeclaration(TypeReference typeRef, Identifier name) {
        FieldDeclaration res = new FieldDeclaration(typeRef, this.createFieldSpecification(name));
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldDeclaration createFieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        FieldDeclaration res = new FieldDeclaration(mods, typeRef, this.createFieldSpecification(name, init));
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldDeclaration createFieldDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<FieldSpecification> vars) {
        FieldDeclaration res = new FieldDeclaration(mods, typeRef, vars);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Extends createExtends() {
        Extends res = new Extends();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Extends createExtends(TypeReference supertype) {
        Extends res = new Extends(supertype);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Extends createExtends(ASTList<TypeReference> list) {
        Extends res = new Extends(list);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Implements createImplements() {
        Implements res = new Implements();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Implements createImplements(TypeReference supertype) {
        Implements res = new Implements(supertype);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Implements createImplements(ASTList<TypeReference> list) {
        Implements res = new Implements(list);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public InterfaceDeclaration createInterfaceDeclaration() {
        InterfaceDeclaration res = new InterfaceDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public InterfaceDeclaration createInterfaceDeclaration(ASTList<DeclarationSpecifier> modifiers, Identifier name, Extends extended, ASTList<MemberDeclaration> members) {
        InterfaceDeclaration res = new InterfaceDeclaration(modifiers, name, extended, members);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationDeclaration createAnnotationDeclaration() {
        AnnotationDeclaration res = new AnnotationDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationDeclaration createAnnotationDeclaration(ASTList<DeclarationSpecifier> modifiers, Identifier name, ASTList<MemberDeclaration> members) {
        AnnotationDeclaration res = new AnnotationDeclaration(modifiers, name, members);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration() {
        LocalVariableDeclaration res = new LocalVariableDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(TypeReference typeRef, Identifier name) {
        VariableSpecification varSpec = this.createVariableSpecification(name);
        LocalVariableDeclaration res = new LocalVariableDeclaration(null, typeRef, varSpec);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, ASTList<VariableSpecification> vars) {
        LocalVariableDeclaration res = new LocalVariableDeclaration(mods, typeRef, vars);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LocalVariableDeclaration createLocalVariableDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name, Expression init) {
        LocalVariableDeclaration res = new LocalVariableDeclaration(mods, typeRef, this.createVariableSpecification(name, init));
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodDeclaration createMethodDeclaration() {
        MethodDeclaration res = new MethodDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodDeclaration createMethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions) {
        MethodDeclaration res = new MethodDeclaration(modifiers, returnType, name, parameters, exceptions);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodDeclaration createMethodDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, ASTList<ParameterDeclaration> parameters, Throws exceptions, StatementBlock body) {
        MethodDeclaration res = new MethodDeclaration(modifiers, returnType, name, parameters, exceptions, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationPropertyDeclaration createAnnotationPropertyDeclaration(ASTList<DeclarationSpecifier> modifiers, TypeReference returnType, Identifier name, Expression defaultValue) {
        AnnotationPropertyDeclaration res = new AnnotationPropertyDeclaration(modifiers, returnType, name, defaultValue);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ParameterDeclaration createParameterDeclaration() {
        ParameterDeclaration res = new ParameterDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ParameterDeclaration createParameterDeclaration(TypeReference typeRef, Identifier name) {
        ParameterDeclaration res = new ParameterDeclaration(typeRef, this.createVariableSpecification(name));
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ParameterDeclaration createParameterDeclaration(ASTList<DeclarationSpecifier> mods, TypeReference typeRef, Identifier name) {
        ParameterDeclaration res = new ParameterDeclaration(typeRef, this.createVariableSpecification(name));
        res.setDeclarationSpecifiers(mods);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableSpecification createVariableSpecification() {
        VariableSpecification res = new VariableSpecification();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name) {
        VariableSpecification res = new VariableSpecification(name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name, Expression init) {
        VariableSpecification res = new VariableSpecification(name, init);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableSpecification createVariableSpecification(Identifier name, int dimensions, Expression init) {
        VariableSpecification res = new VariableSpecification(name, dimensions, init);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldSpecification createFieldSpecification() {
        FieldSpecification res = new FieldSpecification();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name) {
        FieldSpecification res = new FieldSpecification(name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name, Expression init) {
        FieldSpecification res = new FieldSpecification(name, init);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldSpecification createFieldSpecification(Identifier name, int dimensions, Expression init) {
        FieldSpecification res = new FieldSpecification(name, dimensions, init);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ArrayInitializer createArrayInitializer() {
        ArrayInitializer res = new ArrayInitializer();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ArrayInitializer createArrayInitializer(ASTList<Expression> args) {
        ArrayInitializer res = new ArrayInitializer(args);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ParenthesizedExpression createParenthesizedExpression() {
        ParenthesizedExpression res = new ParenthesizedExpression();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ParenthesizedExpression createParenthesizedExpression(Expression child) {
        ParenthesizedExpression res = new ParenthesizedExpression(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BooleanLiteral createBooleanLiteral() {
        BooleanLiteral res = new BooleanLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BooleanLiteral createBooleanLiteral(boolean value) {
        BooleanLiteral res = new BooleanLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public CharLiteral createCharLiteral() {
        CharLiteral res = new CharLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public CharLiteral createCharLiteral(char value) {
        CharLiteral res = new CharLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public CharLiteral createCharLiteral(String value) {
        CharLiteral res = new CharLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public DoubleLiteral createDoubleLiteral() {
        DoubleLiteral res = new DoubleLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public DoubleLiteral createDoubleLiteral(double value) {
        DoubleLiteral res = new DoubleLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public DoubleLiteral createDoubleLiteral(String value) {
        DoubleLiteral res = new DoubleLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FloatLiteral createFloatLiteral() {
        FloatLiteral res = new FloatLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FloatLiteral createFloatLiteral(float value) {
        FloatLiteral res = new FloatLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FloatLiteral createFloatLiteral(String value) {
        FloatLiteral res = new FloatLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public IntLiteral createIntLiteral() {
        IntLiteral res = new IntLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public IntLiteral createIntLiteral(int value) {
        IntLiteral res = new IntLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public IntLiteral createIntLiteral(String value) {
        IntLiteral res = new IntLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LongLiteral createLongLiteral() {
        LongLiteral res = new LongLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LongLiteral createLongLiteral(long value) {
        LongLiteral res = new LongLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LongLiteral createLongLiteral(String value) {
        LongLiteral res = new LongLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NullLiteral createNullLiteral() {
        NullLiteral res = new NullLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public StringLiteral createStringLiteral() {
        StringLiteral res = new StringLiteral();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public StringLiteral createStringLiteral(String value) {
        StringLiteral res = new StringLiteral(value);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ArrayReference createArrayReference() {
        ArrayReference res = new ArrayReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ArrayReference createArrayReference(ReferencePrefix accessPath, ASTList<Expression> initializers) {
        ArrayReference res = new ArrayReference(accessPath, initializers);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldReference createFieldReference() {
        FieldReference res = new FieldReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldReference createFieldReference(Identifier id) {
        FieldReference res = new FieldReference(id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public FieldReference createFieldReference(ReferencePrefix prefix, Identifier id) {
        FieldReference res = new FieldReference(prefix, id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MetaClassReference createMetaClassReference() {
        MetaClassReference res = new MetaClassReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MetaClassReference createMetaClassReference(TypeReference reference) {
        MetaClassReference res = new MetaClassReference(reference);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference() {
        MethodReference res = new MethodReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference(Identifier name) {
        MethodReference res = new MethodReference(name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name) {
        MethodReference res = new MethodReference(accessPath, name);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference(Identifier name, ASTList<Expression> args) {
        MethodReference res = new MethodReference(name, args);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args) {
        MethodReference res = new MethodReference(accessPath, name, args);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MethodReference createMethodReference(ReferencePrefix accessPath, Identifier name, ASTList<Expression> args, ASTList<TypeArgumentDeclaration> typeArgs) {
        MethodReference res = new MethodReference(accessPath, name, args, typeArgs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationPropertyReference createAnnotationPropertyReference(String id) {
        Identifier ident = this.createIdentifier(id);
        ident.setFactory(this);
        AnnotationPropertyReference res = new AnnotationPropertyReference(ident);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationPropertyReference createAnnotationPropertyReference(Identifier id) {
        AnnotationPropertyReference res = new AnnotationPropertyReference(id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference() {
        SuperConstructorReference res = new SuperConstructorReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference(ASTList<Expression> arguments) {
        SuperConstructorReference res = new SuperConstructorReference(arguments);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SuperConstructorReference createSuperConstructorReference(ReferencePrefix path, ASTList<Expression> arguments) {
        SuperConstructorReference res = new SuperConstructorReference(path, arguments);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SuperReference createSuperReference() {
        SuperReference res = new SuperReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SuperReference createSuperReference(ReferencePrefix accessPath) {
        SuperReference res = new SuperReference(accessPath);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ThisConstructorReference createThisConstructorReference() {
        ThisConstructorReference res = new ThisConstructorReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ThisConstructorReference createThisConstructorReference(ASTList<Expression> arguments) {
        ThisConstructorReference res = new ThisConstructorReference(arguments);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ThisReference createThisReference() {
        ThisReference res = new ThisReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ThisReference createThisReference(TypeReference outer) {
        ThisReference res = new ThisReference(outer);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableReference createVariableReference() {
        VariableReference res = new VariableReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public VariableReference createVariableReference(Identifier id) {
        VariableReference res = new VariableReference(id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryAnd createBinaryAnd() {
        BinaryAnd res = new BinaryAnd();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryAnd createBinaryAnd(Expression lhs, Expression rhs) {
        BinaryAnd res = new BinaryAnd(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryAndAssignment createBinaryAndAssignment() {
        BinaryAndAssignment res = new BinaryAndAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryAndAssignment createBinaryAndAssignment(Expression lhs, Expression rhs) {
        BinaryAndAssignment res = new BinaryAndAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryNot createBinaryNot() {
        BinaryNot res = new BinaryNot();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryNot createBinaryNot(Expression child) {
        BinaryNot res = new BinaryNot(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryOr createBinaryOr() {
        BinaryOr res = new BinaryOr();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryOr createBinaryOr(Expression lhs, Expression rhs) {
        BinaryOr res = new BinaryOr(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryOrAssignment createBinaryOrAssignment() {
        BinaryOrAssignment res = new BinaryOrAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryOrAssignment createBinaryOrAssignment(Expression lhs, Expression rhs) {
        BinaryOrAssignment res = new BinaryOrAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryXOr createBinaryXOr() {
        BinaryXOr res = new BinaryXOr();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryXOr createBinaryXOr(Expression lhs, Expression rhs) {
        BinaryXOr res = new BinaryXOr(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryXOrAssignment createBinaryXOrAssignment() {
        BinaryXOrAssignment res = new BinaryXOrAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public BinaryXOrAssignment createBinaryXOrAssignment(Expression lhs, Expression rhs) {
        BinaryXOrAssignment res = new BinaryXOrAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Conditional createConditional() {
        Conditional res = new Conditional();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Conditional createConditional(Expression guard, Expression thenExpr, Expression elseExpr) {
        Conditional res = new Conditional(guard, thenExpr, elseExpr);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public CopyAssignment createCopyAssignment() {
        CopyAssignment res = new CopyAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public CopyAssignment createCopyAssignment(Expression lhs, Expression rhs) {
        CopyAssignment res = new CopyAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Divide createDivide() {
        Divide res = new Divide();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Divide createDivide(Expression lhs, Expression rhs) {
        Divide res = new Divide(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public DivideAssignment createDivideAssignment() {
        DivideAssignment res = new DivideAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public DivideAssignment createDivideAssignment(Expression lhs, Expression rhs) {
        DivideAssignment res = new DivideAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Equals createEquals() {
        Equals res = new Equals();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Equals createEquals(Expression lhs, Expression rhs) {
        Equals res = new Equals(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public GreaterOrEquals createGreaterOrEquals() {
        GreaterOrEquals res = new GreaterOrEquals();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public GreaterOrEquals createGreaterOrEquals(Expression lhs, Expression rhs) {
        GreaterOrEquals res = new GreaterOrEquals(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public GreaterThan createGreaterThan() {
        GreaterThan res = new GreaterThan();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public GreaterThan createGreaterThan(Expression lhs, Expression rhs) {
        GreaterThan res = new GreaterThan(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Instanceof createInstanceof() {
        Instanceof res = new Instanceof();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Instanceof createInstanceof(Expression child, TypeReference typeref) {
        Instanceof res = new Instanceof(child, typeref);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LessOrEquals createLessOrEquals() {
        LessOrEquals res = new LessOrEquals();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LessOrEquals createLessOrEquals(Expression lhs, Expression rhs) {
        LessOrEquals res = new LessOrEquals(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LessThan createLessThan() {
        LessThan res = new LessThan();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LessThan createLessThan(Expression lhs, Expression rhs) {
        LessThan res = new LessThan(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalAnd createLogicalAnd() {
        LogicalAnd res = new LogicalAnd();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalAnd createLogicalAnd(Expression lhs, Expression rhs) {
        LogicalAnd res = new LogicalAnd(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalNot createLogicalNot() {
        LogicalNot res = new LogicalNot();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalNot createLogicalNot(Expression child) {
        LogicalNot res = new LogicalNot(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalOr createLogicalOr() {
        LogicalOr res = new LogicalOr();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LogicalOr createLogicalOr(Expression lhs, Expression rhs) {
        LogicalOr res = new LogicalOr(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Minus createMinus() {
        Minus res = new Minus();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Minus createMinus(Expression lhs, Expression rhs) {
        Minus res = new Minus(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MinusAssignment createMinusAssignment() {
        MinusAssignment res = new MinusAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public MinusAssignment createMinusAssignment(Expression lhs, Expression rhs) {
        MinusAssignment res = new MinusAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Modulo createModulo() {
        Modulo res = new Modulo();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Modulo createModulo(Expression lhs, Expression rhs) {
        Modulo res = new Modulo(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ModuloAssignment createModuloAssignment() {
        ModuloAssignment res = new ModuloAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ModuloAssignment createModuloAssignment(Expression lhs, Expression rhs) {
        ModuloAssignment res = new ModuloAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Negative createNegative() {
        Negative res = new Negative();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Negative createNegative(Expression child) {
        Negative res = new Negative(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public New createNew() {
        New res = new New();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public New createNew(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments) {
        New res = new New(accessPath, constructorName, arguments);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public New createNew(ReferencePrefix accessPath, TypeReference constructorName, ASTList<Expression> arguments, ClassDeclaration anonymousClass) {
        New res = new New(accessPath, constructorName, arguments, anonymousClass);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NewArray createNewArray() {
        NewArray res = new NewArray();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NewArray createNewArray(TypeReference arrayName, ASTList<Expression> dimExpr) {
        NewArray res = new NewArray(arrayName, dimExpr);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NewArray createNewArray(TypeReference arrayName, int dimensions, ArrayInitializer initializer) {
        NewArray res = new NewArray(arrayName, dimensions, initializer);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NotEquals createNotEquals() {
        NotEquals res = new NotEquals();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public NotEquals createNotEquals(Expression lhs, Expression rhs) {
        NotEquals res = new NotEquals(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Plus createPlus() {
        Plus res = new Plus();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Plus createPlus(Expression lhs, Expression rhs) {
        Plus res = new Plus(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PlusAssignment createPlusAssignment() {
        PlusAssignment res = new PlusAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PlusAssignment createPlusAssignment(Expression lhs, Expression rhs) {
        PlusAssignment res = new PlusAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Positive createPositive() {
        Positive res = new Positive();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Positive createPositive(Expression child) {
        Positive res = new Positive(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PostDecrement createPostDecrement() {
        PostDecrement res = new PostDecrement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PostDecrement createPostDecrement(Expression child) {
        PostDecrement res = new PostDecrement(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PostIncrement createPostIncrement() {
        PostIncrement res = new PostIncrement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PostIncrement createPostIncrement(Expression child) {
        PostIncrement res = new PostIncrement(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PreDecrement createPreDecrement() {
        PreDecrement res = new PreDecrement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PreDecrement createPreDecrement(Expression child) {
        PreDecrement res = new PreDecrement(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PreIncrement createPreIncrement() {
        PreIncrement res = new PreIncrement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public PreIncrement createPreIncrement(Expression child) {
        PreIncrement res = new PreIncrement(child);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftLeft createShiftLeft() {
        ShiftLeft res = new ShiftLeft();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftLeft createShiftLeft(Expression lhs, Expression rhs) {
        ShiftLeft res = new ShiftLeft(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftLeftAssignment createShiftLeftAssignment() {
        ShiftLeftAssignment res = new ShiftLeftAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftLeftAssignment createShiftLeftAssignment(Expression lhs, Expression rhs) {
        ShiftLeftAssignment res = new ShiftLeftAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftRight createShiftRight() {
        ShiftRight res = new ShiftRight();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftRight createShiftRight(Expression lhs, Expression rhs) {
        ShiftRight res = new ShiftRight(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftRightAssignment createShiftRightAssignment() {
        ShiftRightAssignment res = new ShiftRightAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public ShiftRightAssignment createShiftRightAssignment(Expression lhs, Expression rhs) {
        ShiftRightAssignment res = new ShiftRightAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Times createTimes() {
        Times res = new Times();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Times createTimes(Expression lhs, Expression rhs) {
        Times res = new Times(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TimesAssignment createTimesAssignment() {
        TimesAssignment res = new TimesAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TimesAssignment createTimesAssignment(Expression lhs, Expression rhs) {
        TimesAssignment res = new TimesAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeCast createTypeCast() {
        TypeCast res = new TypeCast();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public TypeCast createTypeCast(Expression child, TypeReference typeref) {
        TypeCast res = new TypeCast(child, typeref);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public UnsignedShiftRight createUnsignedShiftRight() {
        UnsignedShiftRight res = new UnsignedShiftRight();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public UnsignedShiftRight createUnsignedShiftRight(Expression lhs, Expression rhs) {
        UnsignedShiftRight res = new UnsignedShiftRight(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public UnsignedShiftRightAssignment createUnsignedShiftRightAssignment() {
        UnsignedShiftRightAssignment res = new UnsignedShiftRightAssignment();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public UnsignedShiftRightAssignment createUnsignedShiftRightAssignment(Expression lhs, Expression rhs) {
        UnsignedShiftRightAssignment res = new UnsignedShiftRightAssignment(lhs, rhs);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Abstract createAbstract() {
        Abstract res = new Abstract();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Final createFinal() {
        Final res = new Final();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Native createNative() {
        Native res = new Native();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Private createPrivate() {
        Private res = new Private();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Protected createProtected() {
        Protected res = new Protected();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Public createPublic() {
        Public res = new Public();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Static createStatic() {
        Static res = new Static();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Synchronized createSynchronized() {
        Synchronized res = new Synchronized();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Transient createTransient() {
        Transient res = new Transient();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public StrictFp createStrictFp() {
        StrictFp res = new StrictFp();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Volatile createVolatile() {
        Volatile res = new Volatile();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public AnnotationUseSpecification createAnnotationUseSpecification() {
        AnnotationUseSpecification res = new AnnotationUseSpecification();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public AnnotationElementValuePair createAnnotationElementValuePair(AnnotationPropertyReference ref, Expression e) {
        AnnotationElementValuePair res = new AnnotationElementValuePair(ref, e);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public ElementValueArrayInitializer createElementValueArrayInitializer() {
        ElementValueArrayInitializer res = new ElementValueArrayInitializer();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Break createBreak() {
        Break res = new Break();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Break createBreak(Identifier label) {
        Break res = new Break(label);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Case createCase() {
        Case res = new Case();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Case createCase(Expression e) {
        Case res = new Case(e);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Case createCase(Expression e, ASTList<Statement> body) {
        Case res = new Case(e, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Catch createCatch() {
        Catch res = new Catch();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Catch createCatch(ParameterDeclaration e, StatementBlock body) {
        Catch res = new Catch(e, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Continue createContinue() {
        Continue res = new Continue();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Continue createContinue(Identifier label) {
        Continue res = new Continue(label);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Default createDefault() {
        Default res = new Default();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Default createDefault(ASTList<Statement> body) {
        Default res = new Default(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Do createDo() {
        Do res = new Do();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Do createDo(Expression guard) {
        Do res = new Do(guard);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Do createDo(Expression guard, Statement body) {
        Do res = new Do(guard, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Else createElse() {
        Else res = new Else();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Else createElse(Statement body) {
        Else res = new Else(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public EmptyStatement createEmptyStatement() {
        EmptyStatement res = new EmptyStatement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Finally createFinally() {
        Finally res = new Finally();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Finally createFinally(StatementBlock body) {
        Finally res = new Finally(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public For createFor() {
        For res = new For();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public For createFor(ASTList<LoopInitializer> inits, Expression guard, ASTList<Expression> updates, Statement body) {
        For res = new For(inits, guard, updates, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public EnhancedFor createEnhancedFor() {
        EnhancedFor res = new EnhancedFor();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public EnumDeclaration createEnumDeclaration() {
        EnumDeclaration res = new EnumDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public EnumConstructorReference createEnumConstructorReference() {
        EnumConstructorReference res = new EnumConstructorReference();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public EnumConstructorReference createEnumConstructorReference(ASTList<Expression> args, ClassDeclaration cd) {
        EnumConstructorReference res = new EnumConstructorReference(args, cd);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public EnumConstantSpecification createEnumConstantSpecification(Identifier id, EnumConstructorReference ref) {
        EnumConstantSpecification res = new EnumConstantSpecification(id, ref);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    public EnumConstantDeclaration createEnumConstantDeclaration() {
        EnumConstantDeclaration res = new EnumConstantDeclaration();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Assert createAssert() {
        Assert res = new Assert();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Assert createAssert(Expression cond) {
        Assert res = new Assert(cond);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Assert createAssert(Expression cond, Expression msg) {
        Assert res = new Assert(cond, msg);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public If createIf() {
        If res = new If();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public If createIf(Expression e, Statement thenStatement) {
        If res = new If(e, thenStatement);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public If createIf(Expression e, Then thenBranch) {
        If res = new If(e, thenBranch);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public If createIf(Expression e, Then thenBranch, Else elseBranch) {
        If res = new If(e, thenBranch, elseBranch);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public If createIf(Expression e, Statement thenStatement, Statement elseStatement) {
        If res = new If(e, thenStatement, elseStatement);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LabeledStatement createLabeledStatement() {
        LabeledStatement res = new LabeledStatement();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LabeledStatement createLabeledStatement(Identifier id) {
        LabeledStatement res = new LabeledStatement(id);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public LabeledStatement createLabeledStatement(Identifier id, Statement statement) {
        LabeledStatement res = new LabeledStatement(id, statement);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Return createReturn() {
        Return res = new Return();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Return createReturn(Expression expr) {
        Return res = new Return(expr);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public StatementBlock createStatementBlock() {
        StatementBlock res = new StatementBlock();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public StatementBlock createStatementBlock(ASTList<Statement> block) {
        StatementBlock res = new StatementBlock(block);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Switch createSwitch() {
        Switch res = new Switch();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Switch createSwitch(Expression e) {
        Switch res = new Switch(e);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Switch createSwitch(Expression e, ASTList<Branch> branches) {
        Switch res = new Switch(e, branches);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock() {
        SynchronizedBlock res = new SynchronizedBlock();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock(StatementBlock body) {
        SynchronizedBlock res = new SynchronizedBlock(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public SynchronizedBlock createSynchronizedBlock(Expression e, StatementBlock body) {
        SynchronizedBlock res = new SynchronizedBlock(e, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Then createThen() {
        Then res = new Then();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Then createThen(Statement body) {
        Then res = new Then(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Throw createThrow() {
        Throw res = new Throw();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Throw createThrow(Expression expr) {
        Throw res = new Throw(expr);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Try createTry() {
        Try res = new Try();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Try createTry(StatementBlock body) {
        Try res = new Try(body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public Try createTry(StatementBlock body, ASTList<Branch> branches) {
        Try res = new Try(body, branches);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public While createWhile() {
        While res = new While();
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public While createWhile(Expression guard) {
        While res = new While(guard);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    @Override
    public While createWhile(Expression guard, Statement body) {
        While res = new While(guard, body);
        res.setFactory(this);
        this.trace(res);
        return res;
    }

    private class AddNewlineReader
    extends Reader {
        private Reader reader;
        private boolean added = false;

        AddNewlineReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.reader.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.reader.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.reader.read(cbuf);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.reader.read(target);
        }

        @Override
        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.reader.skip(n);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.added) {
                return -1;
            }
            int result = this.reader.read(cbuf, off, len);
            if (!this.added && result < len) {
                if (result == -1) {
                    // empty if block
                }
                int n = ++result;
                ++result;
                cbuf[off + n] = 10;
                this.added = true;
            }
            return result;
        }
    }

    public static class TraceItem {
        public final ProgramElement pe;
        public final String st;

        public TraceItem(ProgramElement pe) {
            this.pe = pe;
            StackTraceElement[] ste = new Throwable().getStackTrace();
            int startIdx = 3;
            while (ste[startIdx].toString().indexOf("<init>") != -1 || ste[startIdx].toString().indexOf(".deepClone(") != -1) {
                ++startIdx;
            }
            this.st = "\t" + ste[startIdx + 0] + "\n\t" + ste[startIdx + 1] + "\n\t" + ste[startIdx + 2];
        }

        public boolean equals(Object o) {
            if (o == this.pe) {
                return true;
            }
            if (!(o instanceof TraceItem)) {
                return false;
            }
            return ((TraceItem)o).pe == this.pe;
        }

        public int hashCode() {
            return this.pe.hashCode();
        }

        public String toString() {
            return String.valueOf(this.pe.toString()) + "\n" + this.st;
        }
    }
}

