/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import recoder.java.CompilationUnit;
import recoder.java.Identifier;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.reference.PackageReference;
import recoder.java.reference.PackageReferenceContainer;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.TypeReferenceInfix;
import recoder.java.reference.UncollatedReferenceQualifier;

public class Import
extends JavaNonTerminalProgramElement
implements TypeReferenceContainer,
PackageReferenceContainer {
    private static final long serialVersionUID = -722260309045817264L;
    private boolean isMultiImport;
    private boolean isStaticImport;
    private CompilationUnit parent;
    private TypeReferenceInfix reference;
    private Identifier staticIdentifier;

    public Import() {
    }

    public Import(TypeReference t, boolean multi) {
        this.setReference(t);
        this.setMultiImport(multi);
        this.makeParentRoleValid();
    }

    public Import(TypeReference t, Identifier id) {
        this.setReference(t);
        this.setStaticIdentifier(id);
        this.setMultiImport(false);
        this.setStaticImport(true);
        this.makeParentRoleValid();
    }

    public Import(TypeReference t, boolean multi, boolean isStatic) {
        this.setReference(t);
        this.setMultiImport(multi);
        this.setStaticImport(isStatic);
        this.makeParentRoleValid();
    }

    public Import(PackageReference t) {
        this.setReference(t);
        this.setMultiImport(true);
        this.setStaticImport(false);
        this.makeParentRoleValid();
    }

    protected Import(Import proto) {
        super(proto);
        if (proto.reference != null) {
            this.reference = (TypeReferenceInfix)proto.reference.deepClone();
        }
        if (proto.staticIdentifier != null) {
            this.staticIdentifier = proto.staticIdentifier.deepClone();
        }
        this.isMultiImport = proto.isMultiImport;
        this.isStaticImport = proto.isStaticImport;
        this.makeParentRoleValid();
    }

    @Override
    public void makeParentRoleValid() {
        super.makeParentRoleValid();
        if (this.staticIdentifier != null) {
            this.staticIdentifier.setParent(this);
        }
        if (this.reference instanceof TypeReference) {
            ((TypeReference)this.reference).setParent(this);
        } else if (this.reference instanceof PackageReference) {
            ((PackageReference)this.reference).setParent(this);
        } else if (this.reference instanceof UncollatedReferenceQualifier) {
            ((UncollatedReferenceQualifier)this.reference).setParent(this);
        } else {
            throw new IllegalStateException("Unknown reference type encountered");
        }
    }

    @Override
    public Import deepClone() {
        return new Import(this);
    }

    @Override
    public SourceElement getLastElement() {
        return this.reference.getLastElement();
    }

    public boolean isMultiImport() {
        return this.isMultiImport;
    }

    public boolean isStaticImport() {
        return this.isStaticImport;
    }

    public void setMultiImport(boolean multi) {
        if (!multi && this.reference instanceof PackageReference) {
            throw new IllegalArgumentException("Package imports are always multi");
        }
        this.isMultiImport = multi;
    }

    public void setStaticImport(boolean isStatic) {
        this.isStaticImport = isStatic;
    }

    public void setStaticIdentifier(Identifier id) {
        this.staticIdentifier = id;
    }

    public Identifier getStaticIdentifier() {
        return this.staticIdentifier;
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.reference != null) {
            ++result;
        }
        if (this.staticIdentifier != null) {
            ++result;
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.reference != null) {
            if (index == 0) {
                return this.reference;
            }
            --index;
        }
        if (index == 0 && this.staticIdentifier != null) {
            return this.staticIdentifier;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        if (child == this.reference) {
            return 0;
        }
        if (child == this.staticIdentifier) {
            return 1;
        }
        return -1;
    }

    public CompilationUnit getParent() {
        return this.parent;
    }

    public void setParent(CompilationUnit u) {
        this.parent = u;
    }

    @Override
    public int getTypeReferenceCount() {
        return this.reference instanceof TypeReference ? 1 : 0;
    }

    @Override
    public TypeReference getTypeReferenceAt(int index) {
        if (this.reference instanceof TypeReference && index == 0) {
            return (TypeReference)this.reference;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public TypeReference getTypeReference() {
        return this.reference instanceof TypeReference ? (TypeReference)this.reference : null;
    }

    @Override
    public PackageReference getPackageReference() {
        return this.reference instanceof PackageReference ? (PackageReference)this.reference : null;
    }

    public TypeReferenceInfix getReference() {
        return this.reference;
    }

    public void setReference(TypeReferenceInfix t) {
        this.reference = t;
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.reference == p) {
            TypeReferenceInfix r;
            this.reference = r = (TypeReferenceInfix)q;
            if (r instanceof TypeReference) {
                ((TypeReference)r).setParent(this);
            } else if (r instanceof PackageReference) {
                ((PackageReference)r).setParent(this);
                this.isMultiImport = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitImport(this);
    }

    public String toString() {
        return "<Import" + (this.isStaticImport ? " static" : "") + "> " + this.reference.getName() + (this.isMultiImport ? ".*" : "");
    }
}

