/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import recoder.java.JavaProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.SourceVisitor;
import recoder.java.TerminalProgramElement;

public final class Identifier
extends JavaProgramElement
implements TerminalProgramElement {
    private static final long serialVersionUID = 4261793022531143013L;
    private NonTerminalProgramElement parent;
    private final String id;

    public Identifier() {
        this.id = "";
    }

    public Identifier(String text) {
        if (!Character.isJavaIdentifierStart(text.charAt(0))) {
            throw new IllegalArgumentException(String.valueOf(text) + " is not a valid Java identifier");
        }
        int i = text.length() - 1;
        while (i >= 1) {
            if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                throw new IllegalArgumentException(String.valueOf(text) + " is not a valid Java identifier");
            }
            --i;
        }
        this.id = text.intern();
    }

    protected Identifier(Identifier proto) {
        super(proto);
        this.id = proto.id;
    }

    @Override
    public Identifier deepClone() {
        return new Identifier(this);
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return this.parent;
    }

    public NonTerminalProgramElement getParent() {
        return this.parent;
    }

    public void setParent(NonTerminalProgramElement p) {
        this.parent = p;
    }

    public final String getText() {
        return this.id;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitIdentifier(this);
    }

    public String toString() {
        return "<Identifier> " + this.id;
    }
}

