/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.abstraction.ClassType;
import recoder.io.DataLocation;
import recoder.java.Import;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.SourceVisitor;
import recoder.java.TypeScope;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.list.generic.ASTList;
import recoder.util.Debug;

public class CompilationUnit
extends JavaNonTerminalProgramElement
implements TypeDeclarationContainer,
TypeScope {
    private static final long serialVersionUID = -1511486506045179278L;
    private DataLocation location;
    private DataLocation originalLocation;
    private PackageSpecification packageSpec;
    private ASTList<Import> imports;
    private ASTList<TypeDeclaration> typeDeclarations;
    private static final Map<String, ClassType> UNDEFINED_SCOPE = new HashMap<String, ClassType>(0);
    private Map<String, ClassType> name2type = UNDEFINED_SCOPE;

    public CompilationUnit() {
        this.makeParentRoleValid();
    }

    public CompilationUnit(PackageSpecification pkg, ASTList<Import> imports, ASTList<TypeDeclaration> typeDeclarations) {
        this.setPackageSpecification(pkg);
        this.setImports(imports);
        this.setDeclarations(typeDeclarations);
        this.makeParentRoleValid();
    }

    protected CompilationUnit(CompilationUnit proto) {
        super(proto);
        if (proto.packageSpec != null) {
            this.packageSpec = proto.packageSpec.deepClone();
        }
        if (proto.imports != null) {
            this.imports = proto.imports.deepClone();
        }
        if (proto.typeDeclarations != null) {
            this.typeDeclarations = proto.typeDeclarations.deepClone();
        }
        this.makeParentRoleValid();
    }

    @Override
    public CompilationUnit deepClone() {
        return new CompilationUnit(this);
    }

    @Override
    public void makeParentRoleValid() {
        int i;
        super.makeParentRoleValid();
        if (this.packageSpec != null) {
            this.packageSpec.setParent(this);
        }
        if (this.imports != null) {
            i = this.imports.size() - 1;
            while (i >= 0) {
                ((Import)this.imports.get(i)).setParent(this);
                --i;
            }
        }
        if (this.typeDeclarations != null) {
            i = this.typeDeclarations.size() - 1;
            while (i >= 0) {
                ((TypeDeclaration)this.typeDeclarations.get(i)).setParent(this);
                --i;
            }
        }
    }

    @Override
    public boolean replaceChild(ProgramElement p, ProgramElement q) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.packageSpec == p) {
            PackageSpecification r;
            this.packageSpec = r = (PackageSpecification)q;
            if (r != null) {
                r.setParent(this);
            }
            return true;
        }
        int count = this.imports == null ? 0 : this.imports.size();
        int i = 0;
        while (i < count) {
            if (this.imports.get(i) == p) {
                if (q == null) {
                    this.imports.remove(i);
                } else {
                    Import r = (Import)q;
                    this.imports.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        count = this.typeDeclarations == null ? 0 : this.typeDeclarations.size();
        i = 0;
        while (i < count) {
            if (this.typeDeclarations.get(i) == p) {
                if (q == null) {
                    this.typeDeclarations.remove(i);
                } else {
                    TypeDeclaration r = (TypeDeclaration)q;
                    this.typeDeclarations.set(i, r);
                    r.setParent(this);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public SourceElement getFirstElement() {
        return this.getChildCount() > 0 ? this.getChildAt(0).getFirstElement() : this;
    }

    @Override
    public SourceElement getLastElement() {
        return this.typeDeclarations != null && !this.typeDeclarations.isEmpty() ? ((TypeDeclaration)this.typeDeclarations.get(this.typeDeclarations.size() - 1)).getLastElement() : this;
    }

    public String getName() {
        return this.location == null ? "" : this.location.toString();
    }

    @Override
    public NonTerminalProgramElement getASTParent() {
        return null;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.packageSpec != null) {
            ++result;
        }
        if (this.imports != null) {
            result += this.imports.size();
        }
        if (this.typeDeclarations != null) {
            result += this.typeDeclarations.size();
        }
        return result;
    }

    @Override
    public ProgramElement getChildAt(int index) {
        if (this.packageSpec != null) {
            if (index == 0) {
                return this.packageSpec;
            }
            --index;
        }
        if (this.imports != null) {
            int len = this.imports.size();
            if (len > index) {
                return (ProgramElement)this.imports.get(index);
            }
            index -= len;
        }
        if (this.typeDeclarations != null) {
            return (ProgramElement)this.typeDeclarations.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getChildPositionCode(ProgramElement child) {
        int index;
        if (child == this.packageSpec) {
            return 0;
        }
        if (this.imports != null && (index = this.imports.indexOf(child)) >= 0) {
            return index << 4 | 1;
        }
        if (this.typeDeclarations != null && (index = this.typeDeclarations.indexOf(child)) >= 0) {
            return index << 4 | 2;
        }
        return -1;
    }

    public DataLocation getDataLocation() {
        return this.location;
    }

    public void setDataLocation(DataLocation location) {
        if (this.location == null) {
            this.originalLocation = location;
        }
        this.location = location;
    }

    public DataLocation getOriginalDataLocation() {
        return this.originalLocation;
    }

    public ASTList<Import> getImports() {
        return this.imports;
    }

    public void setImports(ASTList<Import> list) {
        this.imports = list;
    }

    public PackageSpecification getPackageSpecification() {
        return this.packageSpec;
    }

    public void setPackageSpecification(PackageSpecification p) {
        this.packageSpec = p;
    }

    @Override
    public int getTypeDeclarationCount() {
        return this.typeDeclarations != null ? this.typeDeclarations.size() : 0;
    }

    @Override
    public TypeDeclaration getTypeDeclarationAt(int index) {
        if (this.typeDeclarations != null) {
            return (TypeDeclaration)this.typeDeclarations.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public ASTList<TypeDeclaration> getDeclarations() {
        return this.typeDeclarations;
    }

    public void setDeclarations(ASTList<TypeDeclaration> list) {
        this.typeDeclarations = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeDeclaration getPrimaryTypeDeclaration() {
        TypeDeclaration res = null;
        int s = this.typeDeclarations.size();
        int i = 0;
        while (i < s) {
            TypeDeclaration t = (TypeDeclaration)this.typeDeclarations.get(i);
            if (t.isPublic()) {
                if (res != null) {
                    if (res.isPublic()) return null;
                }
                res = t;
            } else if (res == null) {
                res = t;
            }
            ++i;
        }
        return res;
    }

    @Override
    public boolean isDefinedScope() {
        return this.name2type != UNDEFINED_SCOPE;
    }

    @Override
    public void setDefinedScope(boolean defined) {
        this.name2type = !defined ? UNDEFINED_SCOPE : null;
    }

    public List<ClassType> getTypesInScope() {
        if (this.name2type == null || this.name2type.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassType> res = new ArrayList<ClassType>(this.name2type.size());
        for (ClassType ct : this.name2type.values()) {
            res.add(ct);
        }
        return res;
    }

    @Override
    public ClassType getTypeInScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            return null;
        }
        return this.name2type.get(name);
    }

    @Override
    public void addTypeToScope(ClassType type, String name) {
        Debug.assertNonnull((Object)type, name);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            this.name2type = new HashMap<String, ClassType>();
        }
        this.name2type.put(name, type);
    }

    @Override
    public void removeTypeFromScope(String name) {
        Debug.assertNonnull(name);
        if (this.name2type == null || this.name2type == UNDEFINED_SCOPE) {
            return;
        }
        this.name2type.remove(name);
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitCompilationUnit(this);
    }

    public String toString() {
        return "<CompilationUnit> " + this.getName();
    }
}

