/*
 * Decompiled with CFR 0.152.
 */
package recoder.java;

import recoder.java.JavaSourceElement;
import recoder.java.ProgramElement;
import recoder.java.SourceVisitor;

public class Comment
extends JavaSourceElement {
    private static final long serialVersionUID = 5919865992017191460L;
    private String text;
    private boolean prefixed;
    private boolean isContainerComment;
    private ProgramElement parent;

    public Comment() {
        this.text = "";
    }

    public Comment(String text) {
        this.setText(text);
    }

    public Comment(String text, boolean prefixed) {
        this.setText(text);
        this.setPrefixed(prefixed);
    }

    protected Comment(Comment proto) {
        super(proto);
        this.text = new String(proto.text);
        this.prefixed = proto.prefixed;
    }

    @Override
    public Comment deepClone() {
        return new Comment(this);
    }

    public boolean isPrefixed() {
        return this.prefixed;
    }

    public boolean isContainerComment() {
        return this.isContainerComment;
    }

    public void setPrefixed(boolean prefixed) {
        this.prefixed = prefixed;
        this.isContainerComment = false;
    }

    public void setContainerComment(boolean isContainerComment) {
        this.isContainerComment = isContainerComment;
        this.prefixed = false;
    }

    public void setParent(ProgramElement p) {
        this.parent = p;
    }

    public ProgramElement getParent() {
        return this.parent;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void accept(SourceVisitor v) {
        v.visitComment(this);
    }

    public String toString() {
        int min = Math.min(this.text.length(), this.text.indexOf(10));
        if (min > 10) {
            min = 10;
        }
        if (min == -1) {
            min = this.text.length();
        }
        return "<Comment> " + this.text.substring(0, min);
    }
}

