/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.io.ClassFileRepository;
import recoder.io.PathList;
import recoder.io.PropertyNames;
import recoder.java.JavaProgramFactory;
import recoder.service.DefaultErrorHandler;
import recoder.service.ErrorHandler;
import recoder.util.FileUtils;

public class ProjectSettings
extends AbstractService
implements PropertyNames {
    private Properties defaults;
    private Properties locationSpecificVersionProperties;
    private Properties properties;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private PathList searchPathList;
    private ErrorHandler errorHandler;
    private static FileFilter jarFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getPath().endsWith(".jar");
        }
    };

    private String getSystemProperty(String propertyName) {
        try {
            return System.getProperty(propertyName);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private void setDefault(String propertyName, String defaultValue) {
        String v = this.getSystemProperty(propertyName);
        if (v == null) {
            v = defaultValue;
        } else {
            this.properties.put(propertyName, v);
        }
        this.defaults.put(propertyName, v);
    }

    public ProjectSettings(ServiceConfiguration config) {
        super(config);
        this.defaults = new Properties();
        this.properties = new Properties(this.defaults);
        this.locationSpecificVersionProperties = new Properties();
        String classpath = this.getSystemProperty("input.path");
        if (classpath == null) {
            classpath = this.getSystemProperty("java.class.path");
            classpath = classpath == null ? "" : this.normalizeSearchPath(classpath);
        } else {
            classpath = this.normalizeSearchPath(classpath);
            this.properties.put("input.path", classpath);
        }
        this.defaults.put("input.path", classpath);
        String defaultPath = this.getSystemProperty("user.dir");
        if (defaultPath == null) {
            defaultPath = ".";
        }
        this.setDefault("output.path", defaultPath);
        this.setDefault("class.search.mode", "sc");
        this.setDefault("error.threshold", "20");
        this.setDefault("jdk1.4", "true");
        this.setDefault("java5", "true");
        this.setDefault("extra_newline_at_end_of_file", "true");
        this.setDefault("indentationAmount", "4");
        this.setDefault("overwriteParsePositions", "false");
        this.setDefault("wrappingThreshold", "78");
        this.setDefault("overwriteIndentation", "false");
        this.setDefault("glueStatementBlocks", "true");
        this.setDefault("glueSequentialBranches", "true");
        this.setDefault("glueControlExpressions", "false");
        this.setDefault("glueParameterLists", "true");
        this.setDefault("glueParameters", "false");
        this.setDefault("glueParameterParentheses", "true");
        this.setDefault("glueExpressionParentheses", "true");
        this.setDefault("glueInitializerParentheses", "false");
        this.setDefault("glueInfixOperators", "false");
        this.setDefault("glueUnaryOperators", "true");
        this.setDefault("glueMembers", "false");
        this.setDefault("glueLabels", "false");
        this.setDefault("alignLabels", "true");
        this.setDefault("glueDeclarationAppendices", "false");
        this.setDefault("TabSize", "4");
        this.setDefault("useOldBytecodeParser", "false");
        this.setErrorHandler(null);
        this.searchPathList = new PathList(classpath);
    }

    public final boolean java5Allowed() {
        return Boolean.valueOf(this.properties.getProperty("java5"));
    }

    public String setProperty(String key, String value) {
        String oldValue = this.properties.getProperty(key);
        if (!value.equals(oldValue)) {
            if ("input.path".equals(key)) {
                value = this.normalizeSearchPath(value);
                this.searchPathList = new PathList(value);
            } else if ("error.threshold".equals(key)) {
                if (this.errorHandler != null) {
                    this.errorHandler.setErrorThreshold(Integer.parseInt(value));
                }
            } else if ("TabSize".equals(key)) {
                ((JavaProgramFactory)this.getServiceConfiguration().getProgramFactory()).getParser().setTabSize(Integer.parseInt(value));
            }
            this.properties.put(key, value);
            this.changes.firePropertyChange(key, oldValue, value);
        }
        return oldValue;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getDefaultProperty(String key) {
        return this.defaults.getProperty(key);
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    private String normalizeSearchPath(String pathlist) {
        if (pathlist == null) {
            return null;
        }
        HashSet<String> alreadyExisting = new HashSet<String>();
        StringBuilder newpathlist = new StringBuilder();
        pathlist = pathlist.replace('/', File.separatorChar);
        pathlist = pathlist.replace('\\', File.separatorChar);
        StringTokenizer paths = new StringTokenizer(pathlist, File.pathSeparator);
        boolean firstToken = true;
        while (paths.hasMoreTokens()) {
            String singlePath = paths.nextToken();
            if (singlePath.endsWith(String.valueOf(File.separator) + "*.jar")) {
                File[] jars;
                File[] fileArray = jars = new File(singlePath.substring(0, singlePath.length() - 5)).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    File jar = fileArray[n2];
                    String jarPath = jar.getPath();
                    if (!alreadyExisting.contains(jarPath)) {
                        if (!firstToken) {
                            newpathlist.append(File.pathSeparator);
                        }
                        newpathlist.append(jarPath);
                        alreadyExisting.add(jarPath);
                        firstToken = false;
                    }
                    ++n2;
                }
            }
            if (alreadyExisting.contains(singlePath) || !new File(singlePath).exists()) continue;
            if (!firstToken) {
                newpathlist.append(File.pathSeparator);
            }
            newpathlist.append(singlePath);
            alreadyExisting.add(singlePath);
            firstToken = false;
        }
        pathlist = newpathlist.toString();
        return pathlist;
    }

    public boolean ensureSystemClassesAreInPath() {
        ClassFileRepository cfr = this.serviceConfiguration.getClassFileRepository();
        if (cfr.findClassFile("java.lang.Object") != null) {
            return true;
        }
        File archive = FileUtils.getPathOfSystemClasses();
        if (archive == null) {
            archive = new File(".");
        }
        String classes = archive.getPath();
        String oldpath = this.getProperty("input.path");
        if (oldpath.length() == 0) {
            oldpath = ".";
        }
        this.setProperty("input.path", String.valueOf(oldpath) + File.pathSeparator + classes);
        return cfr.findClassFile("java.lang.Object") != null;
    }

    public void ensureExtensionClassesAreInPath() {
        int i;
        String extPath;
        File extDir = FileUtils.getPathOfExtensionClassesDir();
        if (extDir == null) {
            return;
        }
        String oldpath = this.getProperty("input.path");
        if (oldpath.indexOf(extPath = extDir.getPath()) != -1) {
            return;
        }
        StringBuilder additions = null;
        File[] jars = extDir.listFiles(jarFilter);
        if (jars.length > 0) {
            additions = new StringBuilder();
            i = 0;
            while (i < jars.length) {
                additions.append(String.valueOf(File.pathSeparator) + jars[i].getPath());
                ++i;
            }
        }
        if ((jars = new File(extDir + "/../").listFiles(jarFilter)).length > 0) {
            additions = new StringBuilder();
            i = 0;
            while (i < jars.length) {
                additions.append(String.valueOf(File.pathSeparator) + jars[i].getPath());
                ++i;
            }
        }
        this.setProperty("input.path", String.valueOf(oldpath) + File.pathSeparator + additions);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public PathList getSearchPathList() {
        return this.searchPathList;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            handler = new DefaultErrorHandler(Integer.parseInt(this.getProperty("error.threshold")));
        }
        if (handler != this.errorHandler) {
            if (this.errorHandler != null) {
                this.serviceConfiguration.getChangeHistory().removeModelUpdateListener(handler);
            }
            this.errorHandler = handler;
            this.serviceConfiguration.getChangeHistory().addModelUpdateListener(this.errorHandler);
        }
    }

    public Properties getLocationSpecificVersionProperties() {
        return this.locationSpecificVersionProperties;
    }
}

