/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import recoder.io.ArchiveDataLocation;
import recoder.io.DataFileLocation;
import recoder.io.DataLocation;
import recoder.io.DuplicatePathWarning;
import recoder.service.ErrorHandler;
import recoder.util.FileCollector;
import recoder.util.StringUtils;

public class PathList {
    private Map<File, Set<String>> dirContents = new HashMap<File, Set<String>>();
    private Map<File, File> knownDirs = new HashMap<File, File>();
    private final Set<String> notFound = new HashSet<String>();
    private final Map<String, DataLocation> locations = new HashMap<String, DataLocation>();
    private final List<Object> paths = new ArrayList<Object>();
    private static final File NO_FILE = new File("");

    public PathList() {
    }

    public PathList(String pathStr) {
        this.add(pathStr);
    }

    public PathList(String[] paths) {
        int i = 0;
        while (i < paths.length) {
            this.add(paths[i]);
            ++i;
        }
    }

    public void flushCaches() {
        this.dirContents.clear();
        this.knownDirs.clear();
        this.notFound.clear();
    }

    private void addPath(String path) {
        File f = new File(path);
        if (f.isFile()) {
            try {
                this.paths.add(new ZipFile(f));
            }
            catch (IOException iOException) {}
        } else if (f.isDirectory()) {
            this.paths.add(f);
        }
    }

    public int add(String pathStr) {
        int result = 0;
        if (pathStr != null) {
            String[] split_paths = StringUtils.split(pathStr, File.pathSeparatorChar);
            result = split_paths.length;
            int i = 0;
            while (i < result) {
                String path = split_paths[i].trim();
                if (!path.equals("")) {
                    this.addPath(path);
                }
                ++i;
            }
            this.notFound.clear();
        }
        return result;
    }

    protected Set<String> getContents(File directory) {
        Set<String> result = this.dirContents.get(directory);
        if (result == null) {
            result = new HashSet<String>();
            this.dirContents.put(directory, result);
            String[] list = null;
            list = directory.list();
            int i = 0;
            while (i < list.length) {
                result.add(list[i]);
                ++i;
            }
        }
        return result;
    }

    private File getDir(File parent, String name) {
        File attempt = new File(parent, name);
        File result = this.knownDirs.get(attempt);
        if (result == null) {
            result = attempt;
            if (!result.exists()) {
                result = NO_FILE;
            }
            this.knownDirs.put(attempt, result);
        }
        return result == NO_FILE ? null : result;
    }

    private DataLocation getLocation(Object p, String relativeName) {
        if (p instanceof ZipFile) {
            ZipFile zf = (ZipFile)p;
            if (zf.getEntry(relativeName) != null) {
                return new ArchiveDataLocation(zf, relativeName);
            }
            String hs = relativeName.replace(File.separatorChar, '/');
            if (zf.getEntry(hs) != null) {
                return new ArchiveDataLocation(zf, hs);
            }
        } else if (p instanceof File) {
            File dir = (File)p;
            int sep = relativeName.lastIndexOf(File.separatorChar);
            if (sep >= 0) {
                if ((dir = this.getDir(dir, relativeName.substring(0, sep))) == null) {
                    return null;
                }
                relativeName = relativeName.substring(sep + 1);
            }
            if (this.getContents(dir).contains(relativeName)) {
                return new DataFileLocation(new File(dir, relativeName));
            }
        }
        return null;
    }

    public DataLocation find(String relativeName) {
        DataLocation result = this.locations.get(relativeName);
        if (result == null && !this.notFound.contains(relativeName)) {
            int i = 0;
            while (result == null && i < this.paths.size()) {
                result = this.getLocation(this.paths.get(i), relativeName);
                ++i;
            }
            if (result != null) {
                this.locations.put(relativeName, result);
            } else {
                this.notFound.add(relativeName);
            }
        }
        return result;
    }

    public String getRelativeName(String absoluteFilename) {
        int i = 0;
        while (i < this.paths.size()) {
            String pathfilename;
            File p;
            Object o = this.paths.get(i);
            if (o instanceof File && (p = (File)o).isDirectory() && absoluteFilename.startsWith(pathfilename = p.getAbsolutePath())) {
                int pathfilenamelen = pathfilename.length();
                if (absoluteFilename.length() == pathfilenamelen) {
                    return ".";
                }
                if (pathfilename.charAt(pathfilenamelen - 1) != File.separatorChar) {
                    ++pathfilenamelen;
                }
                return absoluteFilename.substring(pathfilenamelen);
            }
            ++i;
        }
        return absoluteFilename;
    }

    public DataLocation[] findAll(String relativeName) {
        DataLocation[] tmpRes = new DataLocation[this.paths.size()];
        int count = 0;
        int i = 0;
        while (i < this.paths.size()) {
            DataLocation dl = this.getLocation(this.paths.get(i), relativeName);
            if (dl != null) {
                tmpRes[count++] = dl;
            }
            ++i;
        }
        DataLocation[] result = new DataLocation[count];
        System.arraycopy(tmpRes, 0, result, 0, count);
        return result;
    }

    public DataLocation[] findAll(FilenameFilter filter) {
        return this.findAll(filter, null);
    }

    public DataLocation[] findAll(FilenameFilter filter, ErrorHandler eh) {
        LinkedHashSet<DataLocation> res = new LinkedHashSet<DataLocation>();
        boolean reportedDublettes = false;
        int i = 0;
        int s = this.paths.size();
        while (i < s) {
            DataLocation loc;
            String name;
            Object f = this.paths.get(i);
            if (f instanceof ZipFile) {
                ZipFile zf = (ZipFile)f;
                Enumeration<? extends ZipEntry> enum2 = zf.entries();
                while (enum2.hasMoreElements()) {
                    ZipEntry e = enum2.nextElement();
                    name = e.getName();
                    if (!filter.accept(null, name)) continue;
                    loc = this.locations.get(name);
                    if (loc == null) {
                        loc = new ArchiveDataLocation(zf, name);
                        this.locations.put(name, loc);
                    }
                    if (res.add(loc) || reportedDublettes) continue;
                    if (eh != null) {
                        eh.reportError(new DuplicatePathWarning("Found a data location twice in search path: " + loc + "\nPlease check the configuration " + "of the input path. (This " + "warning is reported only once"));
                    }
                    reportedDublettes = true;
                }
            } else {
                File fi = (File)f;
                if (fi.exists()) {
                    FileCollector fc = new FileCollector(fi);
                    while (fc.next(filter)) {
                        File file = fc.getFile();
                        try {
                            name = file.getCanonicalPath();
                            loc = this.locations.get(name);
                            if (loc == null) {
                                loc = new DataFileLocation(file);
                                this.locations.put(name, loc);
                            }
                            if (res.add(loc) || reportedDublettes) continue;
                            if (eh != null) {
                                eh.reportError(new DuplicatePathWarning("Found a data location twice in search path: " + loc + "\nPlease check the configuration" + "of the input path. (This" + "warning is reported only once"));
                            }
                            reportedDublettes = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        DataLocation[] result = new DataLocation[res.size()];
        res.toArray(result);
        return result;
    }

    public String toString() {
        String result;
        if (this.paths.isEmpty()) {
            result = "";
        } else {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.paths.size()) {
                sb.append(File.pathSeparatorChar);
                Object f = this.paths.get(i);
                if (f instanceof ZipFile) {
                    sb.append(((ZipFile)f).getName());
                } else {
                    sb.append(((File)f).getPath());
                }
                ++i;
            }
            result = sb.toString().substring(1);
        }
        return result;
    }
}

