/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import recoder.AbstractService;
import recoder.ParserException;
import recoder.ServiceConfiguration;
import recoder.convenience.Naming;
import recoder.io.ArchiveDataLocation;
import recoder.io.DataFileLocation;
import recoder.io.DataLocation;
import recoder.io.PathList;
import recoder.io.ProjectSettings;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.PrettyPrinter;
import recoder.java.ProgramElement;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.PackageReference;
import recoder.service.AttachChange;
import recoder.service.ChangeHistory;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ChangeHistoryListener;
import recoder.service.DetachChange;
import recoder.service.TreeChange;
import recoder.util.Debug;
import recoder.util.ProgressListener;
import recoder.util.ProgressListenerManager;

public class DefaultSourceFileRepository
extends AbstractService
implements SourceFileRepository,
ChangeHistoryListener,
PropertyChangeListener {
    private static final boolean DEBUG = false;
    private final Map<DataLocation, CompilationUnit> location2cu = new HashMap<DataLocation, CompilationUnit>();
    private final Set<CompilationUnit> changedUnits = new HashSet<CompilationUnit>();
    private final Set<DataLocation> deleteUnits = new HashSet<DataLocation>();
    private ChangeHistory changeHistory;
    private PathList searchPathList;
    private File outputPath;
    ProgressListenerManager listeners = new ProgressListenerManager(this);
    private Properties locationSpecificVersion;
    public static final FilenameFilter JAVA_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".java");
        }
    };

    public DefaultSourceFileRepository(ServiceConfiguration config) {
        super(config);
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        this.changeHistory = cfg.getChangeHistory();
        this.changeHistory.addChangeHistoryListener(this);
        ProjectSettings settings = cfg.getProjectSettings();
        settings.addPropertyChangeListener(this);
        this.searchPathList = settings.getSearchPathList();
        this.outputPath = new File(settings.getProperty("output.path"));
        this.locationSpecificVersion = settings.getLocationSpecificVersionProperties();
    }

    protected final PathList getSearchPathList() {
        return this.searchPathList;
    }

    protected final File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this.listeners.addProgressListener(l);
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.listeners.removeProgressListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("input.path")) {
            this.searchPathList = this.serviceConfiguration.getProjectSettings().getSearchPathList();
        } else if (changedProp.equals("output.path")) {
            this.outputPath = new File(this.serviceConfiguration.getProjectSettings().getProperty("output.path"));
        }
    }

    private void deregister(CompilationUnit cu) {
        DataLocation loc = cu.getDataLocation();
        if (loc != null && this.location2cu.get(loc) == cu) {
            this.location2cu.remove(loc);
            this.changedUnits.remove(cu);
            DataLocation orig = cu.getOriginalDataLocation();
            if (!loc.equals(orig)) {
                this.deleteUnits.add(loc);
            }
        }
    }

    private void register(CompilationUnit cu) {
        DataLocation loc = cu.getDataLocation();
        if (loc == null) {
            this.changedUnits.add(cu);
            loc = this.createDataLocation(cu);
            cu.setDataLocation(loc);
        }
        if (this.location2cu.get(loc) != cu) {
            this.deleteUnits.remove(loc);
            this.location2cu.put(loc, cu);
        }
    }

    private boolean isPartOfUnitName(ProgramElement pe) {
        if (pe instanceof Identifier || pe instanceof PackageReference) {
            return this.isPartOfUnitName(pe.getASTParent());
        }
        if (pe instanceof PackageSpecification) {
            return true;
        }
        if (pe instanceof TypeDeclaration) {
            NonTerminalProgramElement parent = pe.getASTParent();
            return parent instanceof CompilationUnit && ((CompilationUnit)parent).getPrimaryTypeDeclaration() == pe;
        }
        return false;
    }

    @Override
    public void modelChanged(ChangeHistoryEvent changes) {
        List<TreeChange> changed = changes.getChanges();
        int i = changed.size() - 1;
        while (i >= 0) {
            CompilationUnit cu;
            TreeChange tc = changed.get(i);
            ProgramElement pe = tc.getChangeRoot();
            if (pe == (cu = tc.getCompilationUnit())) {
                if (tc instanceof AttachChange) {
                    this.register(cu);
                } else if (tc instanceof DetachChange) {
                    this.deregister(cu);
                }
            } else {
                DataLocation loc2;
                DataLocation loc;
                if (this.isPartOfUnitName(pe) && !(loc = cu.getDataLocation()).equals(loc2 = this.createDataLocation(cu))) {
                    this.deregister(cu);
                    cu.setDataLocation(loc2);
                    this.register(cu);
                }
                this.changedUnits.add(cu);
            }
            if (cu == null) {
                Debug.log("Null Unit changed in " + tc);
            }
            --i;
        }
    }

    @Override
    public DataLocation findSourceFile(String classname) {
        String file = Naming.dot(Naming.makeFilename(classname), "java");
        return this.getSearchPathList().find(file);
    }

    protected CompilationUnit getCompilationUnitFromLocation(DataLocation loc) {
        Reader reader;
        String version;
        CompilationUnit result;
        block5: {
            Debug.assertNonnull((Object)loc, "Null location for compilation unit");
            result = this.location2cu.get(loc);
            if (result != null) {
                return result;
            }
            String locationStr = loc.toString();
            version = null;
            for (String string : this.locationSpecificVersion.keySet()) {
                if (!locationStr.startsWith(string)) continue;
                version = (String)this.locationSpecificVersion.get(string);
            }
            if (loc.hasReaderSupport() && (reader = loc.getReader()) != null) break block5;
            Debug.error("Location of source file provides no reader");
            return null;
        }
        try {
            result = version != null ? this.serviceConfiguration.getProgramFactory().parseCompilationUnit(reader, version) : this.serviceConfiguration.getProgramFactory().parseCompilationUnit(reader);
            reader.close();
            loc.readerClosed();
            result.setDataLocation(loc);
            this.location2cu.put(loc, result);
            this.changeHistory.attached(result);
        }
        catch (Throwable e) {
            this.getServiceConfiguration().getProjectSettings().getErrorHandler().reportError(new Exception(String.valueOf(e.getClass().getSimpleName()) + " occured while parsing " + loc + "\n" + e.getMessage()));
        }
        return result;
    }

    @Override
    public CompilationUnit getCompilationUnitFromFile(String filename) {
        String newfilename;
        Debug.assertNonnull(filename);
        File f = new File(filename);
        DataLocation loc = null;
        loc = f.isFile() && f.isAbsolute() ? ((newfilename = this.getSearchPathList().getRelativeName(filename)).equals(filename) ? new DataFileLocation(f) : this.getSearchPathList().find(newfilename)) : this.getSearchPathList().find(filename);
        return loc != null ? this.getCompilationUnitFromLocation(loc) : null;
    }

    @Override
    public List<CompilationUnit> getCompilationUnitsFromFiles(String[] filenames) {
        Debug.assertNonnull(filenames);
        ArrayList<CompilationUnit> res = new ArrayList<CompilationUnit>();
        this.listeners.fireProgressEvent(0, filenames.length, "Importing Source Files");
        int i = 0;
        while (i < filenames.length) {
            this.listeners.fireProgressEvent(i, "Parsing " + filenames[i].toString());
            CompilationUnit cu = this.getCompilationUnitFromFile(filenames[i]);
            if (cu != null) {
                res.add(cu);
            }
            ++i;
        }
        this.listeners.fireProgressEvent(filenames.length);
        return res;
    }

    @Override
    public CompilationUnit getCompilationUnit(String classname) {
        DataLocation loc = this.findSourceFile(classname);
        if (loc == null || loc instanceof ArchiveDataLocation) {
            return null;
        }
        return this.getCompilationUnitFromLocation(loc);
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        this.changeHistory.updateModel();
        return this.getKnownCompilationUnits();
    }

    @Override
    public List<CompilationUnit> getKnownCompilationUnits() {
        int n = this.location2cu.size();
        ArrayList<CompilationUnit> res = new ArrayList<CompilationUnit>(n);
        for (CompilationUnit cu : this.location2cu.values()) {
            res.add(cu);
        }
        return res;
    }

    @Override
    public List<CompilationUnit> getAllCompilationUnitsFromPath() throws ParserException {
        return this.getAllCompilationUnitsFromPath(JAVA_FILENAME_FILTER);
    }

    @Override
    public List<CompilationUnit> getAllCompilationUnitsFromPath(FilenameFilter filter) {
        DataLocation[] locations = this.getSearchPathList().findAll(filter, this.getServiceConfiguration().getProjectSettings().getErrorHandler());
        ArrayList<CompilationUnit> res = new ArrayList<CompilationUnit>(locations.length);
        this.listeners.fireProgressEvent(0, res.size(), "Importing Source Files From Path");
        int i = 0;
        while (i < locations.length) {
            this.listeners.fireProgressEvent(i, "Parsing " + locations[i]);
            CompilationUnit cu = this.getCompilationUnitFromLocation(locations[i]);
            res.add(cu);
            ++i;
        }
        this.listeners.fireProgressEvent(locations.length);
        return res;
    }

    @Override
    public boolean isUpToDate(CompilationUnit cu) {
        Debug.assertNonnull(cu);
        if (cu.getDataLocation() == null) {
            return false;
        }
        return !this.changedUnits.contains(cu);
    }

    protected DataLocation createDataLocation(CompilationUnit cu) {
        String filename = Naming.toCanonicalFilename(cu);
        File f = new File(this.getOutputPath(), filename);
        return new DataFileLocation(f);
    }

    private void printUnit(CompilationUnit cu) throws IOException {
        File f;
        File parent;
        DataLocation location = cu.getDataLocation();
        if (location == null || cu.getOriginalDataLocation() == location) {
            if (location != null) {
                this.location2cu.remove(location);
            }
            location = this.createDataLocation(cu);
            cu.setDataLocation(location);
            this.location2cu.put(location, cu);
        }
        if (!location.isWritable()) {
            throw new IOException("Data location for " + location + " is not writable");
        }
        if (location instanceof DataFileLocation && !(parent = new File((f = ((DataFileLocation)location).getFile()).getParent())).exists()) {
            parent.mkdirs();
        }
        Writer w = location.getWriter();
        PrettyPrinter pprinter = this.serviceConfiguration.getProgramFactory().getPrettyPrinter(w);
        cu.accept(pprinter);
        w.flush();
        w.close();
        location.writerClosed();
    }

    @Override
    public void print(CompilationUnit cu) throws IOException {
        Debug.assertNonnull(cu);
        this.printUnit(cu);
        this.changedUnits.remove(cu);
    }

    @Override
    public void printAll(boolean always) throws IOException {
        this.changeHistory.updateModel();
        int size = always ? this.location2cu.size() : this.changedUnits.size();
        this.listeners.fireProgressEvent(0, size, "Exporting Source Files");
        CompilationUnit[] units = new CompilationUnit[size];
        int j = 0;
        for (CompilationUnit cu : always ? this.location2cu.values() : this.changedUnits) {
            units[j++] = cu;
        }
        int i = 0;
        while (i < size) {
            this.printUnit(units[i]);
            this.listeners.fireProgressEvent(i + 1, units[i]);
            ++i;
        }
        this.changedUnits.clear();
    }

    @Override
    public void cleanUp() {
        for (DataLocation loc : this.deleteUnits) {
            if (!(loc instanceof DataFileLocation)) continue;
            File f = ((DataFileLocation)loc).getFile();
            f.delete();
        }
        this.deleteUnits.clear();
    }

    public String information() {
        return this.location2cu.size() + " compilation units (" + this.changedUnits.size() + " currently changed)";
    }
}

