/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import recoder.ServiceConfiguration;
import recoder.convenience.Naming;
import recoder.io.ProjectFileIO;
import recoder.io.ProjectSettings;
import recoder.io.PropertyNames;
import recoder.java.CompilationUnit;
import recoder.util.FileUtils;

public class DefaultProjectFileIO
extends ProjectFileIO
implements PropertyNames {
    private File file;

    public DefaultProjectFileIO(ServiceConfiguration system, File projectFile) {
        super(system);
        if (projectFile == null) {
            throw new IllegalArgumentException("Null project file");
        }
        this.file = projectFile;
    }

    public File getProjectFile() {
        return this.file;
    }

    @Override
    public String[] load() throws IOException {
        String[] res;
        FileInputStream in = new FileInputStream(this.file);
        Properties props = new Properties();
        props.load(in);
        ProjectSettings ps = this.getProjectSettings();
        Enumeration<?> enum2 = props.propertyNames();
        while (enum2.hasMoreElements()) {
            String key = (String)enum2.nextElement();
            String oldValue = ps.getProperty(key);
            String newValue = props.getProperty(key);
            if (key.equals("output.path")) {
                newValue = this.resolveFilename(this.file.getParent(), newValue);
            } else if (key.equals("input.path")) {
                newValue = this.resolvePathnames(this.file.getParent(), newValue);
            }
            if (oldValue != null && newValue.equals(oldValue)) continue;
            ps.setProperty(key, newValue);
        }
        String prop = props.getProperty("units");
        if (prop == null) {
            res = new String[]{};
        } else {
            StringTokenizer unitNames = new StringTokenizer(prop, ", \n");
            ArrayList<String> v = new ArrayList<String>();
            while (unitNames.hasMoreTokens()) {
                String filename = unitNames.nextToken();
                if (filename == null || filename.length() <= 0) continue;
                filename = filename.replace('/', File.separatorChar);
                v.add(filename);
            }
            res = v.toArray(new String[v.size()]);
        }
        ((InputStream)in).close();
        return res;
    }

    private String resolveFilename(String parentDir, String relativePath) {
        if (parentDir == null || parentDir.length() == 0 || new File(relativePath).isAbsolute()) {
            return relativePath;
        }
        String result = String.valueOf(parentDir) + File.separatorChar + relativePath;
        return result;
    }

    private String resolvePathnames(String parentDir, String relativePathList) {
        StringBuilder newpath = new StringBuilder();
        if (File.pathSeparatorChar == ':') {
            relativePathList = relativePathList.replace(';', ':');
        } else if (File.pathSeparatorChar == ';' && relativePathList.indexOf(":\\") == -1 && relativePathList.indexOf(":/") == -1) {
            relativePathList = relativePathList.replace(':', ';');
        }
        StringTokenizer paths = new StringTokenizer(relativePathList, File.pathSeparator);
        boolean firstToken = true;
        while (paths.hasMoreTokens()) {
            String filename = paths.nextToken();
            if (!firstToken) {
                newpath.append(File.pathSeparator);
            }
            newpath.append(this.resolveFilename(parentDir, filename));
            firstToken = false;
        }
        return newpath.toString();
    }

    @Override
    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.file);
        StringBuilder units = new StringBuilder(1024);
        List<CompilationUnit> cus = this.getSourceFileRepository().getCompilationUnits();
        int i = 0;
        int s = cus.size();
        while (i < s) {
            CompilationUnit cu = cus.get(i);
            units.append(Naming.toCanonicalFilename(cu).replace(File.separatorChar, '/'));
            if (i < s - 1) {
                units.append(',');
            }
            ++i;
        }
        Properties properties = this.getProjectSettings().getProperties();
        properties.put("units", units.toString());
        String path = properties.getProperty("output.path");
        path = FileUtils.getRelativePath(FileUtils.getUserDirectory(), new File(path));
        properties.put("output.path", path);
        path = properties.getProperty("input.path");
        StringBuilder newpath = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (true) {
            newpath.append(FileUtils.getRelativePath(FileUtils.getUserDirectory(), new File(tok.nextToken())));
            if (!tok.hasMoreTokens()) break;
            newpath.append(File.pathSeparator);
        }
        properties.put("input.path", newpath.toString());
        properties.store(out, "RECODER Project File");
        ((OutputStream)out).close();
    }
}

