/*
 * Decompiled with CFR 0.152.
 */
package recoder.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.bytecode.ASMBytecodeParser;
import recoder.bytecode.AbstractBytecodeParser;
import recoder.bytecode.ByteCodeParser;
import recoder.bytecode.ClassFile;
import recoder.convenience.Naming;
import recoder.io.ClassFileRepository;
import recoder.io.DataLocation;
import recoder.io.PathList;
import recoder.io.ProjectSettings;
import recoder.service.ErrorHandler;
import recoder.util.Debug;

public class DefaultClassFileRepository
extends AbstractService
implements ClassFileRepository,
PropertyChangeListener {
    private final Map<String, ClassFile> classname2cf = new HashMap<String, ClassFile>(64);
    private PathList searchPathList;

    public DefaultClassFileRepository(ServiceConfiguration config) {
        super(config);
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        ProjectSettings settings = cfg.getProjectSettings();
        settings.addPropertyChangeListener(this);
        this.searchPathList = settings.getSearchPathList();
    }

    protected final PathList getSearchPathList() {
        return this.searchPathList;
    }

    ErrorHandler getErrorHandler() {
        return this.serviceConfiguration.getProjectSettings().getErrorHandler();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("input.path")) {
            this.searchPathList = this.serviceConfiguration.getProjectSettings().getSearchPathList();
        }
    }

    @Override
    public DataLocation findClassFile(String classname) {
        return this.getSearchPathList().find(Naming.dot(Naming.makeFilename(classname), "class"));
    }

    @Override
    public ClassFile getClassFile(String classname) {
        ClassFile result = this.classname2cf.get(classname);
        if (result != null) {
            return result;
        }
        DataLocation loc = this.findClassFile(classname);
        if (loc == null) {
            String innername = classname;
            int ldp = innername.length() - 1;
            StringBuilder sb = new StringBuilder(innername);
            do {
                if ((ldp = innername.lastIndexOf(46, ldp)) == -1) {
                    return null;
                }
                sb.setCharAt(ldp, '$');
                innername = sb.toString();
                result = this.classname2cf.get(innername);
                if (result == null) continue;
                return result;
            } while ((loc = this.findClassFile(innername)) == null);
            classname = innername;
        }
        try {
            InputStream is = loc.getInputStream();
            Debug.assertNonnull((Object)is, "No input stream for data location");
            AbstractBytecodeParser bytecodeParser = this.useOldBytecodeParser() ? new ByteCodeParser() : new ASMBytecodeParser();
            boolean readJava5Signatures = this.serviceConfiguration.getProjectSettings().java5Allowed();
            result = bytecodeParser.parseClassFile(is, loc.toString(), readJava5Signatures);
            is.close();
            loc.inputStreamClosed();
            this.classname2cf.put(classname, result);
        }
        catch (IOException e) {
            this.getErrorHandler().reportError(e);
            result = null;
        }
        return result;
    }

    private boolean useOldBytecodeParser() {
        return Boolean.valueOf(this.serviceConfiguration.getProjectSettings().getProperty("useOldBytecodeParser"));
    }

    @Override
    public List<ClassFile> getKnownClassFiles() {
        int n = this.classname2cf.size();
        ArrayList<ClassFile> res = new ArrayList<ClassFile>(n);
        for (ClassFile cf : this.classname2cf.values()) {
            res.add(cf);
        }
        return res;
    }

    public String information() {
        return this.classname2cf.size() + " class files";
    }

    public void reset() {
        this.classname2cf.clear();
    }
}

