/*
 * Decompiled with CFR 0.152.
 */
package recoder.convenience;

import recoder.abstraction.ArrayType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.Naming;

public class NameGenerator {
    public static final int SHORT_STYLE = -1;
    public static final int DEFAULT_STYLE = 0;
    public static final int LONG_STYLE = 1;
    private int attempt = 0;
    private String[] derivates;

    public NameGenerator(String base) {
        this(base, 0);
    }

    public NameGenerator(String base, int strategy) {
        this.guessNames(base, strategy);
    }

    public NameGenerator(Type type) {
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getBaseType();
        }
        if (type instanceof PrimitiveType) {
            this.guessNames(type.getName(), -1);
        } else {
            this.guessNames(type.getName(), 0);
        }
    }

    public String getNextCandidate() {
        String res = this.attempt < this.derivates.length ? this.derivates[this.attempt] : String.valueOf(this.derivates[0]) + (2 + this.attempt - this.derivates.length);
        ++this.attempt;
        return res;
    }

    private static String[] getLetters(String base) {
        char c = Character.toLowerCase(base.charAt(0));
        if (c < 'y') {
            return new String[]{base, "" + (char)(c + '\u0001'), "" + (char)(c + 2)};
        }
        if (c < 'z') {
            return new String[]{base, "" + (char)(c + '\u0001')};
        }
        return new String[]{base};
    }

    private void guessNames(String base, int strategy) {
        String[] words = NameGenerator.separateWords(base);
        int len = words.length;
        if (strategy == 0) {
            strategy = len >= 4 ? -1 : 1;
        }
        String[][] shortCuts = new String[len][];
        int i = 0;
        while (i < len) {
            shortCuts[i] = NameGenerator.deriveShortCuts(i, words);
            ++i;
        }
        if (strategy == -1) {
            StringBuilder res = new StringBuilder(len);
            int i2 = 0;
            while (i2 < len) {
                res.append(shortCuts[i2][0]);
                ++i2;
            }
            this.derivates = len == 1 ? NameGenerator.getLetters(res.toString()) : new String[]{res.toString()};
        } else {
            int c = 1;
            int i3 = 0;
            while (i3 < len) {
                c += shortCuts[i3].length - 1;
                ++i3;
            }
            this.derivates = new String[c];
            c = 0;
            i3 = 0;
            while (i3 < len) {
                int k = shortCuts[i3].length - (i3 == 0 ? 1 : 2);
                while (k >= 0) {
                    StringBuilder buf = new StringBuilder();
                    int j = 0;
                    while (j < i3) {
                        buf.append(shortCuts[j][0]);
                        ++j;
                    }
                    buf.append(shortCuts[i3][k]);
                    j = i3 + 1;
                    while (j < len) {
                        buf.append(words[j]);
                        ++j;
                    }
                    this.derivates[c++] = buf.toString();
                    --k;
                }
                ++i3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String[] separateWords(String base) {
        len = base.length();
        buf = new StringBuilder[(len + 1) / 2];
        w = 0;
        buf[w] = new StringBuilder();
        buf[w].append(base.charAt(0));
        i = 1;
        while (i < len - 1) {
            c = base.charAt(i);
            if (!Character.isUpperCase(c)) ** GOTO lbl-1000
            d = base.charAt(i - 1);
            e = base.charAt(i + 1);
            if (Character.isLowerCase(e) || e == '_' || Character.isLowerCase(d)) {
                buf[++w] = new StringBuilder();
                buf[w].append(c);
            } else lbl-1000:
            // 2 sources

            {
                buf[w].append(c);
            }
            ++i;
        }
        buf[w].append(base.charAt(len - 1));
        res = new String[w + 1];
        j = 0;
        while (j <= w) {
            res[j] = buf[j].toString();
            ++j;
        }
        return res;
    }

    private static boolean isVowel(char c) {
        return (c = Character.toLowerCase(c)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    private static String removeVowels(String str) {
        int len = str.length();
        StringBuilder res = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (!NameGenerator.isVowel(c)) {
                res.append(c);
            }
            ++i;
        }
        return res.toString();
    }

    private static String[] deriveShortCuts(int index, String[] words) {
        String s;
        String s2;
        String base = words[index];
        int len = base.length();
        String[] res = new String[6];
        int w = 0;
        char c0 = base.charAt(0);
        if (Character.isUpperCase(c0) && !Naming.isKeyword(s2 = base.toLowerCase())) {
            res[w++] = s2;
        }
        if (len > 3) {
            char c2;
            String s3;
            String bs;
            String s4;
            char c1 = base.charAt(1);
            if (!NameGenerator.isVowel(c1) && !Naming.isKeyword(s4 = base.substring(0, 2).toLowerCase())) {
                res[w++] = s4;
            }
            if (!NameGenerator.isVowel(c0) && ((bs = NameGenerator.removeVowels(base)).length() == 2 || bs.length() == 3 && len > 4) && !Naming.isKeyword(s3 = bs.toLowerCase())) {
                res[w++] = s3;
            }
            if (len > 4 && !NameGenerator.isVowel(c2 = base.charAt(2)) && !Naming.isKeyword(s3 = base.substring(0, 3).toLowerCase())) {
                res[w++] = s3;
            }
        }
        char lc0 = Character.toLowerCase(c0);
        if ((len > 1 || Character.isUpperCase(c0)) && !Naming.isKeyword(s = "" + lc0)) {
            res[w++] = s;
        }
        int i = 1;
        while (i < w) {
            String x = res[i];
            int j = i - 1;
            int xlen = x.length();
            while (j >= 0 && res[j].length() > xlen) {
                res[j + 1] = res[j];
                --j;
            }
            if (j >= 0 && res[j].equals(x)) {
                ++j;
                --w;
                --i;
                while (j < len) {
                    res[j] = res[j + 1];
                    ++j;
                }
            } else {
                res[j + 1] = x;
            }
            ++i;
        }
        String[] result = new String[w];
        int i2 = 0;
        while (i2 < w) {
            result[i2] = res[i2];
            ++i2;
        }
        return result;
    }
}

