/*
 * Decompiled with CFR 0.152.
 */
package recoder.convenience;

import java.util.List;
import recoder.ModelElement;
import recoder.NamedModelElement;
import recoder.abstraction.Method;
import recoder.abstraction.ProgramModelElement;
import recoder.convenience.Naming;
import recoder.java.CompilationUnit;
import recoder.java.Identifier;
import recoder.java.JavaProgramElement;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.reference.ReferencePrefix;
import recoder.kit.UnitKit;
import recoder.util.Debug;

public class Format {
    private Format() {
    }

    public static String toString(String formatText, ModelElement e) {
        Debug.assertNonnull(formatText);
        StringBuilder res = new StringBuilder();
        int len = formatText.length();
        int i = 0;
        while (i < len) {
            char c = formatText.charAt(i);
            if (c != '%' || i == len - 1) {
                res.append(c);
            } else {
                int columns = 1;
                if ((c = formatText.charAt(++i)) >= '0' && c <= '9' && i < len - 1) {
                    columns = Math.max(1, c - 48);
                    c = formatText.charAt(++i);
                }
                switch (c) {
                    case 'n': {
                        if (e instanceof NamedModelElement) {
                            res.append(((NamedModelElement)e).getName());
                            break;
                        }
                        if (e instanceof Identifier) {
                            res.append(((Identifier)e).getText());
                            break;
                        }
                        if (!(e instanceof CompilationUnit)) break;
                        res.append(((CompilationUnit)e).getPrimaryTypeDeclaration().getName());
                        break;
                    }
                    case 'N': {
                        if (e instanceof NamedModelElement) {
                            if (e instanceof ProgramModelElement) {
                                res.append(((ProgramModelElement)e).getFullName());
                                if (!(e instanceof Method)) break;
                                res.append(Format.toString("%N", ((Method)e).getSignature()));
                                break;
                            }
                            if (e instanceof ReferencePrefix) {
                                res.append(Naming.toPathName((ReferencePrefix)e));
                                break;
                            }
                            res.append(((NamedModelElement)e).getName());
                            break;
                        }
                        if (e instanceof Identifier) {
                            res.append(((Identifier)e).getText());
                            break;
                        }
                        if (!(e instanceof CompilationUnit)) break;
                        res.append(Naming.toCanonicalName((CompilationUnit)e));
                        break;
                    }
                    case 'm': {
                        if (e instanceof NamedModelElement) {
                            res.append(((NamedModelElement)e).getName());
                            if (!(e instanceof Method)) break;
                            res.append(Format.toString("%N", ((Method)e).getSignature()));
                            break;
                        }
                        if (e instanceof Identifier) {
                            res.append(((Identifier)e).getText());
                            break;
                        }
                        if (!(e instanceof CompilationUnit)) break;
                        res.append(((CompilationUnit)e).getPrimaryTypeDeclaration().getName());
                        break;
                    }
                    case 's': {
                        if (!(e instanceof SourceElement)) break;
                        res.append(((SourceElement)((Object)e)).toSource().trim());
                        if (!(e instanceof JavaProgramElement)) break;
                        res.append("(id " + ((JavaProgramElement)e).getID() + ")");
                        break;
                    }
                    case 'c': {
                        if (e == null) {
                            res.append("null");
                            break;
                        }
                        String name = e.getClass().getName();
                        res.append(name.substring(name.lastIndexOf(46) + 1));
                        break;
                    }
                    case 'C': {
                        if (e == null) {
                            res.append("null");
                            break;
                        }
                        res.append(e.getClass().getName());
                        break;
                    }
                    case 'i': {
                        if (e == null) break;
                        int id = System.identityHashCode(e);
                        if (id < 0) {
                            res.append(Long.toString((long)(id & Integer.MAX_VALUE) | 0x80000000L, 16));
                            break;
                        }
                        res.append(Integer.toString(id, 16));
                        break;
                    }
                    case 'p': {
                        if (!(e instanceof SourceElement)) break;
                        SourceElement se = (SourceElement)((Object)e);
                        if ((se = se.getFirstElement()) == null) break;
                        Format.append(se.getStartPosition(), columns, res);
                        break;
                    }
                    case 'P': {
                        SourceElement se2;
                        SourceElement se;
                        if (!(e instanceof SourceElement) || (se2 = (se = (SourceElement)((Object)e)).getFirstElement()) == null) break;
                        Format.append(se2.getStartPosition(), columns, res);
                        res.append('-');
                        se2 = se.getLastElement();
                        Format.append(se2.getEndPosition(), columns, res);
                        break;
                    }
                    case 'r': {
                        if (!(e instanceof SourceElement)) break;
                        SourceElement se = (SourceElement)((Object)e);
                        if ((se = se.getFirstElement()) == null) break;
                        Format.append(se.getRelativePosition(), columns, res);
                        break;
                    }
                    case 'u': {
                        CompilationUnit cu;
                        if (!(e instanceof ProgramElement) || (cu = UnitKit.getCompilationUnit((ProgramElement)e)) == null) break;
                        res.append(Naming.toCanonicalName(cu));
                        break;
                    }
                    case 'f': {
                        CompilationUnit cu;
                        if (!(e instanceof ProgramElement) || (cu = UnitKit.getCompilationUnit((ProgramElement)e)) == null) break;
                        res.append(cu.getDataLocation());
                        break;
                    }
                    default: {
                        res.append('%').append(c);
                    }
                }
            }
            ++i;
        }
        return res.toString();
    }

    private static void append(SourceElement.Position pos, int columns, StringBuilder buf) {
        int k = 1;
        int i = columns;
        while (i > 1) {
            --i;
            k *= 10;
        }
        int line = -1;
        int col = -1;
        if (pos != SourceElement.Position.UNDEFINED) {
            line = pos.getLine();
            col = pos.getColumn();
        }
        int j = Math.max(1, line);
        while (j < k) {
            buf.append(' ');
            j *= 10;
        }
        if (line == -1) {
            buf.append('?');
        } else {
            buf.append(line);
        }
        buf.append('/');
        j = Math.max(1, col);
        while (j < k) {
            buf.append(' ');
            j *= 10;
        }
        if (col == -1) {
            buf.append('?');
        } else {
            buf.append(col);
        }
    }

    public static String toString(String formatText, List<? extends ModelElement> l) {
        return Format.toString(formatText, "(", ", ", ")", l);
    }

    public static String toString(String formatText, String header, String separator, String footer, List<? extends ModelElement> l) {
        if (l == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(header);
        int s = l.size();
        if (s > 0) {
            sb.append(Format.toString(formatText, l.get(0)));
            int i = 1;
            while (i < s) {
                sb.append(separator);
                sb.append(Format.toString(formatText, l.get(i)));
                ++i;
            }
        }
        sb.append(footer);
        return sb.toString();
    }

    public static String toString(ProgramElement se) {
        return Format.toString("\"%s\" @%p [%f]", se);
    }

    public static String toString(List<? extends ModelElement> l) {
        return Format.toString("\"%s\" @%p", l);
    }
}

