/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.util.List;
import recoder.ModelException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.convenience.Naming;
import recoder.service.ProgramModelInfo;

public class TypeParameterInfo
implements TypeParameter,
ClassType {
    private String name;
    private String[] boundNames;
    private List<TypeArgumentInfo>[] boundArgs;
    private ClassTypeContainer container;
    private ArrayType arrayType;
    private ErasedType erasedType = null;

    public TypeParameterInfo(String name, String[] boundNames, List<TypeArgumentInfo>[] boundArgs, ClassTypeContainer container) {
        this.name = name.intern();
        this.boundNames = boundNames;
        this.boundArgs = boundArgs;
        this.container = container;
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.container.getProgramModelInfo().getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    void setContainer(MethodInfo mi) {
        this.container = mi;
    }

    @Override
    public String getFullName() {
        return Naming.dot(this.container.getFullName(), this.name);
    }

    @Override
    public String getBinaryName() {
        return String.valueOf(this.getContainingClassType().getBinaryName()) + "." + this.getName();
    }

    @Override
    public ProgramModelInfo getProgramModelInfo() {
        return this.container.getProgramModelInfo();
    }

    @Override
    public void setProgramModelInfo(ProgramModelInfo pmi) {
        throw new UnsupportedOperationException(String.valueOf(pmi.getClass().getName()) + " should not be set for TypeParamterInfo");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void validate() throws ModelException {
    }

    @Override
    public String getParameterName() {
        return this.name;
    }

    @Override
    public int getBoundCount() {
        return this.boundNames.length;
    }

    @Override
    public String getBoundName(int boundidx) {
        return this.boundNames[boundidx];
    }

    public List<TypeArgumentInfo> getBoundTypeArguments(int boundidx) {
        return this.boundArgs[boundidx];
    }

    @Override
    public boolean inheritanceEqual(TypeParameter o) {
        return TypeParameter.EqualsImplementor.matchButNotEqual(this, o);
    }

    public int hashCode() {
        return this.container.hashCode() ^ this.name.hashCode();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnumType() {
        return false;
    }

    @Override
    public boolean isOrdinaryClass() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public List<ClassType> getSupertypes() {
        return this.container.getProgramModelInfo().getSupertypes(this);
    }

    @Override
    public List<ClassType> getAllSupertypes() {
        return this.container.getProgramModelInfo().getAllSupertypes(this);
    }

    public List<FieldInfo> getFields() {
        return null;
    }

    @Override
    public List<Field> getAllFields() {
        return null;
    }

    @Override
    public List<Method> getMethods() {
        return null;
    }

    @Override
    public List<Method> getAllMethods() {
        return this.container.getProgramModelInfo().getAllMethods(this);
    }

    public List<Constructor> getConstructors() {
        return null;
    }

    @Override
    public List<ClassType> getAllTypes() {
        return null;
    }

    @Override
    public List<? extends TypeParameter> getTypeParameters() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isStrictFp() {
        return false;
    }

    @Override
    public ClassType getContainingClassType() {
        return this.container instanceof ClassType ? (ClassType)this.container : null;
    }

    @Override
    public List<? extends AnnotationUse> getAnnotations() {
        return null;
    }

    public List<ClassType> getTypes() {
        return null;
    }

    @Override
    public Package getPackage() {
        return this.container.getPackage();
    }

    @Override
    public ClassTypeContainer getContainer() {
        return this.container;
    }

    @Override
    public String getFullSignature() {
        return TypeParameter.DescrImp.getFullSignature(this);
    }

    @Override
    public ErasedType getErasedType() {
        if (this.erasedType == null) {
            this.erasedType = new ErasedType(this, this.container.getProgramModelInfo().getServiceConfiguration().getImplicitElementInfo());
        }
        return this.erasedType;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public ClassType getBaseClassType() {
        return this.container.getProgramModelInfo().getServiceConfiguration().getNameInfo().getClassType(this.boundNames[0]).getBaseClassType();
    }
}

