/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.ClassFile;
import recoder.bytecode.MethodInfo;
import recoder.service.DefaultImplicitElementInfo;

public class TypeArgumentInfo
implements TypeArgument {
    final TypeArgument.WildcardMode wildcardMode;
    private final String typeName;
    final List<? extends TypeArgument> typeArgs;
    private final boolean isTypeVariable;
    private ClassType typeVariable;
    ClassTypeContainer parent;

    public TypeArgumentInfo(TypeArgument.WildcardMode wildcardMode, String typeName, List<? extends TypeArgument> typeArgs, ClassTypeContainer parent, boolean isTypeVariable) {
        if (typeName == null && wildcardMode != TypeArgument.WildcardMode.Any || wildcardMode == null || parent == null || typeName != null && wildcardMode == TypeArgument.WildcardMode.Any) {
            throw new IllegalArgumentException();
        }
        this.wildcardMode = wildcardMode;
        this.typeName = typeName != null ? typeName.intern() : null;
        this.typeArgs = typeArgs;
        this.isTypeVariable = isTypeVariable;
        this.parent = parent;
    }

    @Override
    public TypeArgument.WildcardMode getWildcardMode() {
        return this.wildcardMode;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public List<? extends TypeArgument> getTypeArguments() {
        return this.typeArgs;
    }

    public ClassType getTypeParameter() {
        if (!this.isTypeVariable) {
            return null;
        }
        if (this.typeVariable == null) {
            ClassTypeContainer ctc = this.getContainer();
            String taName = this.typeName;
            int dim = 0;
            while (taName.endsWith("[]")) {
                taName = taName.substring(0, taName.length() - 2);
                ++dim;
            }
            while (true) {
                int i;
                if (ctc instanceof MethodInfo) {
                    MethodInfo mi = (MethodInfo)ctc;
                    if (mi.getTypeParameters() != null) {
                        i = 0;
                        while (i < mi.getTypeParameters().size()) {
                            if (mi.getTypeParameters().get(i).getName().equals(taName)) {
                                ClassType res = mi.getTypeParameters().get(i);
                                while (dim-- > 0) {
                                    res = res.createArrayType();
                                }
                                this.typeVariable = res;
                                return res;
                            }
                            ++i;
                        }
                    }
                } else if (ctc instanceof ClassFile) {
                    ClassFile cf = (ClassFile)ctc;
                    if (cf.getTypeParameters() != null) {
                        i = 0;
                        while (i < cf.getTypeParameters().size()) {
                            if (cf.getTypeParameters().get(i).getName().equals(taName)) {
                                ClassType res = cf.getTypeParameters().get(i);
                                while (dim-- > 0) {
                                    res = res.createArrayType();
                                }
                                this.typeVariable = res;
                                return res;
                            }
                            ++i;
                        }
                    }
                } else {
                    throw new RuntimeException();
                }
                ctc = ctc.getContainer();
            }
        }
        return this.typeVariable;
    }

    @Override
    public boolean isTypeVariable() {
        return this.isTypeVariable;
    }

    public ClassTypeContainer getContainer() {
        return this.parent;
    }

    public ClassFile getContainingClassFile() {
        if (this.parent instanceof ClassFile) {
            return (ClassFile)this.parent;
        }
        return (ClassFile)((MethodInfo)this.parent).getContainingClassType();
    }

    public MethodInfo getContainingMethodInfo() {
        if (this.parent instanceof MethodInfo) {
            return (MethodInfo)this.parent;
        }
        return null;
    }

    @Override
    public boolean semanticalEquality(TypeArgument ta) {
        return TypeArgument.EqualsImpl.equals(this, ta, (DefaultImplicitElementInfo)this.parent.getProgramModelInfo().getServiceConfiguration().getImplicitElementInfo());
    }

    @Override
    public int semanticalHashCode() {
        return TypeArgument.EqualsImpl.semanticalHashCode(this);
    }

    @Override
    public TypeParameter getTargetedTypeParameter() {
        throw new RuntimeException("TODO");
    }

    @Override
    public String getFullSignature() {
        return TypeArgument.DescriptionImpl.getFullDescription(this);
    }
}

