/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import recoder.bytecode.AnnotationPropertyInfo;
import recoder.bytecode.ByteCodeFormatException;
import recoder.bytecode.ByteCodeParser;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;

public class ReflectionImport {
    private static String getTypeName(Class<?> c) {
        String n = c.getName();
        if (n.charAt(0) == '[') {
            try {
                n = ByteCodeParser.decodeType(n);
            }
            catch (ByteCodeFormatException bcfe) {
                System.err.println("Internal error: " + bcfe);
            }
        }
        return n;
    }

    private static String[] getTypeNames(Class<?>[] classes) {
        String[] names = new String[classes.length];
        int i = 0;
        while (i < names.length) {
            names[i] = ReflectionImport.getTypeName(classes[i]);
            ++i;
        }
        return names;
    }

    private static String getShortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static ClassFile getClassFile(String classname) {
        classname = classname.replace('$', '.');
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ClassFile cf = new ClassFile();
        String n = c.getName();
        cf.setPhysicalName(n);
        cf.setFullName(n);
        cf.setName(ReflectionImport.getShortName(n));
        Class<?> sup = c.getSuperclass();
        if (sup != null) {
            cf.setSuperName(sup.getName());
        }
        cf.setAccessFlags(c.getModifiers() | (c.isAnnotation() ? 8192 : 0) | (c.isEnum() ? 16384 : 0));
        cf.setInterfaceNames(ReflectionImport.getTypeNames(c.getInterfaces()));
        Field[] dfields = c.getDeclaredFields();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>(dfields.length);
        int i = 0;
        while (i < dfields.length) {
            Field f = dfields[i];
            int mods = f.getModifiers();
            String cvalue = null;
            if (Modifier.isFinal(mods) && Modifier.isStatic(mods)) {
                try {
                    f.setAccessible(true);
                    cvalue = f.get(null).toString();
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Encountered IllegalAccessException during reflection import! Cause: ", iae);
                }
            }
            fields.add(new FieldInfo(f.getModifiers(), f.getName(), ReflectionImport.getTypeName(f.getType()), false, cf, cvalue, null));
            ++i;
        }
        cf.setFields(fields);
        Constructor<?>[] dconstructors = c.getDeclaredConstructors();
        ArrayList<ConstructorInfo> constructors = new ArrayList<ConstructorInfo>(dconstructors.length);
        int i2 = 0;
        while (i2 < dconstructors.length) {
            Constructor<?> co = dconstructors[i2];
            constructors.add(new ConstructorInfo(co.getModifiers(), ReflectionImport.getShortName(co.getName()), ReflectionImport.getTypeNames(co.getParameterTypes()), ReflectionImport.getTypeNames(co.getExceptionTypes()), cf));
            ++i2;
        }
        cf.setConstructors(constructors);
        Method[] dmethods = c.getDeclaredMethods();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(dmethods.length);
        int i3 = 0;
        while (i3 < dmethods.length) {
            Method m = dmethods[i3];
            if (c.isAnnotation()) {
                methods.add(new AnnotationPropertyInfo(m.getModifiers(), ReflectionImport.getTypeName(m.getReturnType()), false, m.getName(), cf, m.getDefaultValue()));
            } else {
                methods.add(new MethodInfo(m.getModifiers(), ReflectionImport.getTypeName(m.getReturnType()), false, m.getName(), ReflectionImport.getTypeNames(m.getParameterTypes()), ReflectionImport.getTypeNames(m.getExceptionTypes()), cf));
            }
            ++i3;
        }
        cf.setMethods(methods);
        cf.setInnerClassNames(ReflectionImport.getTypeNames(c.getDeclaredClasses()));
        return cf;
    }
}

