/*
 * Decompiled with CFR 0.152.
 */
package recoder.bytecode;

import java.util.Collections;
import java.util.List;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ByteCodeElement;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;

public class ClassFile
extends ByteCodeElement
implements ClassType {
    boolean isInner;
    private String location;
    private String fullName;
    private String physicalName;
    private String superName;
    private String[] interfaceNames;
    private List<FieldInfo> fields;
    private List<MethodInfo> methods;
    private List<ConstructorInfo> constructors;
    private List<AnnotationUseInfo> annotations;
    private List<TypeParameterInfo> typeParams;
    private String[] innerClasses;
    List<TypeArgumentInfo> superClassTypeArguments;
    List<TypeArgumentInfo>[] superInterfacesTypeArguments;
    private ArrayType arrayType;
    String enclosingMethod = null;
    private ErasedType erasedType = null;

    ClassFile() {
    }

    @Override
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    @Override
    public ArrayType createArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this, this.service.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.arrayType;
    }

    void setFullName(String fullName) {
        this.fullName = fullName.intern();
    }

    void setPhysicalName(String phkName) {
        this.physicalName = phkName;
    }

    void setSuperName(String superName) {
        this.superName = superName;
        if (superName != null) {
            this.superName = superName.intern();
        }
    }

    void setInterfaceNames(String[] interfaceNames) {
        this.interfaceNames = interfaceNames;
        if (interfaceNames != null) {
            int i = 0;
            while (i < interfaceNames.length) {
                interfaceNames[i] = interfaceNames[i].intern();
                ++i;
            }
        }
    }

    void setFields(List<FieldInfo> fields) {
        this.fields = Collections.unmodifiableList(fields);
    }

    void setMethods(List<MethodInfo> methods) {
        this.methods = Collections.unmodifiableList(methods);
    }

    void setConstructors(List<ConstructorInfo> constructors) {
        this.constructors = Collections.unmodifiableList(constructors);
    }

    void setInnerClassNames(String[] innerClassNames) {
        this.innerClasses = innerClassNames;
        if (this.innerClasses != null) {
            int i = 0;
            while (i < innerClassNames.length) {
                innerClassNames[i] = innerClassNames[i].intern();
                ++i;
            }
        }
    }

    void setAnnotations(List<AnnotationUseInfo> annotations) {
        this.annotations = Collections.unmodifiableList(annotations);
    }

    @Override
    public final String getTypeName() {
        return this.fullName;
    }

    public final String getSuperClassName() {
        return this.superName;
    }

    public final List<TypeArgumentInfo> getSuperClassTypeArguments() {
        return this.superClassTypeArguments;
    }

    public final String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public final List<TypeArgumentInfo> getSuperInterfaceTypeArguments(int ifidx) {
        return this.superInterfacesTypeArguments == null ? null : this.superInterfacesTypeArguments[ifidx];
    }

    public final List<FieldInfo> getFieldInfos() {
        return this.fields;
    }

    public final List<MethodInfo> getMethodInfos() {
        return this.methods;
    }

    public final List<ConstructorInfo> getConstructorInfos() {
        return this.constructors;
    }

    public final String[] getInnerClassNames() {
        return this.innerClasses;
    }

    @Override
    public final String getFullName() {
        return this.fullName;
    }

    @Override
    public String getBinaryName() {
        return this.physicalName;
    }

    @Deprecated
    public final String getPhysicalName() {
        return this.physicalName;
    }

    @Override
    public final ClassTypeContainer getContainer() {
        return this.service.getClassTypeContainer(this);
    }

    @Override
    public ClassFile getContainingClassType() {
        ClassTypeContainer ctc = this.service.getClassTypeContainer(this);
        return ctc instanceof ClassFile ? (ClassFile)ctc : null;
    }

    @Override
    public final Package getPackage() {
        return this.service.getPackage(this);
    }

    @Override
    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    @Override
    public boolean isOrdinaryInterface() {
        return (this.accessFlags & 0x200) != 0 && (this.accessFlags & 0x2000) == 0;
    }

    @Override
    public boolean isAnnotationType() {
        return (this.accessFlags & 0x2000) != 0;
    }

    @Override
    public boolean isEnumType() {
        return (this.accessFlags & 0x4000) != 0;
    }

    @Override
    public boolean isOrdinaryClass() {
        return (this.accessFlags & 0x200) == 0 && (this.accessFlags & 0x4000) == 0;
    }

    @Override
    public final List<ClassType> getSupertypes() {
        return this.service.getSupertypes(this);
    }

    @Override
    public final List<ClassType> getAllSupertypes() {
        return this.service.getAllSupertypes(this);
    }

    public final List<FieldInfo> getFields() {
        return this.service.getFields(this);
    }

    @Override
    public final List<Field> getAllFields() {
        return this.service.getAllFields(this);
    }

    @Override
    public final List<Method> getMethods() {
        return this.service.getMethods(this);
    }

    @Override
    public final List<Method> getAllMethods() {
        return this.service.getAllMethods(this);
    }

    @Override
    public final List<? extends Constructor> getConstructors() {
        return this.service.getConstructors(this);
    }

    public final List<ClassFile> getTypes() {
        return this.service.getTypes(this);
    }

    @Override
    public final List<ClassType> getAllTypes() {
        return this.service.getAllTypes(this);
    }

    public List<AnnotationUseInfo> getAnnotations() {
        return this.annotations;
    }

    public List<TypeParameterInfo> getTypeParameters() {
        return this.typeParams;
    }

    public void setTypeParameters(List<TypeParameterInfo> typeParams) {
        this.typeParams = typeParams;
    }

    void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "ClassFile " + this.getFullName();
    }

    @Override
    public String getFullSignature() {
        String res = this.getFullName();
        if (this.getTypeParameters() == null || this.getTypeParameters().size() == 0) {
            return res;
        }
        res = String.valueOf(res) + "<";
        String del = "";
        for (TypeParameterInfo ta : this.getTypeParameters()) {
            res = String.valueOf(res) + del + ta.getFullSignature();
            del = ",";
        }
        res = String.valueOf(res) + ">";
        return res;
    }

    @Override
    public ErasedType getErasedType() {
        if (this.erasedType == null) {
            this.erasedType = new ErasedType(this, this.service.getServiceConfiguration().getImplicitElementInfo());
        }
        return this.erasedType;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public ClassType getBaseClassType() {
        return this;
    }

    public String getEnclosingMethod() {
        return this.enclosingMethod;
    }
}

